/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j13.stub.java_base;

import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.ProviderNotFoundException;
import java.nio.file.spi.FileSystemProvider;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import xyz.wagyourtail.jvmdg.j12.stub.java_base.J_N_F_S_FileSystemProvider;
import xyz.wagyourtail.jvmdg.version.Ref;
import xyz.wagyourtail.jvmdg.version.Stub;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class J_N_F_FileSystems {
    @Stub(ref=@Ref(value="Ljava/nio/file/FileSystems;"))
    public static FileSystem newFileSystem(Path p) throws IOException {
        return FileSystems.newFileSystem(p, (ClassLoader)null);
    }

    @Stub(ref=@Ref(value="Ljava/nio/file/FileSystems;"))
    public static FileSystem newFileSystem(Path p, Map<String, ?> env) throws IOException {
        return J_N_F_FileSystems.newFileSystem(p, env, null);
    }

    @Stub(ref=@Ref(value="Ljava/nio/file/FileSystems;"))
    public static FileSystem newFileSystem(Path p, Map<String, ?> env, ClassLoader loader) throws IOException {
        Objects.requireNonNull(p, "path");
        for (FileSystemProvider pro : FileSystemProvider.installedProviders()) {
            try {
                return J_N_F_S_FileSystemProvider.newFileSystem(pro, p, env);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
        }
        if (loader != null) {
            for (FileSystemProvider pro : ServiceLoader.load(FileSystemProvider.class, loader)) {
                try {
                    return J_N_F_S_FileSystemProvider.newFileSystem(pro, p, env);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                }
            }
        }
        throw new ProviderNotFoundException("Provider not found");
    }
}

