/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j12.stub.java_base;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Objects;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.j12.stub.java_base.J_L_C_ClassDesc;
import xyz.wagyourtail.jvmdg.j12.stub.java_base.J_L_C_ConstantDescs;
import xyz.wagyourtail.jvmdg.j12.stub.java_base.J_L_C_MethodHandleDesc;
import xyz.wagyourtail.jvmdg.j12.stub.java_base.J_L_C_MethodTypeDesc;
import xyz.wagyourtail.jvmdg.version.Adapter;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@Adapter(value="java/lang/constant/DirectMethodHandleDesc")
@NestMembers(value={1.class, DirectMethodHandleDescImpl.class, Kind.class})
public interface J_L_C_DirectMethodHandleDesc
extends J_L_C_MethodHandleDesc {
    public Kind kind();

    public int refKind();

    public boolean isOwnerInterface();

    public J_L_C_ClassDesc owner();

    public String methodName();

    public String lookupDescriptor();

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=J_L_C_DirectMethodHandleDesc.class)
    public static class DirectMethodHandleDescImpl
    implements J_L_C_DirectMethodHandleDesc {
        private final Kind kind;
        private final J_L_C_ClassDesc owner;
        private final String methodName;
        private final J_L_C_MethodTypeDesc type;

        DirectMethodHandleDescImpl(Kind kind, J_L_C_ClassDesc owner, String name, J_L_C_MethodTypeDesc type) {
            this.kind = kind;
            this.owner = owner;
            this.methodName = name;
            this.type = kind.isVirtual() ? type.insertParameterTypes(0, owner) : (kind == Kind.CONSTRUCTOR ? type.changeReturnType(owner) : type);
        }

        @Override
        public Kind kind() {
            return this.kind;
        }

        @Override
        public int refKind() {
            return this.kind.refKind;
        }

        @Override
        public boolean isOwnerInterface() {
            return this.kind.isInterface;
        }

        @Override
        public J_L_C_ClassDesc owner() {
            return this.owner;
        }

        @Override
        public String methodName() {
            return this.methodName;
        }

        @Override
        public J_L_C_MethodTypeDesc invocationType() {
            return this.type;
        }

        @Override
        public String lookupDescriptor() {
            switch (this.kind) {
                case VIRTUAL: 
                case SPECIAL: 
                case INTERFACE_SPECIAL: 
                case INTERFACE_VIRTUAL: {
                    return this.type.dropParameterTypes(0, 1).descriptorString();
                }
                case STATIC: 
                case INTERFACE_STATIC: {
                    return this.type.descriptorString();
                }
                case CONSTRUCTOR: {
                    return this.type.changeReturnType(J_L_C_ConstantDescs.CD_void).descriptorString();
                }
                case GETTER: 
                case STATIC_GETTER: {
                    return this.type.returnType().descriptorString();
                }
                case STATIC_SETTER: {
                    return this.type.parameterType(0).descriptorString();
                }
                case SETTER: {
                    return this.type.parameterType(1).descriptorString();
                }
            }
            throw new IllegalStateException("unreachable");
        }

        @Override
        public MethodHandle resolveConstantDesc(MethodHandles.Lookup lookup) throws ReflectiveOperationException {
            Object owner = this.owner.resolveConstantDesc(lookup);
            MethodType type = (MethodType)this.invocationType().resolveConstantDesc(lookup);
            switch (this.kind) {
                case STATIC: 
                case INTERFACE_STATIC: {
                    return lookup.findStatic((Class<?>)owner, this.methodName, type);
                }
                case VIRTUAL: 
                case INTERFACE_VIRTUAL: {
                    return lookup.findVirtual((Class<?>)owner, this.methodName, type.dropParameterTypes(0, 1));
                }
                case SPECIAL: 
                case INTERFACE_SPECIAL: {
                    return lookup.findSpecial((Class<?>)owner, this.methodName, type.dropParameterTypes(0, 1), lookup.lookupClass());
                }
                case CONSTRUCTOR: {
                    return lookup.findConstructor((Class<?>)owner, type.changeReturnType(Void.TYPE));
                }
                case GETTER: {
                    return lookup.findGetter((Class<?>)owner, this.methodName, (Class<?>)type.returnType());
                }
                case STATIC_GETTER: {
                    return lookup.findStaticGetter((Class<?>)owner, this.methodName, (Class<?>)type.returnType());
                }
                case SETTER: {
                    return lookup.findSetter((Class<?>)owner, this.methodName, (Class<?>)type.parameterType(1));
                }
                case STATIC_SETTER: {
                    return lookup.findStaticSetter((Class<?>)owner, this.methodName, (Class<?>)type.parameterType(0));
                }
            }
            throw new IllegalStateException("unreachable");
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DirectMethodHandleDescImpl that = (DirectMethodHandleDescImpl)o;
            return this.kind == that.kind && Objects.equals(this.owner, that.owner) && Objects.equals(this.methodName, that.methodName) && Objects.equals(this.type, that.type);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.kind, this.owner, this.methodName, this.type});
        }

        public String toString() {
            return DirectMethodHandleDescImpl.jvmdowngrader$concat$toString$1(String.valueOf((Object)this.kind), String.valueOf(this.owner), this.methodName, String.valueOf(this.type));
        }

        private static /* synthetic */ String jvmdowngrader$concat$toString$1(String string, String string2, String string3, String string4) {
            return "MethodHandleDesc[" + string + "/" + string2 + "::" + string3 + string4 + "]";
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @Adapter(value="java/lang/constant/DirectMethodHandleDesc$Kind")
    @NestHost(value=J_L_C_DirectMethodHandleDesc.class)
    public static enum Kind {
        STATIC(6),
        INTERFACE_STATIC(6, true),
        VIRTUAL(5),
        INTERFACE_VIRTUAL(9, true),
        SPECIAL(7),
        INTERFACE_SPECIAL(7, true),
        CONSTRUCTOR(8),
        GETTER(1),
        SETTER(3),
        STATIC_GETTER(2),
        STATIC_SETTER(4);

        private static final Kind[] entries;
        public final int refKind;
        public final boolean isInterface;

        private Kind(int refKind) {
            this.refKind = refKind;
            this.isInterface = false;
        }

        private Kind(int refKind, boolean isInterface) {
            this.refKind = refKind;
            this.isInterface = isInterface;
        }

        public static Kind valueOf(int refKind) {
            return Kind.valueOf(refKind, refKind == 9);
        }

        public static Kind valueOf(int refKind, boolean isInterface) {
            if (refKind < 1) {
                throw new IllegalArgumentException();
            }
            return entries[refKind - 1 << 1 | (isInterface ? 1 : 0)];
        }

        boolean isVirtual() {
            switch (this) {
                case VIRTUAL: 
                case SPECIAL: 
                case INTERFACE_SPECIAL: 
                case INTERFACE_VIRTUAL: {
                    return true;
                }
            }
            return false;
        }

        static {
            entries = new Kind[19];
            for (Kind kind : Kind.values()) {
                int index = kind.refKind - 1 << 1 | (kind.isInterface ? 1 : 0);
                if (entries[index] != null) {
                    throw new IllegalStateException();
                }
                Kind.entries[index] = kind;
            }
        }
    }
}

