/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j12.stub.java_base;

import java.lang.invoke.MethodHandles;
import java.util.Objects;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.j11.stub.java_base.J_L_String;
import xyz.wagyourtail.jvmdg.j12.stub.java_base.J_L_C_ConstantDesc;
import xyz.wagyourtail.jvmdg.j12.stub.java_base.J_L_I_TypeDescriptor;
import xyz.wagyourtail.jvmdg.version.Adapter;
import xyz.wagyourtail.jvmdg.version.CoverageIgnore;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@Adapter(value="java/lang/constant/ClassDesc")
@NestMembers(value={ClassDescImpl.class})
public interface J_L_C_ClassDesc
extends J_L_C_ConstantDesc,
J_L_I_TypeDescriptor.OfField<J_L_C_ClassDesc> {
    private static void validateBinaryClassName(String name) {
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (ch != ';' && ch != '[' && ch != '/') continue;
            throw new IllegalArgumentException(J_L_C_ClassDesc.jvmdowngrader$concat$validateBinaryClassName$1(name));
        }
    }

    private static void validateMemberName(String name) {
        Objects.requireNonNull(name);
        if (name.isEmpty()) {
            throw new IllegalArgumentException("zero-length member name");
        }
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (ch != '.' && ch != ';' && ch != '[' && ch != '/') continue;
            throw new IllegalArgumentException(J_L_C_ClassDesc.jvmdowngrader$concat$validateMemberName$1(name));
        }
    }

    public static J_L_C_ClassDesc of(String name) {
        J_L_C_ClassDesc.validateBinaryClassName(name);
        return J_L_C_ClassDesc.ofDescriptor(J_L_C_ClassDesc.jvmdowngrader$concat$of$1(name.replace('.', '/')));
    }

    public static J_L_C_ClassDesc of(String packageName, String className) {
        J_L_C_ClassDesc.validateBinaryClassName(Objects.requireNonNull(packageName));
        if (packageName.isEmpty()) {
            return J_L_C_ClassDesc.of(className);
        }
        return J_L_C_ClassDesc.ofDescriptor(J_L_C_ClassDesc.jvmdowngrader$concat$of$1(packageName.replace('.', '/'), className));
    }

    public static J_L_C_ClassDesc ofDescriptor(String descriptor) {
        int arrayCount = 0;
        while (descriptor.charAt(arrayCount) == '[') {
            ++arrayCount;
        }
        if (arrayCount > 255) {
            throw new IllegalArgumentException("Cannot create an array type descriptor with more than 255 dimensions");
        }
        return new ClassDescImpl(descriptor);
    }

    @Override
    default public J_L_C_ClassDesc arrayType() {
        int arrayCount = 0;
        String descriptor = this.descriptorString();
        while (descriptor.charAt(arrayCount) == '[') {
            ++arrayCount;
        }
        if (arrayCount >= 255) {
            throw new IllegalArgumentException("Cannot create an array type descriptor with more than 255 dimensions");
        }
        return J_L_C_ClassDesc.ofDescriptor(J_L_C_ClassDesc.jvmdowngrader$concat$arrayType$1(descriptor));
    }

    default public J_L_C_ClassDesc arrayType(int rank) {
        if (rank <= 0) {
            throw new IllegalArgumentException(J_L_C_ClassDesc.jvmdowngrader$concat$arrayType$1(rank));
        }
        int arrayCount = 0;
        String descriptor = this.descriptorString();
        while (descriptor.charAt(arrayCount) == '[') {
            ++arrayCount;
        }
        if (arrayCount + rank > 255) {
            throw new IllegalArgumentException("Cannot create an array type descriptor with more than 255 dimensions");
        }
        return J_L_C_ClassDesc.ofDescriptor(J_L_C_ClassDesc.jvmdowngrader$concat$arrayType$1(J_L_String.repeat("[", rank), this.descriptorString()));
    }

    default public J_L_C_ClassDesc nested(String nestedName) {
        J_L_C_ClassDesc.validateMemberName(nestedName);
        if (!this.isClassOrInterface()) {
            throw new IllegalStateException("Outer class is not a class or interface type");
        }
        String descriptor = this.descriptorString();
        return J_L_C_ClassDesc.ofDescriptor(J_L_C_ClassDesc.jvmdowngrader$concat$nested$1(descriptor.substring(0, descriptor.length() - 1), nestedName));
    }

    default public J_L_C_ClassDesc nested(String first, String ... rest) {
        StringBuilder name = new StringBuilder(first);
        for (String s : rest) {
            name.append("$").append(s);
        }
        return this.nested(name.toString());
    }

    @Override
    default public boolean isArray() {
        return this.descriptorString().charAt(0) == '[';
    }

    @Override
    default public boolean isPrimitive() {
        return this.descriptorString().length() == 1;
    }

    default public boolean isClassOrInterface() {
        return this.descriptorString().startsWith("L");
    }

    @Override
    default public J_L_C_ClassDesc componentType() {
        if (!this.isArray()) {
            return null;
        }
        return J_L_C_ClassDesc.ofDescriptor(this.descriptorString().substring(1));
    }

    default public String packageName() {
        if (!this.isClassOrInterface()) {
            return "";
        }
        String descriptor = this.descriptorString().substring(1);
        int slash = descriptor.lastIndexOf(47);
        if (slash == -1) {
            return "";
        }
        return descriptor.substring(0, slash).replace('/', '.');
    }

    default public String displayName() {
        if (this.isPrimitive()) {
            switch (this.descriptorString()) {
                case "B": {
                    return "byte";
                }
                case "C": {
                    return "char";
                }
                case "D": {
                    return "double";
                }
                case "F": {
                    return "float";
                }
                case "I": {
                    return "int";
                }
                case "J": {
                    return "long";
                }
                case "S": {
                    return "short";
                }
                case "Z": {
                    return "boolean";
                }
                case "V": {
                    return "void";
                }
            }
            throw new InternalError(J_L_C_ClassDesc.jvmdowngrader$concat$displayName$1(this.descriptorString()));
        }
        if (this.isArray()) {
            int arrayCount = 0;
            String descriptor = this.descriptorString();
            while (descriptor.charAt(arrayCount) == '[') {
                ++arrayCount;
            }
            String component = descriptor.substring(arrayCount);
            return J_L_C_ClassDesc.jvmdowngrader$concat$arrayType$1(J_L_C_ClassDesc.ofDescriptor(component).displayName(), J_L_String.repeat("[]", arrayCount));
        }
        String descriptor = this.descriptorString();
        int lastSlash = descriptor.lastIndexOf(47);
        if (lastSlash == -1) {
            return descriptor.substring(1, descriptor.length() - 1);
        }
        return descriptor.substring(lastSlash + 1, descriptor.length() - 1);
    }

    @Override
    @CoverageIgnore
    public Class<?> resolveConstantDesc(MethodHandles.Lookup var1) throws ReflectiveOperationException;

    public boolean equals(Object var1);

    private static /* synthetic */ String jvmdowngrader$concat$validateBinaryClassName$1(String string) {
        return "Invalid class name: " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$validateMemberName$1(String string) {
        return "Invalid member name: " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$of$1(String string) {
        return "L" + string + ";";
    }

    private static /* synthetic */ String jvmdowngrader$concat$of$1(String string, String string2) {
        return "L" + string + "/" + string2 + ";";
    }

    private static /* synthetic */ String jvmdowngrader$concat$arrayType$1(String string) {
        return "[" + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$arrayType$1(int n) {
        return "rank " + n + " is not a positive value";
    }

    private static /* synthetic */ String jvmdowngrader$concat$arrayType$1(String string, String string2) {
        return string + string2;
    }

    private static /* synthetic */ String jvmdowngrader$concat$nested$1(String string, String string2) {
        return string + "$" + string2 + ";";
    }

    private static /* synthetic */ String jvmdowngrader$concat$displayName$1(String string) {
        return "Unexpected primitive type descriptor: " + string;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=J_L_C_ClassDesc.class)
    public static class ClassDescImpl
    implements J_L_C_ClassDesc {
        private final String descriptor;

        ClassDescImpl(String descriptor) {
            this.descriptor = descriptor;
        }

        @Override
        public Class<?> resolveConstantDesc(MethodHandles.Lookup lookup) throws ReflectiveOperationException {
            if (this.isPrimitive()) {
                switch (this.descriptorString()) {
                    case "B": {
                        return Byte.TYPE;
                    }
                    case "C": {
                        return Character.TYPE;
                    }
                    case "D": {
                        return Double.TYPE;
                    }
                    case "F": {
                        return Float.TYPE;
                    }
                    case "I": {
                        return Integer.TYPE;
                    }
                    case "J": {
                        return Long.TYPE;
                    }
                    case "S": {
                        return Short.TYPE;
                    }
                    case "Z": {
                        return Boolean.TYPE;
                    }
                    case "V": {
                        return Void.TYPE;
                    }
                }
                throw new InternalError(ClassDescImpl.jvmdowngrader$concat$resolveConstantDesc$1(this.descriptorString()));
            }
            if (this.isArray()) {
                int arrayCount = 0;
                String descriptor = this.descriptorString();
                while (descriptor.charAt(arrayCount) == '[') {
                    ++arrayCount;
                }
                String component = descriptor.substring(arrayCount);
                Object componentClass = J_L_C_ClassDesc.ofDescriptor(component).resolveConstantDesc(lookup);
                return Class.forName(ClassDescImpl.jvmdowngrader$concat$resolveConstantDesc$1(((Class)componentClass).getName(), J_L_String.repeat("[]", arrayCount)), false, lookup.lookupClass().getClassLoader());
            }
            String descriptor = this.descriptorString();
            String className = descriptor.substring(1, descriptor.length() - 1).replace('/', '.');
            return Class.forName(className, false, lookup.lookupClass().getClassLoader());
        }

        @Override
        public String descriptorString() {
            return this.descriptor;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof J_L_C_ClassDesc)) {
                return false;
            }
            return this.descriptor.equals(((J_L_C_ClassDesc)obj).descriptorString());
        }

        public int hashCode() {
            return this.descriptor.hashCode();
        }

        public String toString() {
            return ClassDescImpl.jvmdowngrader$concat$toString$1(this.displayName());
        }

        private static /* synthetic */ String jvmdowngrader$concat$resolveConstantDesc$1(String string) {
            return "Unexpected primitive type descriptor: " + string;
        }

        private static /* synthetic */ String jvmdowngrader$concat$resolveConstantDesc$1(String string, String string2) {
            return string + string2;
        }

        private static /* synthetic */ String jvmdowngrader$concat$toString$1(String string) {
            return "ClassDesc[" + string + "]";
        }
    }
}

