/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j11.stub.java_net_http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.net.ssl.SSLSession;
import xyz.wagyourtail.jvmdg.exc.MissingStubError;
import xyz.wagyourtail.jvmdg.j10.stub.java_base.J_U_Optional;
import xyz.wagyourtail.jvmdg.j11.impl.CharReader;
import xyz.wagyourtail.jvmdg.j11.stub.java_base.J_L_String;
import xyz.wagyourtail.jvmdg.j11.stub.java_net_http.J_N_H_HttpClient;
import xyz.wagyourtail.jvmdg.j11.stub.java_net_http.J_N_H_HttpHeaders;
import xyz.wagyourtail.jvmdg.j11.stub.java_net_http.J_N_H_HttpRequest;
import xyz.wagyourtail.jvmdg.j9.stub.java_base.J_U_C_Flow;
import xyz.wagyourtail.jvmdg.j9.stub.java_base.J_U_Set;
import xyz.wagyourtail.jvmdg.version.Adapter;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@Adapter(value="Ljava/net/http/HttpResponse;")
public interface J_N_H_HttpResponse<T> {
    public int statusCode();

    public J_N_H_HttpRequest request();

    public Optional<J_N_H_HttpResponse<T>> previousResponse();

    public J_N_H_HttpHeaders headers();

    public T body();

    public Optional<SSLSession> sslSession();

    public URI uri();

    public J_N_H_HttpClient.Version version();

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @Adapter(value="Ljava/net/http/HttpResponse$BodySubscribers;")
    public static class BodySubscribers {
        private BodySubscribers() {
        }

        public static BodySubscriber<Void> fromSubscriber(J_U_C_Flow.Subscriber<? super List<ByteBuffer>> subscriber) {
            return BodySubscribers.fromSubscriber(subscriber, s -> null);
        }

        public static <S extends J_U_C_Flow.Subscriber<? super List<ByteBuffer>>, T> BodySubscriber<T> fromSubscriber(final J_U_C_Flow.Subscriber<? super List<ByteBuffer>> subscriber, final Function<? super S, ? extends T> finisher) {
            final CompletableFuture result = new CompletableFuture();
            return new BodySubscriber<T>(){

                @Override
                public void onSubscribe(J_U_C_Flow.Subscription subscription) {
                    subscriber.onSubscribe(subscription);
                }

                @Override
                public void onNext(List<ByteBuffer> item) {
                    subscriber.onNext(item);
                }

                @Override
                public void onError(Throwable throwable) {
                    subscriber.onError(throwable);
                    result.completeExceptionally(throwable);
                }

                @Override
                public void onComplete() {
                    subscriber.onComplete();
                    result.complete(finisher.apply(subscriber));
                }

                @Override
                public CompletionStage<T> getBody() {
                    return result;
                }
            };
        }

        public static BodySubscriber<Void> fromLineSubscriber(J_U_C_Flow.Subscriber<? super String> subscriber) {
            return BodySubscribers.fromLineSubscriber(subscriber, s -> null, StandardCharsets.UTF_8, null);
        }

        public static BodySubscriber<Void> fromLineSubscriber(final J_U_C_Flow.Subscriber<? super String> subscriber, final Function<? super J_U_C_Flow.Subscriber<? super String>, ? extends Void> finisher, final Charset charset, String lineSeparator) {
            final CompletableFuture result = new CompletableFuture();
            return new BodySubscriber<Void>(){

                @Override
                public void onSubscribe(J_U_C_Flow.Subscription subscription) {
                    subscriber.onSubscribe(subscription);
                }

                @Override
                public void onNext(List<ByteBuffer> item) {
                    subscriber.onNext(item.stream().map(b -> new String(b.array(), b.arrayOffset() + b.position(), b.remaining(), charset)).reduce("", String::concat));
                }

                @Override
                public void onError(Throwable throwable) {
                    subscriber.onError(throwable);
                    result.completeExceptionally(throwable);
                }

                @Override
                public void onComplete() {
                    subscriber.onComplete();
                    result.complete((Void)finisher.apply(subscriber));
                }

                @Override
                public CompletionStage<Void> getBody() {
                    return result;
                }
            };
        }

        public static BodySubscriber<String> ofString(final Charset charset) {
            final CompletableFuture result = new CompletableFuture();
            return new BodySubscriber<String>(){
                final StringBuilder builder = new StringBuilder();

                @Override
                public void onSubscribe(J_U_C_Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                @Override
                public void onNext(List<ByteBuffer> item) {
                    item.forEach(b -> this.builder.append(new String(b.array(), b.arrayOffset() + b.position(), b.remaining(), charset)));
                }

                @Override
                public void onError(Throwable throwable) {
                    result.completeExceptionally(throwable);
                }

                @Override
                public void onComplete() {
                    result.complete(this.builder.toString());
                }

                @Override
                public CompletionStage<String> getBody() {
                    return result;
                }
            };
        }

        public static BodySubscriber<byte[]> ofByteArray() {
            final CompletableFuture result = new CompletableFuture();
            return new BodySubscriber<byte[]>(){
                ByteArrayOutputStream out = new ByteArrayOutputStream();

                @Override
                public void onSubscribe(J_U_C_Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                @Override
                public void onNext(List<ByteBuffer> item) {
                    item.forEach(b -> this.out.write(b.array(), b.arrayOffset() + b.position(), b.remaining()));
                }

                @Override
                public void onError(Throwable throwable) {
                    result.completeExceptionally(throwable);
                }

                @Override
                public void onComplete() {
                    result.complete(this.out.toByteArray());
                }

                @Override
                public CompletionStage<byte[]> getBody() {
                    return result;
                }
            };
        }

        public static BodySubscriber<Path> ofFile(final Path file, final OpenOption ... options) {
            final CompletableFuture result = new CompletableFuture();
            return new BodySubscriber<Path>(){

                @Override
                public void onSubscribe(J_U_C_Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                @Override
                public void onNext(List<ByteBuffer> item) {
                    try (OutputStream out = Files.newOutputStream(file, options);){
                        for (ByteBuffer b : item) {
                            out.write(b.array(), b.arrayOffset() + b.position(), b.remaining());
                        }
                    }
                    catch (IOException e) {
                        result.completeExceptionally(e);
                    }
                }

                @Override
                public void onError(Throwable throwable) {
                    result.completeExceptionally(throwable);
                }

                @Override
                public void onComplete() {
                    result.complete(file);
                }

                @Override
                public CompletionStage<Path> getBody() {
                    return result;
                }
            };
        }

        public static BodySubscriber<Path> ofFile(Path file) {
            return BodySubscribers.ofFile(file, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
        }

        public static BodySubscriber<Void> ofByteArrayConsumer(final Consumer<Optional<byte[]>> consumer) {
            final CompletableFuture result = new CompletableFuture();
            return new BodySubscriber<Void>(){

                @Override
                public void onSubscribe(J_U_C_Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                @Override
                public void onNext(List<ByteBuffer> item) {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    item.forEach(b -> out.write(b.array(), b.arrayOffset() + b.position(), b.remaining()));
                    consumer.accept(Optional.of(out.toByteArray()));
                }

                @Override
                public void onError(Throwable throwable) {
                    result.completeExceptionally(throwable);
                }

                @Override
                public void onComplete() {
                    consumer.accept(Optional.empty());
                    result.complete(null);
                }

                @Override
                public CompletionStage<Void> getBody() {
                    return result;
                }
            };
        }

        public static BodySubscriber<InputStream> ofInputStream() {
            final LinkedBlockingDeque deq = new LinkedBlockingDeque();
            final AtomicBoolean completed = new AtomicBoolean(false);
            final AtomicReference<Object> exception = new AtomicReference<Object>(null);
            InputStream is = new InputStream(){
                ByteBuffer current;

                @Override
                public int read() throws IOException {
                    Throwable t = (Throwable)exception.get();
                    if (t != null) {
                        if (completed.get()) {
                            throw new IOException("closed");
                        }
                        completed.set(true);
                        if (t instanceof IOException) {
                            throw (IOException)t;
                        }
                        throw new IOException(t);
                    }
                    if (this.current == null) {
                        if (completed.get() && deq.isEmpty()) {
                            return -1;
                        }
                        try {
                            this.current = (ByteBuffer)deq.take();
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw new IOException("Interrupted while waiting for data", e);
                        }
                    }
                    if (!this.current.hasRemaining()) {
                        this.current = null;
                        return this.read();
                    }
                    return this.current.get() & 0xFF;
                }
            };
            final CompletableFuture<7> result = CompletableFuture.completedFuture(is);
            return new BodySubscriber<InputStream>(){

                @Override
                public void onSubscribe(J_U_C_Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                @Override
                public void onNext(List<ByteBuffer> item) {
                    for (ByteBuffer b : item) {
                        deq.offer(b);
                    }
                }

                @Override
                public void onError(Throwable throwable) {
                    exception.set(throwable);
                }

                @Override
                public void onComplete() {
                    completed.set(true);
                    deq.add(ByteBuffer.allocate(0));
                }

                @Override
                public CompletionStage<InputStream> getBody() {
                    return result;
                }
            };
        }

        public static BodySubscriber<Stream<String>> ofLines(final Charset charset) {
            final CompletableFuture result = new CompletableFuture();
            return new BodySubscriber<Stream<String>>(){
                final StringBuilder builder = new StringBuilder();

                @Override
                public void onSubscribe(J_U_C_Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                @Override
                public void onNext(List<ByteBuffer> item) {
                    item.forEach(b -> this.builder.append(new String(b.array(), b.arrayOffset() + b.position(), b.remaining(), charset)));
                }

                @Override
                public void onError(Throwable throwable) {
                    result.completeExceptionally(throwable);
                }

                @Override
                public void onComplete() {
                    result.complete(J_L_String.lines(this.builder.toString()));
                }

                @Override
                public CompletionStage<Stream<String>> getBody() {
                    return result;
                }
            };
        }

        public static BodySubscriber<J_U_C_Flow.Publisher<List<ByteBuffer>>> ofPublisher() {
            final CompletableFuture result = new CompletableFuture();
            return new BodySubscriber<J_U_C_Flow.Publisher<List<ByteBuffer>>>(){
                List<ByteBuffer> buffers = new ArrayList<ByteBuffer>();

                @Override
                public void onSubscribe(J_U_C_Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                @Override
                public void onNext(List<ByteBuffer> item) {
                    this.buffers.addAll(item);
                }

                @Override
                public void onError(Throwable throwable) {
                    result.completeExceptionally(throwable);
                }

                @Override
                public void onComplete() {
                    result.complete(subscriber -> subscriber.onSubscribe(new J_U_C_Flow.Subscription(){

                        @Override
                        public void request(long n) {
                            subscriber.onNext(buffers);
                            subscriber.onComplete();
                        }

                        @Override
                        public void cancel() {
                            subscriber.onComplete();
                        }
                    }));
                }

                @Override
                public CompletionStage<J_U_C_Flow.Publisher<List<ByteBuffer>>> getBody() {
                    return result;
                }
            };
        }

        public static <U> BodySubscriber<U> replacing(final U value) {
            final CompletableFuture result = new CompletableFuture();
            return new BodySubscriber<U>(){

                @Override
                public void onSubscribe(J_U_C_Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                @Override
                public void onNext(List<ByteBuffer> item) {
                }

                @Override
                public void onError(Throwable throwable) {
                    result.completeExceptionally(throwable);
                }

                @Override
                public void onComplete() {
                    result.complete(value);
                }

                @Override
                public CompletionStage<U> getBody() {
                    return result;
                }
            };
        }

        public static BodySubscriber<Void> discarding() {
            final CompletableFuture result = new CompletableFuture();
            return new BodySubscriber<Void>(){

                @Override
                public void onSubscribe(J_U_C_Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                @Override
                public void onNext(List<ByteBuffer> item) {
                }

                @Override
                public void onError(Throwable throwable) {
                    result.completeExceptionally(throwable);
                }

                @Override
                public void onComplete() {
                    result.complete(null);
                }

                @Override
                public CompletionStage<Void> getBody() {
                    return result;
                }
            };
        }

        public static <T> BodySubscriber<T> buffering(final BodySubscriber<T> downstream, int bufferSize) {
            final CompletableFuture result = new CompletableFuture();
            return new BodySubscriber<T>(){
                List<ByteBuffer> buffers = new ArrayList<ByteBuffer>();

                @Override
                public void onSubscribe(J_U_C_Flow.Subscription subscription) {
                    downstream.onSubscribe(subscription);
                }

                @Override
                public void onNext(List<ByteBuffer> item) {
                    this.buffers.addAll(item);
                }

                @Override
                public void onError(Throwable throwable) {
                    downstream.onError(throwable);
                    result.completeExceptionally(throwable);
                }

                @Override
                public void onComplete() {
                    downstream.onComplete();
                    result.complete(downstream.getBody().toCompletableFuture().join());
                }

                @Override
                public CompletionStage<T> getBody() {
                    return result;
                }
            };
        }

        public static <T, U> BodySubscriber<U> mapping(final BodySubscriber<T> downstream, final Function<? super T, ? extends U> mapper) {
            final CompletableFuture result = new CompletableFuture();
            return new BodySubscriber<U>(){

                @Override
                public void onSubscribe(J_U_C_Flow.Subscription subscription) {
                    downstream.onSubscribe(subscription);
                }

                @Override
                public void onNext(List<ByteBuffer> item) {
                    downstream.onNext(item);
                }

                @Override
                public void onError(Throwable throwable) {
                    downstream.onError(throwable);
                    result.completeExceptionally(throwable);
                }

                @Override
                public void onComplete() {
                    downstream.onComplete();
                    result.complete(mapper.apply(downstream.getBody().toCompletableFuture().join()));
                }

                @Override
                public CompletionStage<U> getBody() {
                    return result;
                }
            };
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @Adapter(value="Ljava/net/http/HttpResponse$BodyHandlers;")
    public static class BodyHandlers {
        private BodyHandlers() {
        }

        private static Charset charsetFrom(J_N_H_HttpHeaders headers) {
            return StandardCharsets.UTF_8;
        }

        public static BodyHandler<Void> fromSubscriber(J_U_C_Flow.Subscriber<? super List<ByteBuffer>> subscriber) {
            Objects.requireNonNull(subscriber);
            return info -> BodySubscribers.fromSubscriber(subscriber);
        }

        public static <S extends J_U_C_Flow.Subscriber<? super List<ByteBuffer>>, T> BodyHandler<Void> fromSubscriber(J_U_C_Flow.Subscriber<? super List<ByteBuffer>> subscriber, Function<? super S, ? extends T> finisher) {
            Objects.requireNonNull(subscriber);
            Objects.requireNonNull(finisher);
            return info -> BodySubscribers.fromSubscriber(subscriber, finisher);
        }

        public static BodyHandler<Void> fromLineSubscriber(J_U_C_Flow.Subscriber<? super String> subscriber) {
            Objects.requireNonNull(subscriber);
            return info -> BodySubscribers.fromLineSubscriber(subscriber, s -> null, BodyHandlers.charsetFrom(info.headers()), null);
        }

        public static BodyHandler<Void> fromLineSubscriber(J_U_C_Flow.Subscriber<? super String> subscriber, Function<? super J_U_C_Flow.Subscriber<? super String>, ? extends Void> finisher, String lineSeparator) {
            Objects.requireNonNull(subscriber);
            Objects.requireNonNull(finisher);
            return info -> BodySubscribers.fromLineSubscriber(subscriber, finisher, BodyHandlers.charsetFrom(info.headers()), lineSeparator);
        }

        public static BodyHandler<Void> discarding() {
            return info -> BodySubscribers.discarding();
        }

        public static <U> BodyHandler<U> replacing(U value) {
            Objects.requireNonNull(value);
            return info -> BodySubscribers.replacing(value);
        }

        public static BodyHandler<String> ofString(Charset charset) {
            Objects.requireNonNull(charset);
            return info -> BodySubscribers.ofString(charset);
        }

        public static BodyHandler<Path> ofFile(Path file, OpenOption ... options) {
            Objects.requireNonNull(file);
            return info -> BodySubscribers.ofFile(file, options);
        }

        public static BodyHandler<Path> ofFile(Path file) {
            return BodyHandlers.ofFile(file, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
        }

        private static Map<String, String> headerContents(String input) {
            CharReader reader = new CharReader(input, 0);
            HashMap<String, String> headers = new HashMap<String, String>();
            while (!reader.exhausted()) {
                String key;
                if (Character.isWhitespace((char)reader.peek())) {
                    reader.takeWhitespace();
                }
                if (reader.peek() == 34) {
                    key = reader.takeString();
                    if (Character.isWhitespace((char)reader.peek())) {
                        reader.takeWhitespace();
                    }
                } else {
                    key = reader.takeUntil(J_U_Set.of(Integer.valueOf(59), Integer.valueOf(61))).trim();
                }
                if (reader.peek() == 61) {
                    String value;
                    reader.take();
                    if (Character.isWhitespace((char)reader.peek())) {
                        reader.takeWhitespace();
                    }
                    if (reader.peek() == 34) {
                        value = reader.takeString();
                        if (Character.isWhitespace((char)reader.peek())) {
                            reader.takeWhitespace();
                        }
                    } else {
                        value = reader.takeUntil(J_U_Set.of(Integer.valueOf(59))).trim();
                    }
                    headers.put(key, value);
                    continue;
                }
                headers.put(key, null);
            }
            return headers;
        }

        public static BodyHandler<Path> ofFileDownload(Path dir, OpenOption ... options) {
            Objects.requireNonNull(dir);
            return info -> {
                Map<String, String> content = BodyHandlers.headerContents(J_U_Optional.orElseThrow(info.headers().firstValue("Content-Disposition")));
                return BodySubscribers.ofFile(dir.resolve(content.get("filename")), options);
            };
        }

        public static BodyHandler<InputStream> ofInputStream() {
            return info -> BodySubscribers.ofInputStream();
        }

        public static BodyHandler<Stream<String>> ofLines() {
            return info -> BodySubscribers.ofLines(BodyHandlers.charsetFrom(info.headers()));
        }

        public static BodyHandler<Void> ofByteArrayConsumer(Consumer<Optional<byte[]>> consumer) {
            Objects.requireNonNull(consumer);
            return info -> BodySubscribers.ofByteArrayConsumer(consumer);
        }

        public static BodyHandler<byte[]> ofByteArray() {
            return info -> BodySubscribers.ofByteArray();
        }

        public static BodyHandler<String> ofString() {
            return info -> BodySubscribers.ofString(BodyHandlers.charsetFrom(info.headers()));
        }

        public static BodyHandler<J_U_C_Flow.Publisher<List<ByteBuffer>>> ofPublisher() {
            return info -> BodySubscribers.ofPublisher();
        }

        public static <T> BodyHandler<T> buffering(BodyHandler<T> downstream, int bufferSize) {
            Objects.requireNonNull(downstream);
            return info -> BodySubscribers.buffering(downstream.apply(info), bufferSize);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @Adapter(value="Ljava/net/http/HttpResponse$PushPromiseHandler;")
    public static interface PushPromiseHandler<T> {
        public static <T> PushPromiseHandler<T> of(Function<J_N_H_HttpRequest, BodyHandler<T>> pushPromiseHandler, ConcurrentMap<J_N_H_HttpRequest, CompletableFuture<J_N_H_HttpResponse<T>>> pushPromisesMap) {
            throw MissingStubError.create();
        }

        public void applyPushPromise(J_N_H_HttpRequest var1, J_N_H_HttpRequest var2, Function<BodyHandler<T>, CompletableFuture<J_N_H_HttpResponse<T>>> var3);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @Adapter(value="Ljava/net/http/HttpResponse$BodyHandler;")
    public static interface BodyHandler<T> {
        public BodySubscriber<T> apply(ResponseInfo var1);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @Adapter(value="Ljava/net/http/HttpResponse$ResponseInfo;")
    public static interface ResponseInfo {
        public int statusCode();

        public J_N_H_HttpHeaders headers();

        public J_N_H_HttpClient.Version version();
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @Adapter(value="Ljava/net/http/HttpResponse$BodySubscriber;")
    public static interface BodySubscriber<T>
    extends J_U_C_Flow.Subscriber<List<ByteBuffer>> {
        public CompletionStage<T> getBody();
    }
}

