/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j11.stub.java_net_http;

import java.io.InputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import xyz.wagyourtail.jvmdg.j11.impl.http.HttpRequestBuilderImpl;
import xyz.wagyourtail.jvmdg.j11.impl.http.IterablePublisher;
import xyz.wagyourtail.jvmdg.j11.impl.http.StreamIterator;
import xyz.wagyourtail.jvmdg.j11.stub.java_net_http.J_N_H_HttpClient;
import xyz.wagyourtail.jvmdg.j11.stub.java_net_http.J_N_H_HttpHeaders;
import xyz.wagyourtail.jvmdg.j9.stub.java_base.J_I_InputStream;
import xyz.wagyourtail.jvmdg.j9.stub.java_base.J_U_C_Flow;
import xyz.wagyourtail.jvmdg.version.Adapter;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@Adapter(value="Ljava/net/http/HttpRequest;")
public abstract class J_N_H_HttpRequest {
    protected J_N_H_HttpRequest() {
    }

    public static Builder newBuilder() {
        return new HttpRequestBuilderImpl();
    }

    public static Builder newBuilder(URI uri) {
        return new HttpRequestBuilderImpl().uri(uri);
    }

    public abstract Optional<BodyPublisher> bodyPublisher();

    public abstract String method();

    public abstract Optional<Duration> timeout();

    public abstract boolean expectContinue();

    public abstract URI uri();

    public abstract Optional<J_N_H_HttpClient.Version> version();

    public abstract J_N_H_HttpHeaders headers();

    public final boolean equals(Object obj) {
        if (!(obj instanceof J_N_H_HttpRequest)) {
            return false;
        }
        J_N_H_HttpRequest that = (J_N_H_HttpRequest)obj;
        if (!that.method().equals(this.method())) {
            return false;
        }
        if (!that.headers().equals(this.headers())) {
            return false;
        }
        return that.uri().equals(this.uri());
    }

    public final int hashCode() {
        return Objects.hash(this.method().hashCode(), this.uri().hashCode(), this.headers().hashCode());
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @Adapter(value="Ljava/net/http/HttpRequest$BodyPublishers;")
    public static class BodyPublishers {
        private BodyPublishers() {
        }

        public static BodyPublisher fromPublisher(J_U_C_Flow.Publisher<? extends ByteBuffer> publisher) {
            return BodyPublishers.fromPublisher(publisher, -1L);
        }

        public static BodyPublisher fromPublisher(final J_U_C_Flow.Publisher<? extends ByteBuffer> publisher, final long contentLength) {
            Objects.requireNonNull(publisher);
            return new BodyPublisher(){

                @Override
                public long contentLength() {
                    return contentLength;
                }

                @Override
                public void subscribe(J_U_C_Flow.Subscriber<? super ByteBuffer> subscriber) {
                    publisher.subscribe(subscriber);
                }
            };
        }

        public static BodyPublisher ofString(String s) {
            return BodyPublishers.ofString(s, StandardCharsets.UTF_8);
        }

        public static BodyPublisher ofString(String s, Charset charset) {
            return BodyPublishers.ofByteArray(s.getBytes(charset));
        }

        public static BodyPublisher ofInputStream(final Supplier<? extends InputStream> streamSupplier) {
            return new BodyPublisher(){

                @Override
                public long contentLength() {
                    return -1L;
                }

                @Override
                public void subscribe(J_U_C_Flow.Subscriber<? super ByteBuffer> subscriber) {
                    InputStream is = (InputStream)streamSupplier.get();
                    IterablePublisher<ByteBuffer> publisher = is == null ? new IterablePublisher(null, new NullPointerException("InputStream supplier returned null")) : new IterablePublisher<ByteBuffer>(() -> new StreamIterator(is));
                    publisher.subscribe(subscriber);
                }
            };
        }

        public static BodyPublisher ofByteArray(byte[] bytes) {
            return BodyPublishers.ofByteArray(bytes, 0, bytes.length);
        }

        public static BodyPublisher ofByteArray(final byte[] bytes, final int offset, final int length) {
            return new BodyPublisher(){

                @Override
                public long contentLength() {
                    return length;
                }

                @Override
                public void subscribe(final J_U_C_Flow.Subscriber<? super ByteBuffer> subscriber) {
                    subscriber.onSubscribe(new J_U_C_Flow.Subscription(){
                        private boolean completed;

                        @Override
                        public void request(long n) {
                            if (n <= 0L) {
                                subscriber.onError(new IllegalArgumentException("n <= 0"));
                                return;
                            }
                            if (this.completed) {
                                return;
                            }
                            this.completed = true;
                            subscriber.onNext(ByteBuffer.wrap(bytes, offset, length));
                            subscriber.onComplete();
                        }

                        @Override
                        public void cancel() {
                            this.completed = true;
                        }
                    });
                }
            };
        }

        public static BodyPublisher ofFile(final Path file) {
            return new BodyPublisher(){

                @Override
                public long contentLength() {
                    try {
                        return Files.size(file);
                    }
                    catch (Exception e) {
                        return -1L;
                    }
                }

                @Override
                public void subscribe(final J_U_C_Flow.Subscriber<? super ByteBuffer> subscriber) {
                    subscriber.onSubscribe(new J_U_C_Flow.Subscription(){
                        private boolean completed;

                        @Override
                        public void request(long n) {
                            if (n <= 0L) {
                                subscriber.onError(new IllegalArgumentException("n <= 0"));
                                return;
                            }
                            if (this.completed) {
                                return;
                            }
                            this.completed = true;
                            try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
                                subscriber.onNext(ByteBuffer.wrap(J_I_InputStream.readAllBytes(is)));
                                subscriber.onComplete();
                            }
                            catch (Exception e) {
                                subscriber.onError(e);
                            }
                        }

                        @Override
                        public void cancel() {
                            this.completed = true;
                        }
                    });
                }
            };
        }

        public static BodyPublisher ofByteArrays(final Iterable<byte[]> byteArrays) {
            return new BodyPublisher(){

                @Override
                public long contentLength() {
                    return -1L;
                }

                @Override
                public void subscribe(J_U_C_Flow.Subscriber<? super ByteBuffer> subscriber) {
                    IterablePublisher<? super ByteBuffer> publisher = new IterablePublisher<ByteBuffer>(() -> new Iterator<ByteBuffer>(){
                        final Iterator iterator;
                        {
                            this.iterator = byteArrays.iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.iterator.hasNext();
                        }

                        @Override
                        public ByteBuffer next() {
                            return ByteBuffer.wrap((byte[])this.iterator.next());
                        }
                    });
                    publisher.subscribe(subscriber);
                }
            };
        }

        public static BodyPublisher noBody() {
            return new BodyPublisher(){

                @Override
                public long contentLength() {
                    return 0L;
                }

                @Override
                public void subscribe(final J_U_C_Flow.Subscriber<? super ByteBuffer> subscriber) {
                    subscriber.onSubscribe(new J_U_C_Flow.Subscription(){

                        @Override
                        public void request(long n) {
                            subscriber.onComplete();
                        }

                        @Override
                        public void cancel() {
                        }
                    });
                }
            };
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @Adapter(value="Ljava/net/http/HttpRequest$Builder;")
    public static interface Builder {
        public Builder uri(URI var1);

        public Builder expectContinue(boolean var1);

        public Builder version(J_N_H_HttpClient.Version var1);

        public Builder header(String var1, String var2);

        public Builder headers(String ... var1);

        public Builder timeout(Duration var1);

        public Builder setHeader(String var1, String var2);

        public Builder GET();

        public Builder POST(BodyPublisher var1);

        public Builder PUT(BodyPublisher var1);

        public Builder DELETE();

        public Builder method(String var1, BodyPublisher var2);

        public J_N_H_HttpRequest build();

        public Builder copy();
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @Adapter(value="Ljava/net/http/HttpRequest$BodyPublisher;")
    public static interface BodyPublisher
    extends J_U_C_Flow.Publisher<ByteBuffer> {
        public long contentLength();
    }
}

