/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j11.stub.java_base;

import java.io.IOException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import xyz.wagyourtail.jvmdg.j10.stub.java_base.J_U_Set;
import xyz.wagyourtail.jvmdg.version.Stub;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class J_N_C_Selector {
    @Stub
    public static int select(Selector selector, Consumer<SelectionKey> action, long timeout) throws IOException {
        if (timeout < 0L) {
            throw new IllegalArgumentException("Negative timeout");
        }
        return SelectorInternal.doSelect(selector, Objects.requireNonNull(action), timeout);
    }

    @Stub
    public static int select(Selector selector, Consumer<SelectionKey> action) throws IOException {
        return SelectorInternal.doSelect(selector, Objects.requireNonNull(action), 0L);
    }

    @Stub
    public static int selectNow(Selector selector, Consumer<SelectionKey> action) throws IOException {
        return SelectorInternal.doSelect(selector, Objects.requireNonNull(action), -1L);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class SelectorInternal {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static int doSelect(Selector selector, Consumer<SelectionKey> action, long timeout) throws IOException {
            Selector selector2 = selector;
            synchronized (selector2) {
                Set<SelectionKey> selectedKeys;
                Set<SelectionKey> set = selectedKeys = selector.selectedKeys();
                synchronized (set) {
                    selectedKeys.clear();
                    int numKeySelected = timeout < 0L ? selector.selectNow() : selector.select(timeout);
                    Set<SelectionKey> keysToConsume = J_U_Set.copyOf(selectedKeys);
                    assert (keysToConsume.size() == numKeySelected);
                    selectedKeys.clear();
                    for (SelectionKey k : keysToConsume) {
                        action.accept(k);
                        if (selector.isOpen()) continue;
                        throw new ClosedSelectorException();
                    }
                    return numKeySelected;
                }
            }
        }
    }
}

