/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j11.stub.java_base;

import java.io.IOException;
import java.io.Writer;
import java.util.Objects;
import xyz.wagyourtail.jvmdg.j9.stub.java_base.J_U_Objects;
import xyz.wagyourtail.jvmdg.version.Ref;
import xyz.wagyourtail.jvmdg.version.Stub;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class J_I_Writer {
    @Stub(ref=@Ref(value="Ljava/io/Writer;"))
    public static Writer nullWriter() {
        return new NullWriter();
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class NullWriter
    extends Writer {
        private volatile boolean closed;

        @Override
        public void write(int c) throws IOException {
            this.ensureOpen();
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            J_U_Objects.checkFromIndexSize(off, len, cbuf.length);
            this.ensureOpen();
        }

        @Override
        public void write(String str) throws IOException {
            Objects.requireNonNull(str);
            this.ensureOpen();
        }

        @Override
        public void write(String str, int off, int len) throws IOException {
            J_U_Objects.checkFromIndexSize(off, len, str.length());
            this.ensureOpen();
        }

        @Override
        public Writer append(CharSequence csq) throws IOException {
            this.ensureOpen();
            return this;
        }

        @Override
        public Writer append(CharSequence csq, int start, int end) throws IOException {
            this.ensureOpen();
            if (csq != null) {
                J_U_Objects.checkFromToIndex(start, end, csq.length());
            }
            return this;
        }

        @Override
        public Writer append(char c) throws IOException {
            this.ensureOpen();
            return this;
        }

        private void ensureOpen() throws IOException {
            if (this.closed) {
                throw new IOException("Stream closed");
            }
        }

        @Override
        public void flush() throws IOException {
            this.ensureOpen();
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
        }
    }
}

