/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j11.stub.java_base;

import java.io.IOException;
import java.io.OutputStream;
import xyz.wagyourtail.jvmdg.j9.stub.java_base.J_U_Objects;
import xyz.wagyourtail.jvmdg.version.Ref;
import xyz.wagyourtail.jvmdg.version.Stub;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class J_I_OutputStream {
    @Stub(ref=@Ref(value="Ljava/io/OutputStream;"))
    public static OutputStream nullOutputStream() {
        return new NullOutputStream();
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class NullOutputStream
    extends OutputStream {
        private volatile boolean closed = false;

        @Override
        public void write(int b) throws IOException {
            this.ensureOpen();
        }

        private void ensureOpen() throws IOException {
            if (this.closed) {
                throw new IOException("Stream closed");
            }
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            J_U_Objects.checkFromIndexSize(off, len, b.length);
            this.ensureOpen();
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }
}

