/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j11.stub.java_base;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Objects;
import xyz.wagyourtail.jvmdg.j9.stub.java_base.J_U_Objects;
import xyz.wagyourtail.jvmdg.version.Ref;
import xyz.wagyourtail.jvmdg.version.Stub;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class J_I_InputStream {
    @Stub(ref=@Ref(value="Ljava/io/InputStream;"))
    public static InputStream nullInputStream() {
        return new NullInputStream();
    }

    @Stub
    public static byte[] readNBytes(InputStream stream, int len) throws IOException {
        int count;
        if (len < 0) {
            throw new IllegalArgumentException("len < 0");
        }
        byte[] b = new byte[len];
        for (int n = 0; n < len; n += count) {
            count = stream.read(b, n, len - n);
            if (count >= 0) continue;
            if (n == 0) {
                return null;
            }
            return Arrays.copyOf(b, n);
        }
        return b;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class NullInputStream
    extends InputStream {
        private volatile boolean closed = false;

        @Override
        public int read() throws IOException {
            this.ensureOpen();
            return -1;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            J_U_Objects.checkFromIndexSize(off, len, b.length);
            if (len == 0) {
                return 0;
            }
            this.ensureOpen();
            return -1;
        }

        @Override
        public byte[] readAllBytes() throws IOException {
            this.ensureOpen();
            return new byte[0];
        }

        @Override
        public byte[] readNBytes(int len) throws IOException {
            if (len < 0) {
                throw new IllegalArgumentException("len < 0");
            }
            this.ensureOpen();
            return new byte[0];
        }

        @Override
        public int readNBytes(byte[] b, int off, int len) throws IOException {
            J_U_Objects.checkFromIndexSize(off, len, b.length);
            this.ensureOpen();
            return 0;
        }

        @Override
        public long skip(long n) throws IOException {
            this.ensureOpen();
            return 0L;
        }

        @Override
        public void skipNBytes(long n) throws IOException {
            this.ensureOpen();
            if (n > 0L) {
                throw new EOFException();
            }
        }

        @Override
        public int available() throws IOException {
            this.ensureOpen();
            return 0;
        }

        private void ensureOpen() throws IOException {
            if (this.closed) {
                throw new IOException("Stream closed");
            }
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
        }

        @Override
        public long transferTo(OutputStream out) throws IOException {
            Objects.requireNonNull(out);
            this.ensureOpen();
            return 0L;
        }
    }
}

