/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j11.impl.http;

import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import xyz.wagyourtail.jvmdg.j11.impl.http.HttpRequestImpl;
import xyz.wagyourtail.jvmdg.j11.stub.java_net_http.J_N_H_HttpClient;
import xyz.wagyourtail.jvmdg.j11.stub.java_net_http.J_N_H_HttpRequest;
import xyz.wagyourtail.jvmdg.j9.stub.java_base.J_U_List;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class HttpRequestBuilderImpl
implements J_N_H_HttpRequest.Builder {
    URI uri;
    boolean expectContinue = false;
    J_N_H_HttpClient.Version version;
    Map<String, List<String>> headers = new HashMap<String, List<String>>();
    Duration timeout;
    String method = "GET";
    J_N_H_HttpRequest.BodyPublisher publisher;

    @Override
    public J_N_H_HttpRequest.Builder uri(URI uri) {
        this.uri = uri;
        return this;
    }

    @Override
    public J_N_H_HttpRequest.Builder expectContinue(boolean expectContinue) {
        this.expectContinue = expectContinue;
        return this;
    }

    @Override
    public J_N_H_HttpRequest.Builder version(J_N_H_HttpClient.Version version) {
        this.version = version;
        return this;
    }

    @Override
    public J_N_H_HttpRequest.Builder header(String name, String value) {
        if (!this.headers.containsKey(name)) {
            this.headers.put(name, new ArrayList<String>(J_U_List.of(value)));
        } else {
            this.headers.get(name).add(value);
        }
        return this;
    }

    @Override
    public J_N_H_HttpRequest.Builder headers(String ... headers) {
        for (int i = 0; i < headers.length; i += 2) {
            this.header(headers[i], headers[i + 1]);
        }
        return this;
    }

    @Override
    public J_N_H_HttpRequest.Builder timeout(Duration duration) {
        this.timeout = duration;
        return this;
    }

    @Override
    public J_N_H_HttpRequest.Builder setHeader(String name, String value) {
        this.headers.put(name, new ArrayList<String>(J_U_List.of(value)));
        return this;
    }

    @Override
    public J_N_H_HttpRequest.Builder GET() {
        return this.method("GET", null);
    }

    @Override
    public J_N_H_HttpRequest.Builder POST(J_N_H_HttpRequest.BodyPublisher publisher) {
        return this.method("POST", publisher);
    }

    @Override
    public J_N_H_HttpRequest.Builder PUT(J_N_H_HttpRequest.BodyPublisher publisher) {
        return this.method("PUT", publisher);
    }

    @Override
    public J_N_H_HttpRequest.Builder DELETE() {
        return this.method("DELETE", null);
    }

    @Override
    public J_N_H_HttpRequest.Builder method(String name, J_N_H_HttpRequest.BodyPublisher publisher) {
        this.method = name;
        this.publisher = publisher;
        return this;
    }

    @Override
    public J_N_H_HttpRequest build() {
        return new HttpRequestImpl(this);
    }

    @Override
    public J_N_H_HttpRequest.Builder copy() {
        HttpRequestBuilderImpl copy = new HttpRequestBuilderImpl();
        copy.uri = this.uri;
        copy.expectContinue = this.expectContinue;
        copy.version = this.version;
        for (Map.Entry<String, List<String>> entry : this.headers.entrySet()) {
            copy.headers.put(entry.getKey(), new ArrayList(entry.getValue()));
        }
        copy.timeout = this.timeout;
        copy.method = this.method;
        copy.publisher = this.publisher;
        return copy;
    }
}

