/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.util.numberformatting.options;

import com.gtnewhorizon.gtnhlib.util.numberformatting.Constants;
import com.gtnewhorizon.gtnhlib.util.numberformatting.NumberFormatUtil;
import com.gtnewhorizon.gtnhlib.util.numberformatting.options.CompactOptions;
import com.gtnewhorizon.gtnhlib.util.numberformatting.options.FormatOptions;
import java.math.BigDecimal;
import java.math.RoundingMode;

public abstract class NumberOptionsBase<T extends NumberOptionsBase<T>> {
    private int decimalPlaces = 2;
    private BigDecimal exponentialThreshold = Constants.BD_TRILLION;
    private boolean disableExponentialFormatting = false;
    private RoundingMode roundingMode = RoundingMode.HALF_UP;

    protected NumberOptionsBase() {
    }

    public T setDecimalPlaces(int decimalPlaces) {
        if (decimalPlaces < 0) {
            throw new IllegalArgumentException("Decimal places must be >= 0");
        }
        this.decimalPlaces = decimalPlaces;
        return (T)this;
    }

    public T setExponentialThreshold(Number number) {
        if (number == null) {
            throw new IllegalArgumentException("Number cannot be null");
        }
        BigDecimal value = NumberFormatUtil.bigDecimalConverter(number);
        if (value.signum() < 0) {
            throw new IllegalArgumentException("Exponential threshold must be >= 0");
        }
        this.exponentialThreshold = value.abs();
        return (T)this;
    }

    public T disableExponentialFormatting() {
        this.disableExponentialFormatting = true;
        return (T)this;
    }

    public T enableExponentialFormatting() {
        this.disableExponentialFormatting = false;
        return (T)this;
    }

    public T setRoundingMode(RoundingMode roundingMode) {
        this.roundingMode = roundingMode;
        return (T)this;
    }

    public int getDecimalPlaces() {
        return this.decimalPlaces;
    }

    public BigDecimal getExponentialThreshold() {
        return this.exponentialThreshold;
    }

    public boolean isExponentialFormattingDisabled() {
        return this.disableExponentialFormatting;
    }

    public boolean isExponentialFormattingEnabled() {
        return !this.disableExponentialFormatting;
    }

    public RoundingMode getRoundingMode() {
        return this.roundingMode;
    }

    public FormatOptions toFormatOptions() {
        FormatOptions options = new FormatOptions();
        options.setExponentialThreshold(this.exponentialThreshold);
        options.setDecimalPlaces(this.decimalPlaces);
        options.setRoundingMode(this.roundingMode);
        if (this.disableExponentialFormatting) {
            options.disableExponentialFormatting();
        } else {
            options.enableExponentialFormatting();
        }
        return options;
    }

    public CompactOptions toCompactOptions() {
        CompactOptions options = new CompactOptions();
        options.setExponentialThreshold(this.exponentialThreshold);
        options.setDecimalPlaces(this.decimalPlaces);
        options.setRoundingMode(this.roundingMode);
        if (this.disableExponentialFormatting) {
            options.disableExponentialFormatting();
        } else {
            options.enableExponentialFormatting();
        }
        return options;
    }
}

