/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.util.numberformatting.options;

import com.gtnewhorizon.gtnhlib.util.numberformatting.Constants;
import com.gtnewhorizon.gtnhlib.util.numberformatting.NumberFormatUtil;
import com.gtnewhorizon.gtnhlib.util.numberformatting.options.NumberOptionsBase;
import java.math.BigDecimal;

public final class CompactOptions
extends NumberOptionsBase<CompactOptions> {
    private BigDecimal compactThreshold = Constants.BD_THOUSAND;

    @Override
    public CompactOptions setExponentialThreshold(Number number) {
        BigDecimal value = NumberFormatUtil.bigDecimalConverter(number);
        if (value.signum() < 0) {
            throw new IllegalArgumentException("Scientific threshold must be >= 0");
        }
        BigDecimal currentCompact = this.getCompactThreshold();
        if (value.compareTo(currentCompact) <= 0) {
            throw new IllegalArgumentException("Scientific threshold must be strictly greater than compact threshold (" + currentCompact + ")");
        }
        super.setExponentialThreshold(value);
        return this;
    }

    public CompactOptions setCompactThreshold(Number number) {
        BigDecimal value = NumberFormatUtil.bigDecimalConverter(number);
        if (value.signum() < 0) {
            throw new IllegalArgumentException("Compact threshold must be >= 0");
        }
        BigDecimal currentScientific = this.getExponentialThreshold();
        if (value.compareTo(currentScientific) >= 0) {
            throw new IllegalArgumentException("Compact threshold must be strictly less than scientific threshold (" + currentScientific + ")");
        }
        this.compactThreshold = value;
        return this;
    }

    public BigDecimal getCompactThreshold() {
        return this.compactThreshold;
    }
}

