/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.util.numberformatting;

import com.gtnewhorizon.gtnhlib.util.numberformatting.Constants;
import com.gtnewhorizon.gtnhlib.util.numberformatting.ExponentialFormat;
import com.gtnewhorizon.gtnhlib.util.numberformatting.NumberFormatConfig;
import com.gtnewhorizon.gtnhlib.util.numberformatting.options.CompactOptions;
import com.gtnewhorizon.gtnhlib.util.numberformatting.options.FormatOptions;
import com.gtnewhorizon.gtnhlib.util.numberformatting.options.NumberOptionsBase;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fluids.FluidStack;

public final class NumberFormatUtil {
    private static Locale cachedLocale = null;

    private NumberFormatUtil() {
    }

    public static String formatNumber(Number value) {
        return NumberFormatUtil.formatNumber(value, new FormatOptions());
    }

    public static String formatNumber(Number value, FormatOptions options) {
        String special = NumberFormatUtil.handleSpecialCases(value);
        if (special != null) {
            return special;
        }
        BigDecimal val = NumberFormatUtil.bigDecimalConverter(value);
        BigDecimal abs = val.abs();
        if (abs.signum() == 0) {
            return "0";
        }
        if (NumberFormatUtil.isExponentialFormattingEnabled(abs, options)) {
            return NumberFormatUtil.formatExponential(val, options);
        }
        return NumberFormatUtil.centralFormatter(NumberFormatUtil.getDefaultDecimalFormatter(options).format(val));
    }

    public static String formatNumberCompact(Number value) {
        return NumberFormatUtil.formatNumberCompact(value, new CompactOptions());
    }

    public static String formatNumberCompact(Number value, CompactOptions options) {
        String special = NumberFormatUtil.handleSpecialCases(value);
        if (special != null) {
            return special;
        }
        BigDecimal val = NumberFormatUtil.bigDecimalConverter(value);
        BigDecimal abs = val.abs();
        if (abs.signum() == 0) {
            return "0";
        }
        if (abs.compareTo(options.getCompactThreshold()) < 0) {
            return NumberFormatUtil.formatNumber(value, options.toFormatOptions());
        }
        if (NumberFormatUtil.isExponentialFormattingEnabled(abs, options)) {
            return NumberFormatUtil.formatExponential(val, options);
        }
        return NumberFormatUtil.abbreviate(val, options);
    }

    private static String abbreviate(BigDecimal value, NumberOptionsBase<?> options) {
        String suffix;
        BigDecimal divisor;
        BigDecimal abs = value.abs();
        if (abs.compareTo(Constants.BD_QUADRILLION) >= 0) {
            divisor = Constants.BD_QUADRILLION;
            suffix = "Q";
        } else if (abs.compareTo(Constants.BD_TRILLION) >= 0) {
            divisor = Constants.BD_TRILLION;
            suffix = "T";
        } else if (abs.compareTo(Constants.BD_BILLION) >= 0) {
            divisor = Constants.BD_BILLION;
            suffix = "B";
        } else if (abs.compareTo(Constants.BD_MILLION) >= 0) {
            divisor = Constants.BD_MILLION;
            suffix = "M";
        } else {
            divisor = Constants.BD_THOUSAND;
            suffix = "K";
        }
        BigDecimal scaled = value.divide(divisor, MathContext.UNLIMITED);
        int dp = options.getDecimalPlaces();
        RoundingMode rm = options.getRoundingMode();
        BigDecimal rounded = scaled.setScale(dp, rm);
        BigDecimal nextThreshold = divisor.multiply(Constants.BD_THOUSAND);
        if (abs.compareTo(nextThreshold) < 0 && rounded.abs().compareTo(Constants.BD_THOUSAND) >= 0) {
            BigDecimal step = BigDecimal.ONE.scaleByPowerOfTen(-dp);
            BigDecimal maxAbs = Constants.BD_THOUSAND.subtract(step).setScale(dp, RoundingMode.UNNECESSARY);
            rounded = rounded.signum() < 0 ? maxAbs.negate() : maxAbs;
        }
        rounded = rounded.stripTrailingZeros();
        return NumberFormatUtil.formatNumber(rounded, options.toFormatOptions()) + suffix;
    }

    private static String formatExponential(BigDecimal value, NumberOptionsBase<?> options) {
        return NumberFormatConfig.EXPONENTIAL_FORMAT.format(value, options);
    }

    public static String getFluidUnit() {
        return NumberFormatConfig.useForgeFluidMillibuckets ? "mB" : "L";
    }

    public static String formatFluid(Number value) {
        return NumberFormatUtil.formatFluid(value, new FormatOptions());
    }

    public static String formatFluid(Number value, FormatOptions options) {
        return NumberFormatUtil.formatNumber(value, options) + " " + NumberFormatUtil.getFluidUnit();
    }

    public static String formatFluidCompact(Number value) {
        return NumberFormatUtil.formatFluidCompact(value, new CompactOptions());
    }

    public static String formatFluidCompact(Number value, CompactOptions options) {
        return NumberFormatUtil.formatNumberCompact(value, options) + " " + NumberFormatUtil.getFluidUnit();
    }

    public static String formatFluid(FluidStack stack) {
        return NumberFormatUtil.formatFluid(stack.amount);
    }

    public static String getEnergyUnit() {
        return "EU";
    }

    public static String formatEnergy(Number value) {
        return NumberFormatUtil.formatEnergy(value, new FormatOptions());
    }

    public static String formatEnergy(Number value, FormatOptions options) {
        return NumberFormatUtil.formatNumber(value, options) + " " + NumberFormatUtil.getEnergyUnit();
    }

    public static String formatEnergyCompact(Number value, CompactOptions options) {
        return NumberFormatUtil.formatNumberCompact(value, options) + " " + NumberFormatUtil.getEnergyUnit();
    }

    public static String formatEnergyCompact(Number value) {
        return NumberFormatUtil.formatEnergyCompact(value, new CompactOptions());
    }

    private static String rawNumberToString(Number value) {
        if (value instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)value;
            return bd.toPlainString();
        }
        if (value instanceof BigInteger) {
            return value.toString();
        }
        if (value instanceof Double || value instanceof Float) {
            double d = value.doubleValue();
            return BigDecimal.valueOf(d).stripTrailingZeros().toPlainString();
        }
        if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long) {
            return Long.toString(value.longValue());
        }
        return value.toString();
    }

    private static boolean isExponentialFormattingEnabled(BigDecimal absValue, NumberOptionsBase<?> options) {
        boolean disabledGlobally = NumberFormatConfig.globalDisableExponentialNotation;
        boolean aboveThreshold = absValue.compareTo(options.getExponentialThreshold()) >= 0;
        boolean enabledInOptions = options.isExponentialFormattingEnabled();
        return !disabledGlobally && enabledInOptions && aboveThreshold;
    }

    @SideOnly(value=Side.CLIENT)
    private static Locale getMinecraftLocale() {
        if (cachedLocale == null) {
            try {
                String langCode = Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a();
                String[] parts = langCode.split("_");
                cachedLocale = parts.length == 2 ? new Locale(parts[0], parts[1]) : new Locale(parts[0]);
            }
            catch (Exception e) {
                cachedLocale = Locale.getDefault(Locale.Category.FORMAT);
            }
        }
        return cachedLocale;
    }

    private static Locale getLocale() {
        try {
            FMLCommonHandler handler = FMLCommonHandler.instance();
            if (handler != null && handler.getSide().isServer()) {
                return Locale.getDefault(Locale.Category.FORMAT);
            }
        }
        catch (Throwable ignored) {
            return Locale.getDefault(Locale.Category.FORMAT);
        }
        try {
            return NumberFormatUtil.getMinecraftLocale();
        }
        catch (Throwable ignored) {
            return Locale.getDefault(Locale.Category.FORMAT);
        }
    }

    private static DecimalFormat getDefaultDecimalFormatter(NumberOptionsBase<?> options) {
        Locale locale = NumberFormatUtil.getLocale();
        DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(locale);
        DecimalFormat df = (DecimalFormat)DecimalFormat.getInstance(locale);
        df.setDecimalFormatSymbols(symbols);
        df.setGroupingUsed(true);
        df.setMaximumFractionDigits(options.getDecimalPlaces());
        df.setRoundingMode(options.getRoundingMode());
        return df;
    }

    private static String handleSpecialCases(Number value) {
        if (value == null) {
            return "NULL";
        }
        if (value instanceof Double || value instanceof Float) {
            double d = value.doubleValue();
            if (Double.isNaN(d)) {
                return "NaN";
            }
            if (Double.isInfinite(d)) {
                return d > 0.0 ? "Infinity" : "-Infinity";
            }
        }
        if (NumberFormatConfig.disableFormattedNotation) {
            return NumberFormatUtil.rawNumberToString(value);
        }
        return null;
    }

    private static String centralFormatter(String s) {
        s = s.replace("\u202f", " ");
        s = s.replace("\u00a0", " ");
        return s;
    }

    public static void postConfiguration() {
        NumberFormatConfig.EXPONENTIAL_FORMAT = ExponentialFormat.parse(NumberFormatConfig.formatPattern);
    }

    public static BigDecimal bigDecimalConverter(Number number) {
        if (number == null) {
            throw new IllegalArgumentException("Number cannot be null");
        }
        if (number instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)number;
            return bd;
        }
        if (number instanceof BigInteger) {
            BigInteger bi = (BigInteger)number;
            return new BigDecimal(bi);
        }
        if (number instanceof Byte || number instanceof Short || number instanceof Integer || number instanceof Long) {
            return BigDecimal.valueOf(number.longValue());
        }
        double d = number.doubleValue();
        if (Double.isNaN(d)) {
            throw new IllegalArgumentException("Cannot convert NaN to BigDecimal.");
        }
        if (Double.isInfinite(d)) {
            throw new IllegalArgumentException("Cannot convert Infinity to BigDecimal.");
        }
        return BigDecimal.valueOf(d);
    }
}

