/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.util;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.resources.I18n;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SideOnly(value=Side.CLIENT)
public final class GuiText {
    private static final String PREFIX = "gtnhlib.";
    private static final Logger LOGGER = LogManager.getLogger((String)"GTNHLib-GuiText");
    private static final boolean DEBUG_LOG_MISSING_KEYS = Boolean.parseBoolean(System.getProperty("gtnhlib.guiTextDebug", "false"));
    private static final boolean DEBUG_CRASH_ON_MISSING = Boolean.parseBoolean(System.getProperty("gtnhlib.guiTextCrashOnMissing", "false"));
    private static final Set<String> WARNED_KEYS = Collections.newSetFromMap(new ConcurrentHashMap());

    private GuiText() {
    }

    public static String translate(String key, String fallback, Object ... args) {
        String fullKey = PREFIX + key;
        String translated = I18n.func_135052_a((String)fullKey, (Object[])args);
        if (translated != null && !translated.equals(fullKey)) {
            return translated;
        }
        if (DEBUG_CRASH_ON_MISSING) {
            throw new IllegalStateException("Missing GUI lang key: '" + fullKey + "' (fallback: '" + fallback + "')");
        }
        if (DEBUG_LOG_MISSING_KEYS) {
            GuiText.logMissingKeyOnce(fullKey, fallback);
        }
        return fallback;
    }

    public static String format(String key, String fallback, Object ... args) {
        return GuiText.translate(key, fallback, args);
    }

    private static void logMissingKeyOnce(String fullKey, String fallback) {
        if (WARNED_KEYS.add(fullKey)) {
            LOGGER.debug("Missing GUI lang key '{}' (using fallback '{}')", new Object[]{fullKey, fallback});
        }
    }

    public static final class Keys {
        public static final String ARROW_LEFT = "symbol.arrow_left";
        public static final String ARROW_RIGHT = "symbol.arrow_right";
        public static final String ARROW_LEFT_BIG = "symbol.arrow_left_big";
        public static final String ARROW_RIGHT_BIG = "symbol.arrow_right_big";
        public static final String SLASH = "symbol.slash";
        public static final String PLUS = "symbol.plus";
        public static final String MINUS = "symbol.minus";
        public static final String SYMBOL_X = "symbol.x";
        public static final String SYMBOL_EQ = "symbol.eq";
        public static final String SYMBOL_COLON = "symbol.colon";
        public static final String PERCENT = "symbol.percent";
        public static final String BRACKET_OPEN = "symbol.bracket_open";
        public static final String BRACKET_CLOSE = "symbol.bracket_close";
        public static final String ENERGY_EU = "symbol.energy.eu";
        public static final String ENERGY_RF = "symbol.energy.rf";
        public static final String ENERGY_MJ = "symbol.energy.mj";
        public static final String ENERGY_LP = "symbol.energy.lp";
        public static final String ENERGY_AE = "symbol.energy.ae";
        public static final String ENERGY_W = "symbol.energy.w";
        public static final String ENERGY_EU_T = "symbol.energy.eu_t";
        public static final String ENERGY_EU_S = "symbol.energy.eu_s";
        public static final String ENERGY_RF_T = "symbol.energy.rf_t";
        public static final String ENERGY_RF_S = "symbol.energy.rf_s";
        public static final String ENERGY_PER_T = "symbol.energy.per_t";
        public static final String ENERGY_PER_S = "symbol.energy.per_s";
        public static final String UNIT_MB = "unit.mb";
        public static final String UNIT_L = "unit.l";
        public static final String STATE_ON = "state.on";
        public static final String STATE_OFF = "state.off";
        public static final String STATE_YES = "state.yes";
        public static final String STATE_NO = "state.no";
        public static final String STATE_ENABLED = "state.enabled";
        public static final String STATE_DISABLED = "state.disabled";
        public static final String DIR_IN = "dir.in";
        public static final String DIR_OUT = "dir.out";
        public static final String DIR_INPUT = "dir.input";
        public static final String DIR_OUTPUT = "dir.output";
        public static final String LABEL_MAX = "label.max";
        public static final String LABEL_MIN = "label.min";
        public static final String LABEL_AVG = "label.avg";
        public static final String ACTION_ADD = "action.add";
        public static final String ACTION_REMOVE = "action.remove";
        public static final String ACTION_CLEAR = "action.clear";
        public static final String ACTION_RESET = "action.reset";
        public static final String ACTION_APPLY = "action.apply";
        public static final String STATUS_OK = "status.ok";
        public static final String STATUS_ACTIVE = "status.active";
        public static final String STATUS_IDLE = "status.idle";

        private Keys() {
        }
    }
}

