/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.mixins.early;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.gtnewhorizon.gtnhlib.chat.AbstractChatComponentCustom;
import com.gtnewhorizon.gtnhlib.chat.ChatComponentCustomRegistry;
import java.lang.reflect.Type;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.IChatComponent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={IChatComponent.Serializer.class})
public abstract class MixinIChatComponentSerializer {
    @Unique
    private static final String GTNHLIB_ID = "gtnhlib_id";
    @Unique
    private static final String GTNHLIB_PAYLOAD = "gtnhlib_payload";

    @Shadow
    private void func_150695_a(ChatStyle style, JsonObject object, JsonSerializationContext ctx) {
    }

    @Inject(method={"serialize(Lnet/minecraft/util/IChatComponent;Ljava/lang/reflect/Type;Lcom/google/gson/JsonSerializationContext;)Lcom/google/gson/JsonElement;"}, at={@At(value="HEAD")}, cancellable=true)
    private void gtnhlib$serializeCustom(IChatComponent component, Type type, JsonSerializationContext ctx, CallbackInfoReturnable<JsonElement> cir) {
        if (!(component instanceof AbstractChatComponentCustom)) {
            return;
        }
        AbstractChatComponentCustom custom = (AbstractChatComponentCustom)component;
        JsonObject root = new JsonObject();
        root.addProperty(GTNHLIB_ID, custom.getID());
        root.add(GTNHLIB_PAYLOAD, custom.serialize());
        if (!component.func_150256_b().func_150229_g()) {
            this.func_150695_a(component.func_150256_b(), root, ctx);
        }
        if (!component.func_150253_a().isEmpty()) {
            JsonArray extra = new JsonArray();
            for (IChatComponent sib : component.func_150253_a()) {
                extra.add(ctx.serialize((Object)sib, IChatComponent.class));
            }
            root.add("extra", (JsonElement)extra);
        }
        cir.setReturnValue((Object)root);
    }

    @Inject(method={"deserialize(Lcom/google/gson/JsonElement;Ljava/lang/reflect/Type;Lcom/google/gson/JsonDeserializationContext;)Lnet/minecraft/util/IChatComponent;"}, at={@At(value="HEAD")}, cancellable=true)
    private void gtnhlib$deserializeCustom(JsonElement element, Type type, JsonDeserializationContext ctx, CallbackInfoReturnable<IChatComponent> cir) {
        if (!element.isJsonObject()) {
            return;
        }
        JsonObject obj = element.getAsJsonObject();
        if (!obj.has(GTNHLIB_ID)) {
            return;
        }
        JsonElement idEl = obj.get(GTNHLIB_ID);
        if (idEl == null || !idEl.isJsonPrimitive()) {
            throw new JsonParseException("gtnhlib_id must be a JSON string");
        }
        String id = idEl.getAsString();
        AbstractChatComponentCustom chatComponent = ChatComponentCustomRegistry.get(id);
        JsonElement payload = obj.get(GTNHLIB_PAYLOAD);
        if (payload == null) {
            throw new JsonParseException("Missing gtnhlib_payload for id: " + id);
        }
        chatComponent.deserialize(payload);
        if (obj.has("extra")) {
            JsonArray extra = obj.getAsJsonArray("extra");
            if (extra.size() <= 0) {
                throw new JsonParseException("Unexpected empty array of components");
            }
            for (int i = 0; i < extra.size(); ++i) {
                chatComponent.func_150257_a((IChatComponent)ctx.deserialize(extra.get(i), IChatComponent.class));
            }
        }
        chatComponent.func_150255_a((ChatStyle)ctx.deserialize(element, ChatStyle.class));
        cir.setReturnValue((Object)chatComponent);
    }
}

