/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.itemrendering;

import com.gtnewhorizon.gtnhlib.itemrendering.IItemTexture;
import com.gtnewhorizon.gtnhlib.itemrendering.ItemRenderUtils;
import com.gtnewhorizon.gtnhlib.itemrendering.ItemWithTextures;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.opengl.GL11;

public class TexturedItemRenderer
implements IItemRenderer {
    public static final TexturedItemRenderer INSTANCE = new TexturedItemRenderer();

    public static <I extends Item> void register(I item) {
        MinecraftForgeClient.registerItemRenderer(item, (IItemRenderer)INSTANCE);
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return type != IItemRenderer.ItemRenderType.FIRST_PERSON_MAP;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type == IItemRenderer.ItemRenderType.ENTITY && helper == IItemRenderer.ItemRendererHelper.ENTITY_BOBBING || helper == IItemRenderer.ItemRendererHelper.ENTITY_ROTATION && Minecraft.func_71410_x().field_71474_y.field_74347_j;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack stack, Object ... data) {
        Item item = stack.func_77973_b();
        if (!(item instanceof ItemWithTextures)) {
            return;
        }
        ItemWithTextures texturedItem = (ItemWithTextures)item;
        GL11.glEnable((int)3042);
        GL11.glEnable((int)3008);
        ItemRenderUtils.applyStandardItemTransform(type);
        IItemTexture[] textures = texturedItem.getTextures(stack);
        if (textures != null) {
            for (IItemTexture texture : textures) {
                texture.render(type, stack);
            }
        }
        GL11.glDisable((int)3008);
        GL11.glDisable((int)3042);
    }
}

