/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.item;

import com.gtnewhorizon.gtnhlib.GTNHLib;
import com.gtnewhorizon.gtnhlib.capability.item.ItemSink;
import com.gtnewhorizon.gtnhlib.item.ImmutableItemStack;
import com.gtnewhorizon.gtnhlib.item.InsertionItemStack;
import com.gtnewhorizon.gtnhlib.item.InventoryIterator;
import com.gtnewhorizon.gtnhlib.item.StandardInventoryIterator;
import it.unimi.dsi.fastutil.ints.IntIterators;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InventoryItemSink
implements ItemSink {
    public final IInventory inv;
    private final ForgeDirection side;
    private int[] allowedSlots;

    public InventoryItemSink(IInventory inv, ForgeDirection side) {
        this.inv = inv;
        this.side = side;
    }

    protected int[] getSlots() {
        IInventory iInventory = this.inv;
        if (iInventory instanceof ISidedInventory) {
            ISidedInventory sided = (ISidedInventory)iInventory;
            return sided.func_94128_d(this.side.ordinal());
        }
        return IntIterators.unwrap(IntIterators.fromTo(0, this.inv.func_70302_i_()));
    }

    @Override
    public void resetSink() {
        ItemSink.super.resetSink();
        this.allowedSlots = null;
    }

    @Override
    public void setAllowedSinkSlots(int @Nullable [] slots) {
        this.allowedSlots = slots;
    }

    @Override
    public int store(ImmutableItemStack stack) {
        ImmutableItemStack slot;
        if (stack.isEmpty()) {
            return 0;
        }
        StandardInventoryIterator iter = this.sinkIterator();
        InsertionItemStack insertion = new InsertionItemStack(stack);
        while (iter.hasNext()) {
            slot = iter.next();
            if (slot == null || slot.isEmpty()) continue;
            insertion.set(iter.insert(insertion, false));
            if (!insertion.isEmpty()) continue;
            return 0;
        }
        iter.rewind();
        while (iter.hasNext()) {
            slot = iter.next();
            if (slot != null && !slot.isEmpty()) continue;
            insertion.set(iter.insert(insertion, false));
            if (!insertion.isEmpty()) continue;
            return 0;
        }
        return insertion.getStackSize();
    }

    @Override
    @NotNull
    public StandardInventoryIterator sinkIterator() {
        return new StandardInventoryIterator(this.inv, this.side, this.getSlots(), this.allowedSlots){

            @Override
            protected boolean canAccess(ItemStack stack, int slot) {
                return this.canInsert(stack, slot);
            }

            @Override
            protected int getSlotStackLimit(int slot, ItemStack stack) {
                return InventoryItemSink.this.getSlotStackLimit(slot, stack);
            }
        };
    }

    protected int getSlotStackLimit(int slot, ItemStack stack) {
        int existingMaxStack;
        int invStackLimit = this.inv.func_70297_j_();
        int n = existingMaxStack = stack == null ? 64 : stack.func_77976_d();
        if (invStackLimit > 64) {
            return invStackLimit / 64 * existingMaxStack;
        }
        return Math.min(invStackLimit, existingMaxStack);
    }

    @Override
    @Nullable
    public InventoryIterator simulatedSinkIterator() {
        return new StandardInventoryIterator(this.inv, this.side, this.getSlots(), this.allowedSlots){

            @Override
            protected boolean canAccess(ItemStack stack, int slot) {
                return this.canInsert(stack, slot);
            }

            @Override
            protected int getSlotStackLimit(int slot, ItemStack stack) {
                return InventoryItemSink.this.getSlotStackLimit(slot, stack);
            }

            @Override
            protected void setInventorySlotContents(int slot, ItemStack stack) {
            }

            @Override
            protected void markDirty() {
            }

            @Override
            protected boolean canExtract(ItemStack stack, int slot) {
                return false;
            }

            @Override
            public ItemStack extract(int amount, boolean forced) {
                throw new UnsupportedOperationException();
            }

            @Override
            public ImmutableItemStack previous() {
                GTNHLib.LOG.warn("This simulated sink iterator doesn't support backward traversal");
                return null;
            }

            @Override
            public boolean rewind() {
                return false;
            }
        };
    }
}

