/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.geometry;

import com.gtnewhorizon.gtnhlib.geometry.Axis;
import com.gtnewhorizon.gtnhlib.geometry.DirectionTransform;
import com.gtnewhorizon.gtnhlib.geometry.VectorTransform;
import lombok.Generated;
import net.minecraftforge.common.util.ForgeDirection;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3i;

public class Transform
implements DirectionTransform,
VectorTransform {
    public final Matrix4f matrix = new Matrix4f();

    @Override
    public Transform rotate(ForgeDirection vector, int amount) {
        this.matrix.rotate((float)(1.5707963267948966 * (double)amount), Transform.v(vector));
        return this;
    }

    public Transform flip(Axis axis) {
        switch (axis) {
            case X: {
                this.matrix.scale(-1.0f, 1.0f, 1.0f);
                break;
            }
            case Y: {
                this.matrix.scale(1.0f, -1.0f, 1.0f);
                break;
            }
            case Z: {
                this.matrix.scale(1.0f, 1.0f, -1.0f);
            }
        }
        return this;
    }

    public Axis transform(Axis axis) {
        Axis axis2;
        ForgeDirection forgeDirection;
        switch (axis) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case X: {
                forgeDirection = ForgeDirection.EAST;
                break;
            }
            case Y: {
                forgeDirection = ForgeDirection.UP;
                break;
            }
            case Z: {
                forgeDirection = ForgeDirection.SOUTH;
                break;
            }
            case UNKNOWN: {
                forgeDirection = ForgeDirection.UNKNOWN;
            }
        }
        ForgeDirection out = this.transform(forgeDirection);
        switch (out) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case EAST: 
            case WEST: {
                axis2 = Axis.X;
                break;
            }
            case UP: 
            case DOWN: {
                axis2 = Axis.Y;
                break;
            }
            case NORTH: 
            case SOUTH: {
                axis2 = Axis.Z;
                break;
            }
            case UNKNOWN: {
                axis2 = Axis.UNKNOWN;
            }
        }
        return axis2;
    }

    @Override
    public ForgeDirection apply(ForgeDirection direction) {
        return this.transform(direction);
    }

    public ForgeDirection transform(ForgeDirection dir) {
        return Transform.transform(dir, this.matrix);
    }

    public int transform(int bitmask) {
        if (bitmask == 0) {
            return 0;
        }
        int out = 0;
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if ((bitmask & dir.flag) == 0) continue;
            out |= this.transform((ForgeDirection)dir).flag;
        }
        return out;
    }

    public Vector3i transform(Vector3i v) {
        Vector3f v2 = new Vector3f(v).mulTransposeDirection(this.matrix);
        v.x = Math.round(v2.x);
        v.y = Math.round(v2.y);
        v.z = Math.round(v2.z);
        return v;
    }

    @Override
    public Vector3f transform(Vector3f v) {
        return v.mulTransposeDirection(this.matrix);
    }

    @Override
    public Vector3f inverse(Vector3f v) {
        Matrix4f inverse = new Matrix4f(this.matrix).invert();
        return v.mulTransposeDirection(inverse);
    }

    private static Vector3f v(ForgeDirection dir) {
        return new Vector3f(dir.offsetX, dir.offsetY, dir.offsetZ);
    }

    private static ForgeDirection vprime(Vector3f dir) {
        ForgeDirection forgeDirection;
        switch (dir.maxComponent()) {
            case 0: {
                if (dir.x > 0.0f) {
                    forgeDirection = ForgeDirection.EAST;
                    break;
                }
                forgeDirection = ForgeDirection.WEST;
                break;
            }
            case 1: {
                if (dir.y > 0.0f) {
                    forgeDirection = ForgeDirection.UP;
                    break;
                }
                forgeDirection = ForgeDirection.DOWN;
                break;
            }
            case 2: {
                if (dir.z > 0.0f) {
                    forgeDirection = ForgeDirection.SOUTH;
                    break;
                }
                forgeDirection = ForgeDirection.NORTH;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return forgeDirection;
    }

    public static ForgeDirection transform(ForgeDirection dir, Matrix4f transform) {
        if (dir == null) {
            return null;
        }
        if (dir == ForgeDirection.UNKNOWN) {
            return ForgeDirection.UNKNOWN;
        }
        return Transform.vprime(Transform.v(dir).mulTransposeDirection(transform));
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Transform)) {
            return false;
        }
        Transform other = (Transform)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Matrix4f this$matrix = this.matrix;
        Matrix4f other$matrix = other.matrix;
        return !(this$matrix == null ? other$matrix != null : !((Object)this$matrix).equals(other$matrix));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Transform;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Matrix4f $matrix = this.matrix;
        result = result * 59 + ($matrix == null ? 43 : ((Object)$matrix).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Transform(matrix=" + this.matrix + ")";
    }
}

