/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.geometry;

import com.gtnewhorizon.gtnhlib.geometry.Axis;
import com.gtnewhorizon.gtnhlib.geometry.OneDegreeOfFreedom;
import com.gtnewhorizon.gtnhlib.geometry.ThreeDegreesOfFreedom;
import com.gtnewhorizon.gtnhlib.geometry.Transform;
import com.gtnewhorizon.gtnhlib.geometry.TransformLike;
import com.gtnewhorizon.gtnhlib.geometry.TwoDegreesOfFreedom;
import java.util.function.Function;
import net.minecraftforge.common.util.ForgeDirection;

public interface DirectionTransform
extends Function<ForgeDirection, ForgeDirection>,
TransformLike {
    public static final DirectionTransform IDENTITY = dir -> dir;

    default public <T extends OneDegreeOfFreedom<T>> T transform(T value) {
        return (T)((OneDegreeOfFreedom)value.withA((ForgeDirection)this.apply(value.getA())));
    }

    default public <T extends TwoDegreesOfFreedom<T>> T transform(T value) {
        return (T)((TwoDegreesOfFreedom)value.withAB((ForgeDirection)this.apply(value.getA()), (ForgeDirection)this.apply(value.getB())));
    }

    default public <T extends ThreeDegreesOfFreedom<T>> T transform(T value) {
        return (T)((ThreeDegreesOfFreedom)value.withABC((ForgeDirection)this.apply(value.getA()), (ForgeDirection)this.apply(value.getB()), (ForgeDirection)this.apply(value.getC())));
    }

    default public DirectionTransform precalculated() {
        ForgeDirection[] transform = new ForgeDirection[6];
        for (ForgeDirection dir2 : ForgeDirection.VALID_DIRECTIONS) {
            transform[dir2.ordinal()] = (ForgeDirection)this.apply(dir2);
        }
        return dir -> transform[dir.ordinal()];
    }

    default public DirectionTransform inverse() {
        ForgeDirection[] transform = new ForgeDirection[6];
        ForgeDirection[] forgeDirectionArray = ForgeDirection.VALID_DIRECTIONS;
        int n = forgeDirectionArray.length;
        for (int i = 0; i < n; ++i) {
            ForgeDirection dir2;
            transform[((ForgeDirection)this.apply(dir2)).ordinal()] = dir2 = forgeDirectionArray[i];
        }
        return dir -> transform[dir.ordinal()];
    }

    public static DirectionTransform mirror(Axis axis) {
        return axis::flip;
    }

    public static DirectionTransform rotate(ForgeDirection vector, int amount) {
        return new Transform().rotate(vector, amount);
    }
}

