/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.core.fml.transformers;

import com.gtnewhorizon.gtnhlib.asm.ClassConstantPoolParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class TessellatorTransformer
implements IClassTransformer {
    private static final String TessellatorClass = "net/minecraft/client/renderer/Tessellator";
    private static final ClassConstantPoolParser cstPoolParser = new ClassConstantPoolParser("net/minecraft/client/renderer/Tessellator");

    public static List<String> getTransformerExclusions() {
        return Collections.unmodifiableList(new ArrayList());
    }

    public boolean shouldRfbTransform(byte[] basicClass) {
        return cstPoolParser.find(basicClass, false);
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (basicClass == null) {
            return null;
        }
        if (!transformedName.equals("net.minecraft.client.renderer.Tessellator")) {
            return basicClass;
        }
        ClassReader cr = new ClassReader(basicClass);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 0);
        boolean changed = this.transformClassNode(cn);
        if (changed) {
            ClassWriter cw = new ClassWriter(2);
            cn.accept((ClassVisitor)cw);
            return cw.toByteArray();
        }
        return basicClass;
    }

    public boolean transformClassNode(ClassNode cn) {
        if (cn == null) {
            return false;
        }
        return this.transformTessellatorDraw(cn);
    }

    private boolean transformTessellatorDraw(ClassNode cn) {
        for (MethodNode mn : cn.methods) {
            if (!mn.name.equals("draw") && !mn.name.equals("func_78381_a")) continue;
            InsnList inject = new InsnList();
            LabelNode skipLabel = new LabelNode();
            inject.add((AbstractInsnNode)new VarInsnNode(25, 0));
            inject.add((AbstractInsnNode)new MethodInsnNode(184, "com/gtnewhorizon/gtnhlib/client/renderer/TessellatorManager", "shouldInterceptDraw", "(Lnet/minecraft/client/renderer/Tessellator;)Z", false));
            inject.add((AbstractInsnNode)new JumpInsnNode(153, skipLabel));
            inject.add((AbstractInsnNode)new VarInsnNode(25, 0));
            inject.add((AbstractInsnNode)new MethodInsnNode(184, "com/gtnewhorizon/gtnhlib/client/renderer/TessellatorManager", "interceptDraw", "(Lnet/minecraft/client/renderer/Tessellator;)I", false));
            inject.add((AbstractInsnNode)new InsnNode(172));
            inject.add((AbstractInsnNode)skipLabel);
            mn.instructions.insert(inject);
            return true;
        }
        return false;
    }
}

