/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.commands;

import com.gtnewhorizon.gtnhlib.GTNHLibConfig;
import com.gtnewhorizon.gtnhlib.client.ResourcePackUpdater.ResourcePackUpdateChecker;
import com.gtnewhorizon.gtnhlib.commands.GTNHClientCommand;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.StatCollector;

public class CommandResourcePack
extends GTNHClientCommand {
    public String func_71517_b() {
        return "resourcepack";
    }

    @Override
    public String func_71518_a(ICommandSender sender) {
        return "/resourcepack updateCheck [force]";
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        if (args.length == 0 || "help".equalsIgnoreCase(args[0])) {
            this.printHelp();
            return;
        }
        if ("updateCheck".equalsIgnoreCase(args[0])) {
            boolean force;
            boolean bl = force = args.length > 1 && "force".equalsIgnoreCase(args[1]);
            if (!GTNHLibConfig.enableResourcePackUpdateCheck && !force) {
                this.addChatMessage(StatCollector.func_74838_a((String)"gtnhlib.chat.rpupdater.disabled"));
                return;
            }
            ResourcePackUpdateChecker.runManualCheck(force);
            return;
        }
        if ("list".equalsIgnoreCase(args[0])) {
            this.printList();
            return;
        }
        if ("status".equalsIgnoreCase(args[0])) {
            this.printStatus();
            return;
        }
        if ("info".equalsIgnoreCase(args[0])) {
            if (args.length < 2) {
                this.addChatMessage(StatCollector.func_74837_a((String)"gtnhlib.chat.rpupdater.info.usage", (Object[])new Object[]{"/resourcepack info <packName>"}));
                return;
            }
            this.printInfo(args[1]);
            return;
        }
        this.printHelp();
    }

    private void printHelp() {
        this.addChatMessage(StatCollector.func_74838_a((String)"gtnhlib.chat.rpupdater.commands"));
        this.addChatMessage("/resourcepack updateCheck [force]");
        this.addChatMessage("/resourcepack list");
        this.addChatMessage("/resourcepack status");
        this.addChatMessage("/resourcepack info <packName>");
        this.addChatMessage("/resourcepack help");
    }

    private void printList() {
        List<ResourcePackUpdateChecker.PackSummary> packs = ResourcePackUpdateChecker.getActivePackSummaries();
        this.addChatMessage(StatCollector.func_74837_a((String)"gtnhlib.chat.rpupdater.list.header", (Object[])new Object[]{packs.size()}));
        for (ResourcePackUpdateChecker.PackSummary pack : packs) {
            if (pack.hasUpdater) {
                this.addChatMessage(StatCollector.func_74837_a((String)"gtnhlib.chat.rpupdater.list.item.updater", (Object[])new Object[]{pack.packDisplayName, pack.updaterPackName, pack.packVersion, pack.packGameVersion}));
                continue;
            }
            this.addChatMessage(StatCollector.func_74837_a((String)"gtnhlib.chat.rpupdater.list.item.none", (Object[])new Object[]{pack.packDisplayName}));
        }
    }

    private void printStatus() {
        ResourcePackUpdateChecker.StatusSnapshot status = ResourcePackUpdateChecker.getStatusSnapshot();
        this.addChatMessage(StatCollector.func_74838_a((String)"gtnhlib.chat.rpupdater.status.header"));
        this.addChatMessage(StatCollector.func_74837_a((String)"gtnhlib.chat.rpupdater.status.running", (Object[])new Object[]{status.running ? "yes" : "no"}));
        String lastCheck = status.lastCheckMillis == 0L ? StatCollector.func_74838_a((String)"gtnhlib.chat.rpupdater.status.never") : CommandResourcePack.formatSecondsAgo(status.lastCheckMillis);
        this.addChatMessage(StatCollector.func_74837_a((String)"gtnhlib.chat.rpupdater.status.last_check", (Object[])new Object[]{lastCheck}));
        if (status.failureCooldownRemainingMillis > 0L) {
            this.addChatMessage(StatCollector.func_74837_a((String)"gtnhlib.chat.rpupdater.status.cooldown_failure", (Object[])new Object[]{CommandResourcePack.formatSecondsRemaining(status.failureCooldownRemainingMillis)}));
        }
        if (status.manualCooldownRemainingMillis > 0L) {
            this.addChatMessage(StatCollector.func_74837_a((String)"gtnhlib.chat.rpupdater.status.cooldown_manual", (Object[])new Object[]{CommandResourcePack.formatSecondsRemaining(status.manualCooldownRemainingMillis)}));
        }
    }

    private void printInfo(String query) {
        String needle = query.toLowerCase(Locale.ENGLISH);
        List<ResourcePackUpdateChecker.PackSummary> packs = ResourcePackUpdateChecker.getActivePackSummaries();
        ArrayList<ResourcePackUpdateChecker.PackSummary> matches = new ArrayList<ResourcePackUpdateChecker.PackSummary>();
        for (ResourcePackUpdateChecker.PackSummary pack : packs) {
            String updater;
            String display = pack.packDisplayName.toLowerCase(Locale.ENGLISH);
            String string = updater = pack.updaterPackName == null ? "" : pack.updaterPackName.toLowerCase(Locale.ENGLISH);
            if (!display.contains(needle) && !updater.contains(needle)) continue;
            matches.add(pack);
        }
        if (matches.isEmpty()) {
            this.addChatMessage(StatCollector.func_74837_a((String)"gtnhlib.chat.rpupdater.info.not_found", (Object[])new Object[]{query}));
            return;
        }
        if (matches.size() > 1) {
            this.addChatMessage(StatCollector.func_74837_a((String)"gtnhlib.chat.rpupdater.info.ambiguous", (Object[])new Object[]{query, matches.size()}));
            return;
        }
        ResourcePackUpdateChecker.PackSummary pack = (ResourcePackUpdateChecker.PackSummary)matches.get(0);
        this.addChatMessage(StatCollector.func_74837_a((String)"gtnhlib.chat.rpupdater.info.header", (Object[])new Object[]{pack.packDisplayName}));
        if (!pack.hasUpdater) {
            this.addChatMessage(StatCollector.func_74838_a((String)"gtnhlib.chat.rpupdater.info.no_updater"));
            return;
        }
        this.addChatMessage(StatCollector.func_74837_a((String)"gtnhlib.chat.rpupdater.info.updater_name", (Object[])new Object[]{pack.updaterPackName}));
        this.addChatMessage(StatCollector.func_74837_a((String)"gtnhlib.chat.rpupdater.info.version", (Object[])new Object[]{pack.packVersion, pack.packGameVersion}));
        this.addChatMessage(StatCollector.func_74837_a((String)"gtnhlib.chat.rpupdater.info.source", (Object[])new Object[]{pack.owner, pack.repo}));
    }

    private static String formatSecondsRemaining(long millis) {
        long seconds = Math.max(0L, millis / 1000L);
        return seconds + "s";
    }

    private static String formatSecondsAgo(long millis) {
        long seconds = Math.max(0L, (System.currentTimeMillis() - millis) / 1000L);
        return seconds + "s";
    }

    public List func_71516_a(ICommandSender sender, String[] args) {
        if (args.length == 1) {
            return CommandResourcePack.func_71530_a((String[])args, (String[])new String[]{"updateCheck", "list", "status", "info", "help"});
        }
        if (args.length == 2 && "updateCheck".equalsIgnoreCase(args[0])) {
            return CommandResourcePack.func_71530_a((String[])args, (String[])new String[]{"force"});
        }
        return null;
    }
}

