/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.color;

import com.gtnewhorizon.gtnhlib.color.ImmutableColor;

public class RGBColor
implements ImmutableColor {
    public static final ImmutableColor WHITE = new RGBColor(255, 255, 255, 255);
    public int red;
    public int green;
    public int blue;
    public int alpha;

    public RGBColor() {
    }

    public RGBColor(int red, int green, int blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = 255;
    }

    public RGBColor(int red, int green, int blue, int alpha) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
    }

    public RGBColor set(int red, int green, int blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = 255;
        return this;
    }

    public RGBColor set(int red, int green, int blue, int alpha) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
        return this;
    }

    @Override
    public int getRed() {
        return this.red;
    }

    @Override
    public int getGreen() {
        return this.green;
    }

    @Override
    public int getBlue() {
        return this.blue;
    }

    @Override
    public int getAlpha() {
        return this.alpha;
    }

    public static RGBColor fromRGB(int value) {
        return new RGBColor(value >> 16 & 0xFF, value >> 8 & 0xFF, value & 0xFF, 255);
    }

    public static RGBColor fromARGB(int value) {
        return new RGBColor(value >> 16 & 0xFF, value >> 8 & 0xFF, value & 0xFF, value >> 24 & 0xFF);
    }

    public static RGBColor fromRGBA(int value) {
        return new RGBColor(value >> 24 & 0xFF, value >> 16 & 0xFF, value >> 8 & 0xFF, value & 0xFF);
    }

    public static RGBColor fromABGR(int value) {
        return new RGBColor(value & 0xFF, value >> 8 & 0xFF, value >> 16 & 0xFF, value >> 24 & 0xFF);
    }

    public final boolean equals(Object o) {
        if (!(o instanceof RGBColor)) {
            return false;
        }
        RGBColor RGBColor2 = (RGBColor)o;
        return this.red == RGBColor2.red && this.green == RGBColor2.green && this.blue == RGBColor2.blue && this.alpha == RGBColor2.alpha;
    }

    public int hashCode() {
        int result = this.red;
        result = 31 * result + this.green;
        result = 31 * result + this.blue;
        result = 31 * result + this.alpha;
        return result;
    }

    public String toString() {
        return "Color{red=" + this.red + ", green=" + this.green + ", blue=" + this.blue + ", alpha=" + this.alpha + '}';
    }
}

