/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.renderer.vertex;

import com.gtnewhorizon.gtnhlib.bytebuf.MemoryUtilities;
import com.gtnewhorizon.gtnhlib.client.renderer.cel.model.quad.ModelQuadView;
import com.gtnewhorizon.gtnhlib.client.renderer.cel.model.quad.ModelQuadViewMutable;
import com.gtnewhorizon.gtnhlib.client.renderer.vertex.DefaultVertexFormat;
import com.gtnewhorizon.gtnhlib.client.renderer.vertex.VertexFormatElement;
import it.unimi.dsi.fastutil.objects.ObjectImmutableList;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.minecraft.client.renderer.Tessellator;

public class VertexFormat {
    protected final List<VertexFormatElement> elements;
    protected final int vertexSize;
    protected final int[] offsets;
    protected static final List<SetupBufferState> setupBufferStateOverrride = new ArrayList<SetupBufferState>();
    protected static final List<ClearBufferState> clearBufferStateOverrride = new ArrayList<ClearBufferState>();
    protected final int vertexFlags;

    public static void registerSetupBufferStateOverride(SetupBufferState override) {
        setupBufferStateOverrride.add(override);
    }

    public static void registerClearBufferStateOverride(ClearBufferState override) {
        clearBufferStateOverrride.add(override);
    }

    public VertexFormat(VertexFormatElement ... elements) {
        int length = elements.length;
        this.offsets = new int[length];
        int offset = 0;
        int flags = 0;
        for (int i = 0; i < length; ++i) {
            VertexFormatElement element = elements[i];
            this.offsets[i] = offset;
            offset += element.getByteSize();
            flags |= element.vertexBit;
        }
        this.vertexFlags = flags;
        this.elements = new ObjectImmutableList<VertexFormatElement>(elements);
        this.vertexSize = offset;
        DefaultVertexFormat.ALL_FORMATS[this.vertexFlags] = this;
    }

    public void setupBufferState(long l) {
        int i;
        int overrideSize = setupBufferStateOverrride.size();
        for (i = 0; i < overrideSize; ++i) {
            SetupBufferState override = setupBufferStateOverrride.get(i);
            if (!override.run(this, l)) continue;
            return;
        }
        i = this.getVertexSize();
        List<VertexFormatElement> list = this.getElements();
        int listSize = list.size();
        for (int j = 0; j < listSize; ++j) {
            list.get(j).setupBufferState(l + (long)this.offsets[j], i);
        }
    }

    public void clearBufferState() {
        int overrideSize = clearBufferStateOverrride.size();
        for (int i = 0; i < overrideSize; ++i) {
            ClearBufferState override = clearBufferStateOverrride.get(i);
            if (!override.run(this)) continue;
            return;
        }
        List<VertexFormatElement> list = this.getElements();
        int listSize = list.size();
        for (int i = 0; i < listSize; ++i) {
            list.get(i).clearBufferState();
        }
    }

    @Deprecated
    public boolean canWriteQuads() {
        return true;
    }

    public final void writeQuads(List<ModelQuadViewMutable> quads, ByteBuffer out) {
        int size = quads.size();
        if (out.remaining() < this.getVertexSize() * size) {
            throw new IllegalArgumentException("Buffer only has " + out.remaining() + " out of " + this.getVertexSize() * size + " bytes remaining.");
        }
        List<VertexFormatElement> list = this.getElements();
        int listSize = list.size();
        long address = MemoryUtilities.memAddress0(out);
        long writePointer = address + (long)out.position();
        for (int i = 0; i < size; ++i) {
            ModelQuadView quad = quads.get(i);
            int[] data = quad.getDataArray();
            for (int index = 0; index < 32; index += 8) {
                for (int j = 0; j < listSize; ++j) {
                    writePointer += (long)list.get((int)j).writer.writeAttribute(writePointer, data, index);
                }
            }
        }
        out.position((int)(writePointer - address));
    }

    public final void writeQuad(ModelQuadView quad, ByteBuffer out) {
        if (out.remaining() < this.getVertexSize()) {
            throw new IllegalArgumentException("Buffer only has " + out.remaining() + " out of " + this.getVertexSize() + " bytes remaining.");
        }
        int[] data = quad.getDataArray();
        List<VertexFormatElement> list = this.getElements();
        int listSize = list.size();
        long address = MemoryUtilities.memAddress0(out);
        long writePointer = address + (long)out.position();
        for (int index = 0; index < 32; index += 8) {
            for (int i = 0; i < listSize; ++i) {
                writePointer += (long)list.get((int)i).writer.writeAttribute(writePointer, data, index);
            }
        }
        out.position((int)(writePointer - address));
    }

    public final long writeToBuffer0(long pointer, int[] data, int rawVertexCount) {
        List<VertexFormatElement> list = this.getElements();
        int listSize = list.size();
        for (int index = 0; index < rawVertexCount; index += 8) {
            for (int i = 0; i < listSize; ++i) {
                pointer += (long)list.get((int)i).writer.writeAttribute(pointer, data, index);
            }
        }
        return pointer;
    }

    public final long writeToBuffer0(long pointer, Tessellator tessellator, float x, float y, float z) {
        MemoryUtilities.memPutFloat(pointer, x);
        MemoryUtilities.memPutFloat(pointer + 4L, y);
        MemoryUtilities.memPutFloat(pointer + 8L, z);
        pointer += 12L;
        List<VertexFormatElement> list = this.getElements();
        int listSize = list.size();
        for (int i = 1; i < listSize; ++i) {
            pointer += (long)list.get((int)i).writer.writeAttribute(pointer, tessellator);
        }
        return pointer;
    }

    public final long readFromBuffer0(long pointer, Tessellator tessellator) {
        List<VertexFormatElement> list = this.getElements();
        int listSize = list.size();
        for (int i = 1; i < listSize; ++i) {
            pointer += (long)list.get((int)i).writer.readAttribute(pointer, tessellator);
        }
        return pointer;
    }

    public final int getVertexCount(ByteBuffer buffer) {
        return this.getVertexCount(buffer.limit());
    }

    public final int getVertexCount(int bufferSize) {
        return bufferSize / this.vertexSize;
    }

    public final int getVertexFlags() {
        return this.vertexFlags;
    }

    public final boolean hasTexture() {
        return (this.vertexFlags & 1) != 0;
    }

    public final boolean hasColor() {
        return (this.vertexFlags & 2) != 0;
    }

    public final boolean hasNormals() {
        return (this.vertexFlags & 4) != 0;
    }

    public final boolean hasBrightness() {
        return (this.vertexFlags & 8) != 0;
    }

    @Generated
    public List<VertexFormatElement> getElements() {
        return this.elements;
    }

    @Generated
    public int getVertexSize() {
        return this.vertexSize;
    }

    @FunctionalInterface
    public static interface SetupBufferState {
        public boolean run(VertexFormat var1, long var2);
    }

    @FunctionalInterface
    public static interface ClearBufferState {
        public boolean run(VertexFormat var1);
    }
}

