/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.renderer.vbo;

import com.gtnewhorizon.gtnhlib.client.renderer.vbo.IVertexBuffer;
import com.gtnewhorizon.gtnhlib.client.renderer.vertex.VertexFormat;
import java.nio.ByteBuffer;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;

public class VertexBuffer
implements IVertexBuffer,
AutoCloseable {
    protected int id = GL15.glGenBuffers();
    protected int vertexCount;
    protected final VertexFormat format;
    protected final int drawMode;

    public VertexBuffer(VertexFormat format, int drawMode) {
        this.format = format;
        this.drawMode = drawMode;
    }

    public VertexBuffer(VertexFormat format, int drawMode, ByteBuffer buffer, int vertexCount) {
        this(format, drawMode);
        this.allocate(buffer, vertexCount);
    }

    @Override
    public void bind() {
        GL15.glBindBuffer((int)34962, (int)this.id);
    }

    @Override
    public void unbind() {
        GL15.glBindBuffer((int)34962, (int)0);
    }

    protected final void bindVBO() {
        GL15.glBindBuffer((int)34962, (int)this.id);
    }

    protected final void unbindVBO() {
        GL15.glBindBuffer((int)34962, (int)0);
    }

    public void upload(ByteBuffer buffer, int vertexCount, int type) {
        this.vertexCount = vertexCount;
        this.bindVBO();
        GL15.glBufferData((int)34962, (ByteBuffer)buffer, (int)type);
        this.unbindVBO();
    }

    @Override
    public void allocate(ByteBuffer buffer, int vertexCount) {
        this.upload(buffer, vertexCount, 35044);
    }

    @Override
    public void update(ByteBuffer buffer, long offset) {
        this.bindVBO();
        GL15.glBufferSubData((int)34962, (long)offset, (ByteBuffer)buffer);
        this.unbindVBO();
    }

    public VertexBuffer upload(ByteBuffer buffer) {
        this.upload(buffer, this.format.getVertexCount(buffer), 35044);
        return this;
    }

    public void upload(ByteBuffer buffer, int vertexCount) {
        this.upload(buffer, vertexCount, 35044);
    }

    public void uploadDynamic(ByteBuffer buffer, int vertexCount) {
        this.upload(buffer, vertexCount, 35048);
    }

    public void uploadDynamic(ByteBuffer buffer) {
        this.upload(buffer, this.format.getVertexCount(buffer), 35048);
    }

    public void uploadStream(ByteBuffer buffer, int vertexCount) {
        this.upload(buffer, vertexCount, 35040);
    }

    public void uploadStream(ByteBuffer buffer) {
        this.upload(buffer, this.format.getVertexCount(buffer), 35040);
    }

    @Override
    @Deprecated
    public final void close() {
        this.delete();
    }

    @Override
    public void delete() {
        if (this.id > 0) {
            GL15.glDeleteBuffers((int)this.id);
            this.id = -1;
        }
    }

    @Override
    public void setupState() {
        this.bindVBO();
        this.format.setupBufferState(0L);
    }

    @Override
    public void cleanupState() {
        this.format.clearBufferState();
        this.unbindVBO();
    }

    @Override
    public final void draw() {
        GL11.glDrawArrays((int)this.drawMode, (int)0, (int)this.vertexCount);
    }

    @Override
    public final void draw(int first, int count) {
        GL11.glDrawArrays((int)this.drawMode, (int)first, (int)count);
    }

    @Override
    public final void draw(int drawMode, int first, int count) {
        GL11.glDrawArrays((int)drawMode, (int)first, (int)count);
    }

    @Override
    public final VertexFormat getVertexFormat() {
        return this.format;
    }

    @Override
    public final int getId() {
        return this.id;
    }

    @Override
    public final int getDrawMode() {
        return this.drawMode;
    }

    @Override
    public final int getVertexCount() {
        return this.vertexCount;
    }
}

