/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.renderer.vbo;

import com.gtnewhorizon.gtnhlib.client.renderer.vertex.VertexFormat;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import org.lwjgl.opengl.GL11;

public interface IVertexBuffer {
    public void bind();

    public void unbind();

    public void allocate(ByteBuffer var1, int var2);

    default public void allocate(ByteBuffer buffer) {
        this.allocate(buffer, this.getVertexFormat().getVertexCount(buffer));
    }

    public void update(ByteBuffer var1, long var2);

    default public void update(ByteBuffer buffer) {
        this.update(buffer, 0L);
    }

    public void setupState();

    public void cleanupState();

    public void draw();

    public void draw(int var1, int var2);

    public void draw(int var1, int var2, int var3);

    public void delete();

    public VertexFormat getVertexFormat();

    public int getId();

    public int getDrawMode();

    public int getVertexCount();

    default public void render() {
        this.setupState();
        this.draw();
        this.cleanupState();
    }

    default public void draw(FloatBuffer matrix) {
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glMultMatrix((FloatBuffer)matrix);
        this.draw();
        GL11.glPopMatrix();
    }
}

