/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.renderer.vao;

import com.gtnewhorizon.gtnhlib.client.renderer.vao.IVertexArrayObject;
import com.gtnewhorizon.gtnhlib.client.renderer.vao.IndexBuffer;
import com.gtnewhorizon.gtnhlib.client.renderer.vao.VAOManager;
import com.gtnewhorizon.gtnhlib.client.renderer.vao.VertexBufferFactory;
import com.gtnewhorizon.gtnhlib.client.renderer.vertex.VertexFormat;
import java.nio.ByteBuffer;

public enum VertexBufferType implements VertexBufferFactory
{
    MUTABLE_RESIZABLE{

        @Override
        public final IVertexArrayObject allocate(VertexFormat format, int drawMode, ByteBuffer data, int vertexCount) {
            return VAOManager.allocateMutableVAO(format, drawMode, data, vertexCount);
        }

        @Override
        public IVertexArrayObject allocate(VertexFormat format, int drawMode, ByteBuffer data, int vertexCount, IndexBuffer ebo) {
            return VAOManager.allocateMutableVAO(format, drawMode, data, vertexCount, ebo);
        }
    }
    ,
    MUTABLE{

        @Override
        public final IVertexArrayObject allocate(VertexFormat format, int drawMode, ByteBuffer data, int vertexCount) {
            return VAOManager.allocateStorageVAO(format, drawMode, data, vertexCount, 256);
        }

        @Override
        public IVertexArrayObject allocate(VertexFormat format, int drawMode, ByteBuffer data, int vertexCount, IndexBuffer ebo) {
            return VAOManager.allocateStorageVAO(format, drawMode, data, vertexCount, 256, ebo);
        }
    }
    ,
    IMMUTABLE{

        @Override
        public final IVertexArrayObject allocate(VertexFormat format, int drawMode, ByteBuffer data, int vertexCount) {
            return VAOManager.allocateStorageVAO(format, drawMode, data, vertexCount, 0);
        }

        @Override
        public IVertexArrayObject allocate(VertexFormat format, int drawMode, ByteBuffer data, int vertexCount, IndexBuffer ebo) {
            return VAOManager.allocateStorageVAO(format, drawMode, data, vertexCount, 0, ebo);
        }
    };

}

