/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.renderer.vao;

import com.google.common.annotations.Beta;
import com.gtnewhorizon.gtnhlib.client.renderer.vbo.IVertexBuffer;
import com.gtnewhorizon.gtnhlib.client.renderer.vertex.VertexFormat;
import java.nio.ByteBuffer;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL44;

@Beta
public final class VertexBufferStorage
implements IVertexBuffer {
    private int id = GL15.glGenBuffers();
    private int vertexCount;
    private final VertexFormat format;
    private final int drawMode;
    private final int flags;

    public VertexBufferStorage(VertexFormat format, int drawMode, int flags) {
        this.format = format;
        this.drawMode = drawMode;
        this.flags = flags;
    }

    public VertexBufferStorage(VertexFormat format, int drawMode, ByteBuffer data, int vertexCount, int flags) {
        this(format, drawMode, flags);
        this.allocate(data, vertexCount);
    }

    @Override
    public void allocate(ByteBuffer data, int vertexCount) {
        this.vertexCount = vertexCount;
        this.bind();
        GL44.glBufferStorage((int)34962, (ByteBuffer)data, (int)this.flags);
        this.unbind();
    }

    @Override
    public void update(ByteBuffer buffer, long offset) {
        if ((this.flags & 0x100) == 0) {
            throw new UnsupportedOperationException("Cannot call update() on an immutable buffer!");
        }
        this.bind();
        GL15.glBufferSubData((int)34962, (long)offset, (ByteBuffer)buffer);
        this.unbind();
    }

    @Override
    public void bind() {
        GL15.glBindBuffer((int)34962, (int)this.id);
    }

    @Override
    public void unbind() {
        GL15.glBindBuffer((int)34962, (int)0);
    }

    @Override
    public void delete() {
        if (this.id > 0) {
            GL15.glDeleteBuffers((int)this.id);
            this.id = -1;
        }
    }

    @Override
    public void setupState() {
        this.bind();
        this.format.setupBufferState(0L);
    }

    @Override
    public void cleanupState() {
        this.format.clearBufferState();
        this.unbind();
    }

    @Override
    public void draw() {
        GL11.glDrawArrays((int)this.drawMode, (int)0, (int)this.vertexCount);
    }

    @Override
    public void draw(int first, int count) {
        GL11.glDrawArrays((int)this.drawMode, (int)first, (int)count);
    }

    @Override
    public void draw(int drawMode, int first, int count) {
        GL11.glDrawArrays((int)drawMode, (int)first, (int)count);
    }

    @Override
    public VertexFormat getVertexFormat() {
        return this.format;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public int getDrawMode() {
        return this.drawMode;
    }

    @Override
    public int getVertexCount() {
        return this.vertexCount;
    }
}

