/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.renderer.vao;

import com.gtnewhorizon.gtnhlib.bytebuf.MemoryUtilities;
import com.gtnewhorizon.gtnhlib.client.opengl.GLCaps;
import java.nio.ByteBuffer;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL44;

public final class IndexBuffer {
    static final int EBO_DATA_TYPE = 5123;
    static final int EBO_DATA_SIZE = 2;
    private int id = GL15.glGenBuffers();

    public void bind() {
        GL15.glBindBuffer((int)34963, (int)this.id);
    }

    public void unbind() {
        GL15.glBindBuffer((int)34963, (int)0);
    }

    public void delete() {
        if (this.id > 0) {
            GL15.glDeleteBuffers((int)this.id);
            this.id = -1;
        }
    }

    public void allocateImmutable(ByteBuffer data) {
        if (GLCaps.bufferStorageSupported()) {
            this.bind();
            GL44.glBufferStorage((int)34963, (ByteBuffer)data, (int)0);
            this.unbind();
            return;
        }
        this.upload(data);
    }

    public void upload(ByteBuffer data) {
        this.bind();
        GL15.glBufferData((int)34963, (ByteBuffer)data, (int)35044);
        this.unbind();
    }

    public void upload(int vertexCount) {
        this.upload(0, vertexCount);
    }

    public void upload(int start, int end) {
        ByteBuffer data = IndexBuffer.createQuadEBOBuffer(start, end);
        this.upload(data);
        MemoryUtilities.memFree(data);
    }

    public int getId() {
        return this.id;
    }

    private static ByteBuffer createQuadEBOBuffer(int vertexCount) {
        return IndexBuffer.createQuadEBOBuffer(0, vertexCount);
    }

    private static ByteBuffer createQuadEBOBuffer(int start, int end) {
        int quadCount = (end - start) / 4;
        ByteBuffer data = MemoryUtilities.memAlloc(quadCount * 6 * 2);
        long ptr = MemoryUtilities.memAddress0(data);
        for (int i = 0; i < quadCount; ++i) {
            int base = start + i * 4;
            MemoryUtilities.memPutShort(ptr, (short)base);
            MemoryUtilities.memPutShort(ptr + 2L, (short)(base + 1));
            MemoryUtilities.memPutShort(ptr + 4L, (short)(base + 2));
            MemoryUtilities.memPutShort(ptr + 6L, (short)(base + 2));
            MemoryUtilities.memPutShort(ptr + 8L, (short)(base + 3));
            MemoryUtilities.memPutShort(ptr + 10L, (short)base);
            ptr += 12L;
        }
        return data;
    }

    public static IndexBuffer convertQuadsToTrigs(int vertexCount) {
        return IndexBuffer.convertQuadsToTrigs(0, vertexCount);
    }

    public static IndexBuffer convertQuadsToTrigs(int start, int end) {
        IndexBuffer ebo = new IndexBuffer();
        ByteBuffer data = IndexBuffer.createQuadEBOBuffer(start, end);
        ebo.allocateImmutable(data);
        MemoryUtilities.memFree(data);
        return ebo;
    }
}

