/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.renderer.vao;

import com.gtnewhorizon.gtnhlib.client.renderer.vao.IVertexArrayObject;
import com.gtnewhorizon.gtnhlib.client.renderer.vao.VAOManager;
import com.gtnewhorizon.gtnhlib.client.renderer.vbo.IVertexBuffer;

public class BaseVAO
implements IVertexArrayObject {
    protected int vaoID = -1;
    protected final IVertexBuffer vbo;

    public BaseVAO(IVertexBuffer vbo) {
        this.vbo = vbo;
    }

    @Override
    public final void bind() {
        if (this.isInitialized()) {
            VAOManager.VAO.glBindVertexArray(this.vaoID);
            return;
        }
        this.vaoID = VAOManager.VAO.glGenVertexArrays();
        VAOManager.VAO.glBindVertexArray(this.vaoID);
        this.setupVAOStates();
    }

    @Override
    public final void unbind() {
        VAOManager.VAO.glBindVertexArray(0);
    }

    @Override
    public void draw() {
        this.vbo.draw();
    }

    @Override
    public void draw(int first, int count) {
        this.vbo.draw(first, count);
    }

    @Override
    public void draw(int drawMode, int first, int count) {
        this.vbo.draw(drawMode, first, count);
    }

    @Override
    public void delete() {
        this.vbo.delete();
        if (this.vaoID >= 0) {
            VAOManager.VAO.glDeleteVertexArrays(this.vaoID);
            this.vaoID = -1;
        }
    }

    @Override
    public final IVertexBuffer getVBO() {
        return this.vbo;
    }

    protected void setupVAOStates() {
        this.vbo.setupState();
        this.vbo.unbind();
    }

    protected final boolean isInitialized() {
        return this.vaoID != -1;
    }
}

