/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.renderer.postprocessing.shaders;

import com.gtnewhorizon.gtnhlib.client.renderer.shader.ShaderProgram;
import com.gtnewhorizon.gtnhlib.client.renderer.textures.TextureAtlas;
import com.gtnewhorizon.gtnhlib.mixins.early.EntityRendererAccessor;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import org.joml.Vector3f;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL20;

public final class UniversiumShader
extends ShaderProgram {
    private static UniversiumShader instance;
    private final TextureAtlas textureAtlas;
    private static boolean inventoryRenderPass;
    private boolean renderInInventory;
    private boolean lastInventoryRender;
    private final int location_lightlevel;
    private final Vector3f lightLevel = new Vector3f(1.0f);
    private final Vector3f lastLightLevel = new Vector3f(-1.0f);
    private final int location_time;
    private final int location_yaw;
    private final int location_pitch;
    private final int location_externalScale;
    private final int location_opacity;
    private float cosmicOpacity = 1.0f;
    private float lastCosmicOpacity = -1.0f;
    private final int location_starColorMultiplier;
    private final Vector3f starColorMultiplier = new Vector3f(0.3f, 0.4f, 0.3f);
    private final Vector3f lastStarColorMultiplier = new Vector3f(-1.0f);
    private static final float MUL_R = 0.3f;
    private static final float MUL_G = 0.4f;
    private static final float MUL_B = 0.3f;
    private final int location_starColorBase;
    private final Vector3f starColorBase = new Vector3f(0.4f, 0.6f, 0.7f);
    private final Vector3f lastStarColorBase = new Vector3f(-1.0f);
    private static final float BASE_R = 0.4f;
    private static final float BASE_G = 0.6f;
    private static final float BASE_B = 0.7f;
    private final int location_bgColor;
    private final Vector3f bgColor = new Vector3f();
    private final Vector3f lastBgColor = new Vector3f(-1.0f);
    private boolean useCustomBGColor;
    private final int location_cosmicuvs;

    private UniversiumShader() {
        super("gtnhlib", "shaders/avaritia/universium.vert", "shaders/avaritia/universium.frag");
        super.use();
        this.location_lightlevel = this.getUniformLocation("lightlevel");
        this.location_time = this.getUniformLocation("time");
        this.location_yaw = this.getUniformLocation("yaw");
        this.location_pitch = this.getUniformLocation("pitch");
        this.location_externalScale = this.getUniformLocation("externalScale");
        int location_lightmix = this.getUniformLocation("lightmix");
        this.location_opacity = this.getUniformLocation("opacity");
        this.location_starColorMultiplier = this.getUniformLocation("starColorMultiplier");
        this.location_bgColor = this.getUniformLocation("bgColor");
        this.location_cosmicuvs = this.getUniformLocation("cosmicuvs");
        this.location_starColorBase = this.getUniformLocation("starColorBase");
        GL20.glUniform1f((int)location_lightmix, (float)0.2f);
        GL20.glUniform1f((int)this.location_externalScale, (float)1.0f);
        this.bindTextureSlot("texture0", 0);
        this.bindTextureSlot("cosmicTexture", 2);
        UniversiumShader.unbind();
        this.textureAtlas = TextureAtlas.createTextureAtlas("gtnhlib", "textures/avaritia/cosmic", 10);
    }

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
    }

    public static UniversiumShader getInstance() {
        if (instance == null) {
            instance = new UniversiumShader();
        }
        return instance;
    }

    @Override
    public void use() {
        boolean shouldRenderInventory;
        super.use();
        long sysTime = System.currentTimeMillis();
        float time = (float)(sysTime % 600000L) / 50.0f;
        GL20.glUniform1f((int)this.location_time, (float)time);
        boolean bl = shouldRenderInventory = inventoryRenderPass || this.renderInInventory;
        if (shouldRenderInventory) {
            if (!this.lastInventoryRender) {
                GL20.glUniform1f((int)this.location_yaw, (float)0.0f);
                GL20.glUniform1f((int)this.location_pitch, (float)0.0f);
                GL20.glUniform1f((int)this.location_externalScale, (float)25.0f);
                this.lastInventoryRender = true;
            }
            this.renderInInventory = false;
        } else {
            if (this.lastInventoryRender) {
                GL20.glUniform1f((int)this.location_externalScale, (float)1.0f);
                this.lastInventoryRender = false;
            }
            Minecraft mc = Minecraft.func_71410_x();
            float yaw = (float)((double)(mc.field_71439_g.field_70177_z * 2.0f) * Math.PI / 360.0);
            GL20.glUniform1f((int)this.location_yaw, (float)yaw);
            float pitch = -((float)((double)(mc.field_71439_g.field_70125_A * 2.0f) * Math.PI / 360.0));
            GL20.glUniform1f((int)this.location_pitch, (float)pitch);
        }
        if (this.lastCosmicOpacity != this.cosmicOpacity) {
            GL20.glUniform1f((int)this.location_opacity, (float)this.cosmicOpacity);
            this.lastCosmicOpacity = this.cosmicOpacity;
        }
        this.cosmicOpacity = 1.0f;
        this.glUniform3f(this.location_starColorMultiplier, this.starColorMultiplier, this.lastStarColorMultiplier);
        this.glUniform3f(this.location_starColorBase, this.starColorBase, this.lastStarColorBase);
        this.starColorMultiplier.set(0.3f, 0.4f, 0.3f);
        this.starColorBase.set(0.4f, 0.6f, 0.7f);
        this.glUniform3f(this.location_lightlevel, this.lightLevel, this.lastLightLevel);
        this.lightLevel.set(1.0f, 1.0f, 1.0f);
        if (!this.useCustomBGColor) {
            float pulse = (float)(sysTime % 20000L) / 20000.0f;
            this.bgColor.set(0.1f, MathHelper.func_76126_a((float)((float)((double)pulse * Math.PI * 2.0))) * 0.075f + 0.225f, MathHelper.func_76134_b((float)((float)((double)pulse * Math.PI * 2.0))) * 0.05f + 0.3f);
        }
        this.glUniform3f(this.location_bgColor, this.bgColor, this.lastBgColor);
        this.useCustomBGColor = false;
        this.textureAtlas.uploadVBuffer(this.location_cosmicuvs);
        GL13.glActiveTexture((int)33986);
        this.textureAtlas.bindTexture();
        GL13.glActiveTexture((int)33984);
    }

    public UniversiumShader setCosmicOpacity(float opacity) {
        this.cosmicOpacity = opacity;
        return this;
    }

    public UniversiumShader setStarColor(float mulR, float mulG, float mulB, float baseR, float baseG, float baseB) {
        this.starColorMultiplier.set(mulR, mulG, mulB);
        this.starColorBase.set(baseR, baseG, baseB);
        return this;
    }

    public UniversiumShader setStarColor(float mul) {
        return this.setStarColor(0.3f * mul, 0.4f * mul, 0.3f * mul, 0.4f * mul, 0.6f * mul, 0.7f * mul);
    }

    public UniversiumShader setRenderInInventory() {
        this.renderInInventory = true;
        return this;
    }

    public UniversiumShader setBackgroundColor(float r, float g, float b) {
        this.bgColor.set(r, g, b);
        this.useCustomBGColor = true;
        return this;
    }

    public UniversiumShader setLightFromLocation(World world, int x, int y, int z) {
        if (world == null) {
            return this.setLightLevel(1.0f);
        }
        int coord = world.func_72802_i(x, y, z, 0);
        int[] map = ((EntityRendererAccessor)Minecraft.func_71410_x().field_71460_t).getLightmapColors();
        if (map == null) {
            return this.setLightLevel(1.0f);
        }
        int mx = coord % 65536 / 16;
        int my = coord / 65536 / 16;
        int lightColour = map[Math.max(0, Math.min(map.length - 1, my * 16 + mx))];
        return this.setLightLevel((float)(lightColour >> 16 & 0xFF) / 255.0f, (float)(lightColour >> 8 & 0xFF) / 255.0f, (float)(lightColour & 0xFF) / 255.0f);
    }

    public UniversiumShader setLightLevel(float level) {
        return this.setLightLevel(level, level, level);
    }

    public UniversiumShader setLightLevel(float r, float g, float b) {
        this.lightLevel.set(MathHelper.func_76131_a((float)r, (float)0.0f, (float)1.0f), MathHelper.func_76131_a((float)g, (float)0.0f, (float)1.0f), MathHelper.func_76131_a((float)b, (float)0.0f, (float)1.0f));
        return this;
    }

    public static boolean isRenderingInInventory() {
        return inventoryRenderPass;
    }

    public static final class EventHandler {
        @SubscribeEvent
        public void makeCosmicStuffLessDumbInGUIs(GuiScreenEvent.DrawScreenEvent.Pre event) {
            inventoryRenderPass = true;
        }

        @SubscribeEvent
        public void finishMakingCosmicStuffLessDumbInGUIs(GuiScreenEvent.DrawScreenEvent.Post event) {
            inventoryRenderPass = false;
        }
    }
}

