/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.renderer.postprocessing.shaders;

import com.google.common.annotations.Beta;
import com.gtnewhorizon.gtnhlib.client.renderer.postprocessing.PostProcessingHelper;
import com.gtnewhorizon.gtnhlib.client.renderer.shader.ShaderProgram;
import net.minecraft.client.Minecraft;
import net.minecraft.util.MathHelper;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL20;

@Beta
public class BloomTonemapShader {
    private static final float TONEMAP_VALUE = 1.9f;
    private static ShaderProgram shader;
    private static int uMultiplier;
    private static float tonemapMultiplier;
    private static BloomTonemapShader instance;

    public BloomTonemapShader() {
        shader = new ShaderProgram("gtnhlib", "shaders/hdr/tonemap.vert.glsl", "shaders/hdr/tonemap.frag.glsl");
        shader.use();
        uMultiplier = shader.getUniformLocation("multiplier");
        shader.bindTextureSlot("uScene", 0);
        shader.bindTextureSlot("uOverlay", 1);
        ShaderProgram.clear();
    }

    public static BloomTonemapShader getInstance() {
        if (instance == null) {
            instance = new BloomTonemapShader();
        }
        return instance;
    }

    public void applyTonemapping(float multiplier, int overlayTexture) {
        shader.use();
        if (tonemapMultiplier != multiplier) {
            GL20.glUniform1f((int)uMultiplier, (float)multiplier);
            tonemapMultiplier = multiplier;
        }
        Minecraft.func_71410_x().func_147110_a().func_147612_c();
        GL13.glActiveTexture((int)33985);
        GL11.glBindTexture((int)3553, (int)overlayTexture);
        GL11.glDisable((int)3042);
        PostProcessingHelper.drawFullscreenQuad();
        GL13.glActiveTexture((int)33984);
    }

    public static float tonemap(float x) {
        float a = 2.51f;
        float b = 0.03f;
        float c = 2.43f;
        float d = 0.59f;
        float e = 0.14f;
        return MathHelper.func_76131_a((float)(x * (2.51f * x + 0.03f) / (x * (2.43f * x + 0.59f) + 0.14f)), (float)0.0f, (float)1.0f);
    }
}

