/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.renderer.postprocessing;

import com.gtnewhorizon.gtnhlib.client.opengl.GLCaps;
import com.gtnewhorizon.gtnhlib.client.renderer.postprocessing.CustomFramebuffer;
import com.gtnewhorizon.gtnhlib.compat.Mods;
import net.coderbot.iris.rendertarget.IRenderTargetExt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.shader.Framebuffer;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.opengl.GL11;

public class SharedDepthFramebuffer
extends CustomFramebuffer {
    private final Framebuffer linkedBuffer;

    public SharedDepthFramebuffer(int settings, Framebuffer linkedBuffer) {
        super(settings);
        if (linkedBuffer == null) {
            throw new IllegalArgumentException("linkedBuffer cannot be null!");
        }
        this.linkedBuffer = linkedBuffer;
    }

    public SharedDepthFramebuffer(int width, int height, int settings, Framebuffer linkedBuffer) {
        super(width, height, settings);
        if (linkedBuffer == null) {
            throw new IllegalArgumentException("linkedBuffer cannot be null!");
        }
        this.linkedBuffer = linkedBuffer;
    }

    public SharedDepthFramebuffer(int settings) {
        this(settings, Minecraft.func_71410_x().func_147110_a());
    }

    public SharedDepthFramebuffer(int width, int height, int settings) {
        this(width, height, settings, Minecraft.func_71410_x().func_147110_a());
    }

    @Override
    protected void createDepthAttachment(int width, int height) {
        this.depthAttachment = -1;
    }

    @Override
    protected final int createBufferBits() {
        return 16384;
    }

    private boolean isStencilEnabled() {
        return this.isEnabled(5) && SharedDepthFramebuffer.isMinecraftStencilEnabled();
    }

    @Override
    protected void deleteFramebuffer() {
        this.unbindFramebufferTexture();
        this.unbindFramebuffer();
        this.depthAttachment = -1;
        if (this.framebufferTexture > -1) {
            GL11.glDeleteTextures((int)this.framebufferTexture);
            this.framebufferTexture = -1;
        }
        GLCaps.FBO.glDeleteFramebuffers(this.framebufferObject);
        this.framebufferObject = -1;
    }

    @Override
    public void bindFramebuffer() {
        super.bindFramebuffer();
        if (this.linkedBuffer != null) {
            if (Mods.ANGELICA && this.linkedBuffer instanceof IRenderTargetExt) {
                int attachment = ((IRenderTargetExt)this.linkedBuffer).iris$getDepthTextureId();
                if (attachment != this.depthAttachment) {
                    this.depthAttachment = attachment;
                    this.linkDepthTexture(this.isStencilEnabled());
                }
            } else {
                int attachment = this.linkedBuffer.field_147624_h;
                if (attachment != this.depthAttachment) {
                    this.depthAttachment = attachment;
                    this.linkDepthRenderbuffer(this.isStencilEnabled());
                }
            }
        }
    }

    public static boolean isMinecraftStencilEnabled() {
        return MinecraftForgeClient.getStencilBits() != 0;
    }
}

