/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.renderer.cel.model.tri;

import com.gtnewhorizon.gtnhlib.client.renderer.CapturingTessellator;
import com.gtnewhorizon.gtnhlib.client.renderer.cel.api.util.NormI8;
import com.gtnewhorizon.gtnhlib.client.renderer.cel.model.primitive.ModelPrimitiveView;
import com.gtnewhorizon.gtnhlib.client.renderer.cel.util.ModelQuadUtil;

@Deprecated
public class ModelTriangle
implements ModelPrimitiveView {
    private final int[] data = new int[24];
    private int computedNormal;
    private int shaderBlockId = -1;

    @Override
    public int getVertexCount() {
        return 3;
    }

    @Override
    public float getX(int idx) {
        return Float.intBitsToFloat(this.data[ModelQuadUtil.vertexOffset(idx) + 0]);
    }

    @Override
    public float getY(int idx) {
        return Float.intBitsToFloat(this.data[ModelQuadUtil.vertexOffset(idx) + 0 + 1]);
    }

    @Override
    public float getZ(int idx) {
        return Float.intBitsToFloat(this.data[ModelQuadUtil.vertexOffset(idx) + 0 + 2]);
    }

    @Override
    public int getColor(int idx) {
        return this.data[ModelQuadUtil.vertexOffset(idx) + 5];
    }

    @Override
    public float getTexU(int idx) {
        return Float.intBitsToFloat(this.data[ModelQuadUtil.vertexOffset(idx) + 3]);
    }

    @Override
    public float getTexV(int idx) {
        return Float.intBitsToFloat(this.data[ModelQuadUtil.vertexOffset(idx) + 3 + 1]);
    }

    @Override
    public int getLight(int idx) {
        return this.data[ModelQuadUtil.vertexOffset(idx) + 7];
    }

    @Override
    public int getForgeNormal(int idx) {
        return this.data[ModelQuadUtil.vertexOffset(idx) + 6];
    }

    public void setX(int idx, float x) {
        this.data[ModelQuadUtil.vertexOffset((int)idx) + 0] = Float.floatToRawIntBits(x);
        this.computedNormal = 0;
    }

    public void setY(int idx, float y) {
        this.data[ModelQuadUtil.vertexOffset((int)idx) + 0 + 1] = Float.floatToRawIntBits(y);
        this.computedNormal = 0;
    }

    public void setZ(int idx, float z) {
        this.data[ModelQuadUtil.vertexOffset((int)idx) + 0 + 2] = Float.floatToRawIntBits(z);
        this.computedNormal = 0;
    }

    public void setColor(int idx, int color) {
        this.data[ModelQuadUtil.vertexOffset((int)idx) + 5] = color;
    }

    public void setTexU(int idx, float u) {
        this.data[ModelQuadUtil.vertexOffset((int)idx) + 3] = Float.floatToRawIntBits(u);
    }

    public void setTexV(int idx, float v) {
        this.data[ModelQuadUtil.vertexOffset((int)idx) + 3 + 1] = Float.floatToRawIntBits(v);
    }

    public void setLight(int idx, int light) {
        this.data[ModelQuadUtil.vertexOffset((int)idx) + 7] = light;
    }

    public void setForgeNormal(int idx, int normal) {
        this.data[ModelQuadUtil.vertexOffset((int)idx) + 6] = normal;
    }

    public void setState(int[] rawBuffer, int srcOffset, CapturingTessellator.Flags flags) {
        System.arraycopy(rawBuffer, srcOffset, this.data, 0, 24);
        if (!flags.hasColor) {
            this.clearColors();
        }
        if (!flags.hasNormals) {
            this.clearNormals();
        }
        if (!flags.hasBrightness) {
            this.clearLightmap();
        }
        this.computedNormal = 0;
    }

    public void copyVertexFromBuffer(int[] rawBuffer, int srcOffset, int destIdx) {
        System.arraycopy(rawBuffer, srcOffset, this.data, ModelQuadUtil.vertexOffset(destIdx), 8);
    }

    public int getComputedFaceNormal() {
        float nz;
        float dx1;
        float dx2;
        float ny;
        float dy2;
        float dz1;
        if (this.computedNormal != 0) {
            return this.computedNormal;
        }
        float x0 = this.getX(0);
        float y0 = this.getY(0);
        float z0 = this.getZ(0);
        float x1 = this.getX(1);
        float y1 = this.getY(1);
        float z1 = this.getZ(1);
        float x2 = this.getX(2);
        float y2 = this.getY(2);
        float dy1 = y1 - y0;
        float z2 = this.getZ(2);
        float dz2 = z2 - z0;
        float nx = dy1 * dz2 - (dz1 = z1 - z0) * (dy2 = y2 - y0);
        float len = (float)Math.sqrt(nx * nx + (ny = dz1 * (dx2 = x2 - x0) - (dx1 = x1 - x0) * dz2) * ny + (nz = dx1 * dy2 - dy1 * dx2) * nz);
        if (len != 0.0f) {
            nx /= len;
            ny /= len;
            nz /= len;
        }
        this.computedNormal = NormI8.pack(nx, ny, nz);
        return this.computedNormal;
    }

    private void clearColors() {
        this.setColor(0, -1);
        this.setColor(1, -1);
        this.setColor(2, -1);
    }

    private void clearNormals() {
        this.computedNormal = 0;
        this.data[ModelQuadUtil.vertexOffset((int)0) + 6] = 0;
        this.data[ModelQuadUtil.vertexOffset((int)1) + 6] = 0;
        this.data[ModelQuadUtil.vertexOffset((int)2) + 6] = 0;
    }

    private void clearLightmap() {
        this.setLight(0, 0xF000F0);
        this.setLight(1, 0xF000F0);
        this.setLight(2, 0xF000F0);
    }

    public int getShaderBlockId() {
        return this.shaderBlockId;
    }

    public void setShaderBlockId(int shaderBlockId) {
        this.shaderBlockId = shaderBlockId;
    }

    public void applyOffset(int offsetX, int offsetY, int offsetZ) {
        if (offsetX == 0 && offsetY == 0 && offsetZ == 0) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            int offset = ModelQuadUtil.vertexOffset(i);
            this.data[offset + 0] = Float.floatToRawIntBits(Float.intBitsToFloat(this.data[offset + 0]) + (float)offsetX);
            this.data[offset + 0 + 1] = Float.floatToRawIntBits(Float.intBitsToFloat(this.data[offset + 0 + 1]) + (float)offsetY);
            this.data[offset + 0 + 2] = Float.floatToRawIntBits(Float.intBitsToFloat(this.data[offset + 0 + 2]) + (float)offsetZ);
        }
        this.computedNormal = 0;
    }

    public ModelTriangle copyFrom(ModelTriangle source) {
        System.arraycopy(source.data, 0, this.data, 0, 24);
        this.computedNormal = source.computedNormal;
        this.shaderBlockId = source.shaderBlockId;
        return this;
    }
}

