/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.renderer.cel.model.quad.properties;

import com.gtnewhorizon.gtnhlib.client.renderer.cel.api.util.NormI8;
import java.util.Arrays;
import lombok.Generated;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.util.ForgeDirection;

public enum ModelQuadFacing {
    POS_X(1, 0, 0, Axis.X),
    POS_Y(0, 1, 0, Axis.Y),
    POS_Z(0, 0, 1, Axis.Z),
    NEG_X(-1, 0, 0, Axis.X),
    NEG_Y(0, -1, 0, Axis.Y),
    NEG_Z(0, 0, -1, Axis.Z),
    UNASSIGNED(0, 0, 0, null);

    public static final ModelQuadFacing[] VALUES;
    public static final ModelQuadFacing[] DIRECTIONS;
    public static final ModelQuadFacing[] HORIZONTAL_DIRECTIONS;
    public static final Axis[] AXES;
    public static final int COUNT;
    public static final int NONE = 0;
    public static final int ALL;
    private final int packedNormal;
    private final int stepX;
    private final int stepY;
    private final int stepZ;
    private final Axis axis;

    private ModelQuadFacing(int stepX, int stepY, int stepZ, Axis axis) {
        this.stepX = stepX;
        this.stepY = stepY;
        this.stepZ = stepZ;
        this.axis = axis;
        this.packedNormal = NormI8.pack(stepX, stepY, stepZ);
    }

    public ModelQuadFacing getOpposite() {
        ModelQuadFacing modelQuadFacing;
        switch (this) {
            case POS_Y: {
                modelQuadFacing = NEG_Y;
                break;
            }
            case NEG_Y: {
                modelQuadFacing = POS_Y;
                break;
            }
            case POS_X: {
                modelQuadFacing = NEG_X;
                break;
            }
            case NEG_X: {
                modelQuadFacing = POS_X;
                break;
            }
            case POS_Z: {
                modelQuadFacing = NEG_Z;
                break;
            }
            case NEG_Z: {
                modelQuadFacing = POS_Z;
                break;
            }
            default: {
                modelQuadFacing = UNASSIGNED;
            }
        }
        return modelQuadFacing;
    }

    public boolean isDirection() {
        return this != UNASSIGNED;
    }

    public static ModelQuadFacing fromForgeDir(ForgeDirection dir) {
        ModelQuadFacing modelQuadFacing;
        switch (dir) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case UP: {
                modelQuadFacing = POS_Y;
                break;
            }
            case DOWN: {
                modelQuadFacing = NEG_Y;
                break;
            }
            case EAST: {
                modelQuadFacing = POS_X;
                break;
            }
            case WEST: {
                modelQuadFacing = NEG_X;
                break;
            }
            case SOUTH: {
                modelQuadFacing = POS_Z;
                break;
            }
            case NORTH: {
                modelQuadFacing = NEG_Z;
                break;
            }
            case UNKNOWN: {
                modelQuadFacing = UNASSIGNED;
            }
        }
        return modelQuadFacing;
    }

    public static ModelQuadFacing fromEnumFacing(EnumFacing dir) {
        ModelQuadFacing modelQuadFacing;
        switch (dir) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case UP: {
                modelQuadFacing = POS_Y;
                break;
            }
            case DOWN: {
                modelQuadFacing = NEG_Y;
                break;
            }
            case WEST: {
                modelQuadFacing = POS_X;
                break;
            }
            case EAST: {
                modelQuadFacing = NEG_X;
                break;
            }
            case NORTH: {
                modelQuadFacing = NEG_Z;
                break;
            }
            case SOUTH: {
                modelQuadFacing = POS_Z;
            }
        }
        return modelQuadFacing;
    }

    public ForgeDirection toForgeDir() {
        ForgeDirection forgeDirection;
        switch (this) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case POS_Y: {
                forgeDirection = ForgeDirection.UP;
                break;
            }
            case NEG_Y: {
                forgeDirection = ForgeDirection.DOWN;
                break;
            }
            case POS_X: {
                forgeDirection = ForgeDirection.EAST;
                break;
            }
            case NEG_X: {
                forgeDirection = ForgeDirection.WEST;
                break;
            }
            case POS_Z: {
                forgeDirection = ForgeDirection.SOUTH;
                break;
            }
            case NEG_Z: {
                forgeDirection = ForgeDirection.NORTH;
                break;
            }
            case UNASSIGNED: {
                forgeDirection = ForgeDirection.UNKNOWN;
            }
        }
        return forgeDirection;
    }

    public EnumFacing toEnumFacing() {
        EnumFacing enumFacing;
        switch (this) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case POS_Y: {
                enumFacing = EnumFacing.UP;
                break;
            }
            case NEG_Y: {
                enumFacing = EnumFacing.DOWN;
                break;
            }
            case POS_X: {
                enumFacing = EnumFacing.WEST;
                break;
            }
            case NEG_X: {
                enumFacing = EnumFacing.EAST;
                break;
            }
            case POS_Z: {
                enumFacing = EnumFacing.SOUTH;
                break;
            }
            case NEG_Z: {
                enumFacing = EnumFacing.NORTH;
                break;
            }
            case UNASSIGNED: {
                throw new IllegalArgumentException("Cannot convert UNASSIGNED ModelQuadFacing to EnumFacing!");
            }
        }
        return enumFacing;
    }

    @Generated
    public int getPackedNormal() {
        return this.packedNormal;
    }

    @Generated
    public int getStepX() {
        return this.stepX;
    }

    @Generated
    public int getStepY() {
        return this.stepY;
    }

    @Generated
    public int getStepZ() {
        return this.stepZ;
    }

    @Generated
    public Axis getAxis() {
        return this.axis;
    }

    static {
        VALUES = ModelQuadFacing.values();
        DIRECTIONS = (ModelQuadFacing[])Arrays.stream(VALUES).filter(ModelQuadFacing::isDirection).toArray(ModelQuadFacing[]::new);
        HORIZONTAL_DIRECTIONS = (ModelQuadFacing[])Arrays.stream(DIRECTIONS).filter(facing -> facing.axis != Axis.Y).toArray(ModelQuadFacing[]::new);
        AXES = Axis.values();
        COUNT = VALUES.length;
        ALL = (1 << COUNT) - 1;
    }

    public static enum Axis {
        X,
        Y,
        Z;


        public ModelQuadFacing getFacing(boolean positive) {
            ModelQuadFacing modelQuadFacing;
            switch (this) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case X: {
                    if (positive) {
                        modelQuadFacing = POS_X;
                        break;
                    }
                    modelQuadFacing = NEG_X;
                    break;
                }
                case Y: {
                    if (positive) {
                        modelQuadFacing = POS_Y;
                        break;
                    }
                    modelQuadFacing = NEG_Y;
                    break;
                }
                case Z: {
                    modelQuadFacing = positive ? POS_Z : NEG_Z;
                }
            }
            return modelQuadFacing;
        }
    }
}

