/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.renderer;

import com.gtnewhorizon.gtnhlib.client.renderer.CapturingTessellator;
import com.gtnewhorizon.gtnhlib.client.renderer.cel.model.line.ModelLine;
import com.gtnewhorizon.gtnhlib.client.renderer.cel.model.primitive.ModelPrimitiveView;
import com.gtnewhorizon.gtnhlib.client.renderer.cel.model.quad.ModelQuad;
import com.gtnewhorizon.gtnhlib.client.renderer.cel.model.tri.ModelTriangle;
import com.gtnewhorizon.gtnhlib.util.ObjectPooler;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Deprecated
public final class PrimitiveExtractor {
    private static final Logger LOGGER = LogManager.getLogger((String)"PrimitiveExtractor");

    private PrimitiveExtractor() {
    }

    public static void buildPrimitivesFromBuffer(int[] rawBuffer, int vertexCount, int drawMode, boolean hasTexture, boolean hasBrightness, boolean hasColor, boolean hasNormals, int offsetX, int offsetY, int offsetZ, int shaderBlockId, ObjectPooler<ModelQuad> quadPool, ObjectPooler<ModelTriangle> triPool, ObjectPooler<ModelLine> linePool, List<ModelPrimitiveView> collectedPrimitives, CapturingTessellator.Flags flags) {
        PrimitiveExtractor.buildPrimitivesFromBuffer(rawBuffer, vertexCount, drawMode, hasTexture, hasBrightness, hasColor, hasNormals, offsetX, offsetY, offsetZ, shaderBlockId, quadPool, triPool, linePool, collectedPrimitives, flags, false);
    }

    public static void buildPrimitivesFromBuffer(int[] rawBuffer, int vertexCount, int drawMode, boolean hasTexture, boolean hasBrightness, boolean hasColor, boolean hasNormals, int offsetX, int offsetY, int offsetZ, int shaderBlockId, ObjectPooler<ModelQuad> quadPool, ObjectPooler<ModelTriangle> triPool, ObjectPooler<ModelLine> linePool, List<ModelPrimitiveView> collectedPrimitives, CapturingTessellator.Flags flags, boolean convertQuadsToTriangles) {
        flags.copyFrom(hasTexture, hasBrightness, hasColor, hasNormals, drawMode);
        switch (drawMode) {
            case 7: {
                if (convertQuadsToTriangles) {
                    PrimitiveExtractor.extractQuadsAsTriangles(rawBuffer, vertexCount, offsetX, offsetY, offsetZ, shaderBlockId, triPool, collectedPrimitives, flags);
                    flags.drawMode = 4;
                    break;
                }
                PrimitiveExtractor.extractQuads(rawBuffer, vertexCount, offsetX, offsetY, offsetZ, shaderBlockId, quadPool, collectedPrimitives, flags);
                break;
            }
            case 4: {
                PrimitiveExtractor.extractTriangles(rawBuffer, vertexCount, offsetX, offsetY, offsetZ, shaderBlockId, triPool, collectedPrimitives, flags);
                break;
            }
            case 1: {
                PrimitiveExtractor.extractLines(rawBuffer, vertexCount, offsetX, offsetY, offsetZ, shaderBlockId, linePool, collectedPrimitives);
                break;
            }
            case 3: {
                PrimitiveExtractor.extractLineStrip(rawBuffer, vertexCount, offsetX, offsetY, offsetZ, shaderBlockId, linePool, collectedPrimitives);
                flags.drawMode = 1;
                break;
            }
            case 2: {
                PrimitiveExtractor.extractLineLoop(rawBuffer, vertexCount, offsetX, offsetY, offsetZ, shaderBlockId, linePool, collectedPrimitives);
                flags.drawMode = 1;
                break;
            }
            case 5: {
                PrimitiveExtractor.extractTriangleStrip(rawBuffer, vertexCount, offsetX, offsetY, offsetZ, shaderBlockId, triPool, collectedPrimitives, flags);
                flags.drawMode = 4;
                break;
            }
            case 6: {
                PrimitiveExtractor.extractTriangleFan(rawBuffer, vertexCount, offsetX, offsetY, offsetZ, shaderBlockId, triPool, collectedPrimitives, flags);
                flags.drawMode = 4;
                break;
            }
            default: {
                LOGGER.warn("Unsupported draw mode: 0x{} ({} vertices) - primitives will not be captured", new Object[]{Integer.toHexString(drawMode), vertexCount});
            }
        }
    }

    private static void extractQuads(int[] rawBuffer, int vertexCount, int offsetX, int offsetY, int offsetZ, int shaderBlockId, ObjectPooler<ModelQuad> quadPool, List<ModelPrimitiveView> collected, CapturingTessellator.Flags flags) {
        int numQuads = vertexCount / 4;
        for (int i = 0; i < numQuads; ++i) {
            int srcOffset = i * 4 * 8;
            if (PrimitiveExtractor.isEmptyPrimitive(rawBuffer, srcOffset, 4)) continue;
            ModelQuad quad = quadPool.getInstance();
            quad.setState(rawBuffer, srcOffset, flags, 7, offsetX, offsetY, offsetZ);
            quad.setShaderBlockId(shaderBlockId);
            collected.add(quad);
        }
    }

    private static void extractQuadsAsTriangles(int[] rawBuffer, int vertexCount, int offsetX, int offsetY, int offsetZ, int shaderBlockId, ObjectPooler<ModelTriangle> triPool, List<ModelPrimitiveView> collected, CapturingTessellator.Flags flags) {
        int numQuads = vertexCount / 4;
        for (int i = 0; i < numQuads; ++i) {
            int srcOffset = i * 4 * 8;
            if (PrimitiveExtractor.isEmptyPrimitive(rawBuffer, srcOffset, 4)) continue;
            ModelTriangle tri1 = triPool.getInstance();
            PrimitiveExtractor.copyVertexToTriangle(rawBuffer, srcOffset + 0, tri1, 0);
            PrimitiveExtractor.copyVertexToTriangle(rawBuffer, srcOffset + 8, tri1, 1);
            PrimitiveExtractor.copyVertexToTriangle(rawBuffer, srcOffset + 16, tri1, 2);
            if (!flags.hasColor) {
                PrimitiveExtractor.setDefaultTriangleColors(tri1);
            }
            tri1.setShaderBlockId(shaderBlockId);
            tri1.applyOffset(offsetX, offsetY, offsetZ);
            collected.add(tri1);
            ModelTriangle tri2 = triPool.getInstance();
            PrimitiveExtractor.copyVertexToTriangle(rawBuffer, srcOffset + 0, tri2, 0);
            PrimitiveExtractor.copyVertexToTriangle(rawBuffer, srcOffset + 16, tri2, 1);
            PrimitiveExtractor.copyVertexToTriangle(rawBuffer, srcOffset + 24, tri2, 2);
            if (!flags.hasColor) {
                PrimitiveExtractor.setDefaultTriangleColors(tri2);
            }
            tri2.setShaderBlockId(shaderBlockId);
            tri2.applyOffset(offsetX, offsetY, offsetZ);
            collected.add(tri2);
        }
    }

    private static void extractTriangles(int[] rawBuffer, int vertexCount, int offsetX, int offsetY, int offsetZ, int shaderBlockId, ObjectPooler<ModelTriangle> triPool, List<ModelPrimitiveView> collected, CapturingTessellator.Flags flags) {
        int numTris = vertexCount / 3;
        for (int i = 0; i < numTris; ++i) {
            int srcOffset = i * 3 * 8;
            if (PrimitiveExtractor.isEmptyPrimitive(rawBuffer, srcOffset, 3)) continue;
            ModelTriangle tri = triPool.getInstance();
            tri.setState(rawBuffer, srcOffset, flags);
            tri.setShaderBlockId(shaderBlockId);
            tri.applyOffset(offsetX, offsetY, offsetZ);
            collected.add(tri);
        }
    }

    private static void extractTriangleStrip(int[] rawBuffer, int vertexCount, int offsetX, int offsetY, int offsetZ, int shaderBlockId, ObjectPooler<ModelTriangle> triPool, List<ModelPrimitiveView> collected, CapturingTessellator.Flags flags) {
        if (vertexCount < 3) {
            return;
        }
        for (int i = 0; i < vertexCount - 2; ++i) {
            int v2;
            int v1;
            int v0;
            ModelTriangle tri = triPool.getInstance();
            if ((i & 1) == 0) {
                v0 = i;
                v1 = i + 1;
                v2 = i + 2;
            } else {
                v0 = i + 1;
                v1 = i;
                v2 = i + 2;
            }
            PrimitiveExtractor.copyVertexToTriangle(rawBuffer, v0 * 8, tri, 0);
            PrimitiveExtractor.copyVertexToTriangle(rawBuffer, v1 * 8, tri, 1);
            PrimitiveExtractor.copyVertexToTriangle(rawBuffer, v2 * 8, tri, 2);
            if (!flags.hasColor) {
                PrimitiveExtractor.setDefaultTriangleColors(tri);
            }
            tri.setShaderBlockId(shaderBlockId);
            tri.applyOffset(offsetX, offsetY, offsetZ);
            collected.add(tri);
        }
    }

    private static void extractTriangleFan(int[] rawBuffer, int vertexCount, int offsetX, int offsetY, int offsetZ, int shaderBlockId, ObjectPooler<ModelTriangle> triPool, List<ModelPrimitiveView> collected, CapturingTessellator.Flags flags) {
        if (vertexCount < 3) {
            return;
        }
        for (int i = 0; i < vertexCount - 2; ++i) {
            ModelTriangle tri = triPool.getInstance();
            PrimitiveExtractor.copyVertexToTriangle(rawBuffer, 0, tri, 0);
            PrimitiveExtractor.copyVertexToTriangle(rawBuffer, (i + 1) * 8, tri, 1);
            PrimitiveExtractor.copyVertexToTriangle(rawBuffer, (i + 2) * 8, tri, 2);
            if (!flags.hasColor) {
                PrimitiveExtractor.setDefaultTriangleColors(tri);
            }
            tri.setShaderBlockId(shaderBlockId);
            tri.applyOffset(offsetX, offsetY, offsetZ);
            collected.add(tri);
        }
    }

    private static void extractLines(int[] rawBuffer, int vertexCount, int offsetX, int offsetY, int offsetZ, int shaderBlockId, ObjectPooler<ModelLine> linePool, List<ModelPrimitiveView> collected) {
        int numLines = vertexCount / 2;
        for (int i = 0; i < numLines; ++i) {
            int srcOffset = i * 2 * 8;
            if (PrimitiveExtractor.isEmptyPrimitive(rawBuffer, srcOffset, 2)) continue;
            ModelLine line = linePool.getInstance();
            line.setState(rawBuffer, srcOffset);
            line.setShaderBlockId(shaderBlockId);
            line.applyOffset(offsetX, offsetY, offsetZ);
            collected.add(line);
        }
    }

    private static void extractLineStrip(int[] rawBuffer, int vertexCount, int offsetX, int offsetY, int offsetZ, int shaderBlockId, ObjectPooler<ModelLine> linePool, List<ModelPrimitiveView> collected) {
        if (vertexCount < 2) {
            return;
        }
        for (int i = 0; i < vertexCount - 1; ++i) {
            ModelLine line = linePool.getInstance();
            PrimitiveExtractor.copyVertexToLine(rawBuffer, i * 8, line, 0);
            PrimitiveExtractor.copyVertexToLine(rawBuffer, (i + 1) * 8, line, 1);
            line.setShaderBlockId(shaderBlockId);
            line.applyOffset(offsetX, offsetY, offsetZ);
            collected.add(line);
        }
    }

    private static void extractLineLoop(int[] rawBuffer, int vertexCount, int offsetX, int offsetY, int offsetZ, int shaderBlockId, ObjectPooler<ModelLine> linePool, List<ModelPrimitiveView> collected) {
        if (vertexCount < 2) {
            return;
        }
        for (int i = 0; i < vertexCount - 1; ++i) {
            ModelLine line = linePool.getInstance();
            PrimitiveExtractor.copyVertexToLine(rawBuffer, i * 8, line, 0);
            PrimitiveExtractor.copyVertexToLine(rawBuffer, (i + 1) * 8, line, 1);
            line.setShaderBlockId(shaderBlockId);
            line.applyOffset(offsetX, offsetY, offsetZ);
            collected.add(line);
        }
        ModelLine closingLine = linePool.getInstance();
        PrimitiveExtractor.copyVertexToLine(rawBuffer, (vertexCount - 1) * 8, closingLine, 0);
        PrimitiveExtractor.copyVertexToLine(rawBuffer, 0, closingLine, 1);
        closingLine.setShaderBlockId(shaderBlockId);
        closingLine.applyOffset(offsetX, offsetY, offsetZ);
        collected.add(closingLine);
    }

    private static void copyVertexToTriangle(int[] rawBuffer, int srcOffset, ModelTriangle tri, int destIdx) {
        tri.copyVertexFromBuffer(rawBuffer, srcOffset, destIdx);
    }

    private static void copyVertexToLine(int[] rawBuffer, int srcOffset, ModelLine line, int destIdx) {
        line.copyVertexFromBuffer(rawBuffer, srcOffset, destIdx);
    }

    private static void setDefaultTriangleColors(ModelTriangle tri) {
        tri.setColor(0, -1);
        tri.setColor(1, -1);
        tri.setColor(2, -1);
    }

    static boolean isEmptyPrimitive(int[] rawBuffer, int srcOffset, int vertexCount) {
        int requiredSize = srcOffset + (vertexCount - 1) * 8 + 3;
        if (requiredSize > rawBuffer.length) {
            return true;
        }
        for (int axis = 0; axis < 3; ++axis) {
            int firstVal = rawBuffer[srcOffset + axis];
            for (int v = 1; v < vertexCount; ++v) {
                if (firstVal == rawBuffer[srcOffset + v * 8 + axis]) continue;
                return false;
            }
        }
        return true;
    }
}

