/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.renderer;

import com.google.common.annotations.Beta;
import com.gtnewhorizon.gtnhlib.bytebuf.MemoryUtilities;
import com.gtnewhorizon.gtnhlib.client.renderer.CallbackTessellator;
import com.gtnewhorizon.gtnhlib.client.renderer.DirectDrawCallback;
import com.gtnewhorizon.gtnhlib.client.renderer.TessellatorManager;
import com.gtnewhorizon.gtnhlib.client.renderer.vao.IVertexArrayObject;
import com.gtnewhorizon.gtnhlib.client.renderer.vao.IndexBuffer;
import com.gtnewhorizon.gtnhlib.client.renderer.vao.VertexBufferType;
import com.gtnewhorizon.gtnhlib.client.renderer.vbo.IVertexBuffer;
import com.gtnewhorizon.gtnhlib.client.renderer.vertex.VertexFlags;
import com.gtnewhorizon.gtnhlib.client.renderer.vertex.VertexFormat;
import com.gtnewhorizon.gtnhlib.client.renderer.vertex.VertexOptimizer;
import java.nio.ByteBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.shader.TesselatorVertexState;

public class DirectTessellator
extends Tessellator {
    protected VertexFormat format;
    protected VertexFormat preDefinedFormat;
    protected final ByteBuffer baseBuffer;
    protected final long baseAddress;
    protected final boolean deleteAfter;
    protected long startPtr;
    protected long writePtr;
    protected long endPtr;

    public DirectTessellator(ByteBuffer initial) {
        this(initial, false);
    }

    public DirectTessellator(int capacity) {
        this(MemoryUtilities.memAlloc(capacity), true);
    }

    public DirectTessellator(ByteBuffer initial, boolean deleteAfter) {
        this.baseBuffer = initial;
        this.writePtr = this.startPtr = (this.baseAddress = MemoryUtilities.memAddress0(initial));
        this.endPtr = this.startPtr + (long)initial.capacity();
        this.deleteAfter = deleteAfter;
    }

    public int func_78381_a() {
        this.field_78415_z = false;
        return this.field_78406_i * 32;
    }

    protected int interceptDraw(Tessellator tessellator) {
        this.field_78406_i = tessellator.field_78406_i;
        this.field_78399_n = tessellator.field_78399_n;
        this.field_78400_o = tessellator.field_78400_o;
        this.field_78414_p = tessellator.field_78414_p;
        this.field_78413_q = tessellator.field_78413_q;
        this.field_78410_t = tessellator.field_78410_t;
        this.field_78409_u = tessellator.field_78409_u;
        this.format = this.preDefinedFormat != null ? this.preDefinedFormat : this.getOptimalVertexFormat();
        this.ensureCapacity(tessellator.field_147569_p);
        this.writePtr = this.format.writeToBuffer0(this.writePtr, tessellator.field_78405_h, tessellator.field_147569_p);
        return this.func_78381_a();
    }

    public void func_78379_d() {
        this.field_78406_i = 0;
        this.field_78415_z = false;
        this.field_78413_q = false;
        this.field_78399_n = false;
        this.field_78400_o = false;
        this.field_78414_p = false;
        this.field_78410_t = false;
        this.format = null;
        this.preDefinedFormat = null;
        if (this.isResized()) {
            MemoryUtilities.nmemFree(this.startPtr);
            this.startPtr = this.baseAddress;
            this.endPtr = this.startPtr + (long)this.baseBuffer.capacity();
        }
        this.writePtr = this.startPtr;
    }

    public final void func_78371_b(int p_78371_1_) {
        if (this.field_78415_z) {
            throw new IllegalStateException("Already tesselating!");
        }
        this.field_78415_z = true;
        this.field_78409_u = p_78371_1_;
    }

    private void ensureCapacity(int bytes) {
        if (this.bufferRemaining() >= bytes) {
            return;
        }
        long used = this.bufferLimit();
        int newCapacity = this.bufferCapacity() * 2;
        long required = used + (long)bytes;
        while ((long)newCapacity < required) {
            newCapacity *= 2;
        }
        if (!this.isResized()) {
            long newPtr = MemoryUtilities.nmemAllocChecked(newCapacity);
            MemoryUtilities.memCopy(this.startPtr, newPtr, used);
            this.startPtr = newPtr;
        } else {
            this.startPtr = MemoryUtilities.nmemReallocChecked(this.startPtr, newCapacity);
        }
        this.writePtr = this.startPtr + used;
        this.endPtr = this.startPtr + (long)newCapacity;
    }

    public void func_78377_a(double x, double y, double z) {
        if (this.format == null) {
            this.format = this.getOptimalVertexFormat();
        }
        this.ensureCapacity(this.format.getVertexSize());
        this.writePtr = this.format.writeToBuffer0(this.writePtr, this, (float)(x + this.field_78408_v), (float)(y + this.field_78407_w), (float)(z + this.field_78417_x));
        ++this.field_78406_i;
    }

    public final void func_78385_a(double p_78385_1_, double p_78385_3_) {
        if (!this.field_78400_o) {
            if (this.preDefinedFormat != null) {
                return;
            }
            this.field_78400_o = true;
            if (this.format != null) {
                this.fixBufferFormat();
            }
        }
        this.field_78403_j = p_78385_1_;
        this.field_78404_k = p_78385_3_;
    }

    public final void func_78375_b(float nx, float ny, float nz) {
        if (!this.field_78413_q) {
            if (this.preDefinedFormat != null) {
                return;
            }
            this.field_78413_q = true;
            if (this.format != null) {
                this.fixBufferFormat();
            }
        }
        byte b0 = (byte)(nx * 127.0f);
        byte b1 = (byte)(ny * 127.0f);
        byte b2 = (byte)(nz * 127.0f);
        this.field_78416_y = b0 & 0xFF | (b1 & 0xFF) << 8 | (b2 & 0xFF) << 16;
    }

    public final void func_78370_a(int red, int green, int blue, int alpha) {
        if (this.field_78410_t) {
            return;
        }
        if (!this.field_78399_n) {
            if (this.preDefinedFormat != null) {
                return;
            }
            this.field_78399_n = true;
            if (this.format != null) {
                this.fixBufferFormat();
            }
        }
        if (red > 255) {
            red = 255;
        } else if (red < 0) {
            red = 0;
        }
        if (green > 255) {
            green = 255;
        } else if (green < 0) {
            green = 0;
        }
        if (blue > 255) {
            blue = 255;
        } else if (blue < 0) {
            blue = 0;
        }
        if (alpha > 255) {
            alpha = 255;
        } else if (alpha < 0) {
            alpha = 0;
        }
        this.field_78402_m = alpha << 24 | blue << 16 | green << 8 | red;
    }

    public final void func_78380_c(int p_78380_1_) {
        if (!this.field_78414_p) {
            if (this.preDefinedFormat != null) {
                return;
            }
            this.field_78414_p = true;
            if (this.format != null) {
                this.fixBufferFormat();
            }
        }
        this.field_78401_l = p_78380_1_;
    }

    public final IVertexArrayObject uploadToVBO(VertexBufferType bufferType) {
        if (this.field_78409_u == 7) {
            return VertexOptimizer.optimizeQuads(bufferType, this.format, this.field_78406_i, this.getWriteBuffer());
        }
        return bufferType.allocate(this.format, this.field_78409_u, this.getWriteBuffer(), this.field_78406_i);
    }

    public final void updateToVBO(IVertexBuffer vbo) {
        vbo.update(this.getWriteBuffer());
    }

    public final void allocateToVBO(IVertexBuffer vbo) {
        vbo.allocate(this.getWriteBuffer(), this.field_78406_i);
    }

    @Beta
    public final void allocateToVBO(IVertexArrayObject vao, IndexBuffer ebo) {
        vao.getVBO().allocate(this.getWriteBuffer(), this.field_78406_i / 4 * 6);
        ebo.upload(this.field_78406_i);
    }

    protected ByteBuffer getWriteBuffer() {
        ByteBuffer buffer = this.isResized() ? MemoryUtilities.memByteBuffer(this.startPtr, this.bufferCapacity()) : this.baseBuffer;
        buffer.limit(this.bufferLimit());
        return buffer;
    }

    public final ByteBuffer allocateBufferCopy() {
        int size = this.bufferLimit();
        ByteBuffer copy = MemoryUtilities.memAlloc(size);
        MemoryUtilities.memCopy(this.startPtr, MemoryUtilities.memAddress0(copy), size);
        return copy;
    }

    protected final void fixBufferFormat() {
        VertexFormat oldFormat = this.format;
        VertexFormat newFormat = this.getOptimalVertexFormat();
        int vertexCount = this.field_78406_i;
        int newBufferSize = vertexCount * newFormat.getVertexSize();
        ByteBuffer temp = MemoryUtilities.memAlloc(newBufferSize);
        long tempPtr = MemoryUtilities.memAddress0(temp);
        long readPtr = this.startPtr;
        long writePtrTemp = tempPtr;
        for (int i = 0; i < vertexCount; ++i) {
            float x = MemoryUtilities.memGetFloat(readPtr);
            float y = MemoryUtilities.memGetFloat(readPtr + 4L);
            float z = MemoryUtilities.memGetFloat(readPtr + 8L);
            readPtr += 12L;
            readPtr = oldFormat.readFromBuffer0(readPtr, this);
            writePtrTemp = newFormat.writeToBuffer0(writePtrTemp, this, x, y, z);
        }
        this.ensureCapacity(newBufferSize);
        MemoryUtilities.memCopy(tempPtr, this.startPtr, newBufferSize);
        this.writePtr = this.startPtr + (long)newBufferSize;
        MemoryUtilities.memFree(temp);
        this.format = newFormat;
    }

    private VertexFormat getOptimalVertexFormat() {
        return VertexFlags.getFormat(this);
    }

    public final void setVertexFormat(VertexFormat format) {
        if (this.format != null) {
            throw new IllegalStateException("Cannot call setVertexFormat() after a vertex has already been emitted!");
        }
        this.preDefinedFormat = format;
        this.format = format;
        this.field_78400_o = format.hasTexture();
        this.field_78413_q = format.hasNormals();
        this.field_78414_p = format.hasBrightness();
        this.field_78399_n = format.hasColor();
    }

    protected final int bufferCapacity() {
        return (int)(this.endPtr - this.startPtr);
    }

    protected final int bufferLimit() {
        return (int)(this.writePtr - this.startPtr);
    }

    protected final int bufferRemaining() {
        return (int)(this.endPtr - this.writePtr);
    }

    protected final boolean isResized() {
        return this.startPtr != this.baseAddress;
    }

    public final int getVertexCount() {
        return this.field_78406_i;
    }

    public final boolean isEmpty() {
        return this.startPtr == this.writePtr;
    }

    public final VertexFormat getVertexFormat() {
        return this.format;
    }

    public final double getLastTextureU() {
        return this.field_78403_j;
    }

    public final double getLastTextureV() {
        return this.field_78404_k;
    }

    public final int getPackedNormal() {
        return this.field_78416_y;
    }

    public final int getPackedColor() {
        return this.field_78402_m;
    }

    public final int getDrawMode() {
        return this.field_78409_u;
    }

    public final TesselatorVertexState func_147564_a(float p_147564_1_, float p_147564_2_, float p_147564_3_) {
        throw new UnsupportedOperationException("getVertexState not supported for DirectTessellator!");
    }

    public final void func_147565_a(TesselatorVertexState p_147565_1_) {
        throw new UnsupportedOperationException("setVertexState not supported for DirectTessellator!");
    }

    protected void onRemovedFromStack() {
        this.func_78379_d();
        if (this.deleteAfter) {
            this.delete();
        }
    }

    public void delete() {
        this.func_78379_d();
        MemoryUtilities.nmemFree(this.baseAddress);
    }

    public static DirectTessellator startCapturing() {
        return TessellatorManager.startCapturingDirect();
    }

    public static DirectTessellator startCapturing(int capacity) {
        return TessellatorManager.startCapturingDirect(capacity);
    }

    public static void startCapturing(DirectTessellator tessellator) {
        TessellatorManager.startCapturingDirect(tessellator);
    }

    public static DirectTessellator startCapturing(VertexFormat format) {
        return TessellatorManager.startCapturingDirect(format);
    }

    @Beta
    public static CallbackTessellator startCapturing(DirectDrawCallback callback) {
        return TessellatorManager.startCapturingDirect(callback);
    }

    public static void stopCapturing() {
        TessellatorManager.stopCapturingDirect();
    }

    public static IVertexArrayObject stopCapturingToVBO(VertexBufferType bufferType) {
        return TessellatorManager.stopCapturingDirectToVBO(bufferType);
    }
}

