/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.opengl;

import com.gtnewhorizon.gtnhlib.client.renderer.vao.VaoFunctions;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.IntBuffer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL11;

public final class VaoAppleLwjgl3Fallback
implements VaoFunctions {
    private static final Logger LOGGER = LogManager.getLogger((String)"VaoAppleLwjgl3Fallback");
    private final long glGenVertexArraysAPPLE;
    private final long glDeleteVertexArraysAPPLE;
    private final long glBindVertexArrayAPPLE;
    private final long glIsVertexArrayAPPLE;

    private VaoAppleLwjgl3Fallback(long genAddr, long deleteAddr, long bindAddr, long isArrayAddr) {
        this.glGenVertexArraysAPPLE = genAddr;
        this.glDeleteVertexArraysAPPLE = deleteAddr;
        this.glBindVertexArrayAPPLE = bindAddr;
        this.glIsVertexArrayAPPLE = isArrayAddr;
    }

    public static VaoFunctions tryCreate() {
        if (!Lwjgl3Handles.INITIALIZED) {
            return null;
        }
        try {
            long genAddr = Lwjgl3Handles.getFunctionAddress("glGenVertexArraysAPPLE");
            long deleteAddr = Lwjgl3Handles.getFunctionAddress("glDeleteVertexArraysAPPLE");
            long bindAddr = Lwjgl3Handles.getFunctionAddress("glBindVertexArrayAPPLE");
            long isArrayAddr = Lwjgl3Handles.getFunctionAddress("glIsVertexArrayAPPLE");
            if (genAddr == 0L || deleteAddr == 0L || bindAddr == 0L) {
                return null;
            }
            LOGGER.info("Using LWJGL3 Apple VAO fallback");
            return new VaoAppleLwjgl3Fallback(genAddr, deleteAddr, bindAddr, isArrayAddr);
        }
        catch (Throwable e) {
            LOGGER.debug("Failed to probe Apple VAO functions", e);
            return null;
        }
    }

    @Override
    public int getCurrentBinding() {
        return GL11.glGetInteger((int)34229);
    }

    @Override
    public int glGenVertexArrays() {
        StackFrame stack = new StackFrame();
        try {
            IntBuffer buf = stack.callocInt(1);
            long addr = Lwjgl3Handles.memAddress(buf);
            Lwjgl3Handles.JNI_CALL_PV.invokeExact(1, addr, this.glGenVertexArraysAPPLE);
            int n = buf.get(0);
            stack.close();
            return n;
        }
        catch (Throwable throwable) {
            try {
                try {
                    stack.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable e) {
                throw new RuntimeException("Failed to call glGenVertexArraysAPPLE", e);
            }
        }
    }

    @Override
    public void glGenVertexArrays(IntBuffer output) {
        try {
            long addr = Lwjgl3Handles.memAddress(output);
            Lwjgl3Handles.JNI_CALL_PV.invokeExact(output.remaining(), addr, this.glGenVertexArraysAPPLE);
        }
        catch (Throwable e) {
            throw new RuntimeException("Failed to call glGenVertexArraysAPPLE", e);
        }
    }

    @Override
    public void glDeleteVertexArrays(int id) {
        try (StackFrame stack = new StackFrame();){
            IntBuffer buf = stack.ints(id);
            long addr = Lwjgl3Handles.memAddress(buf);
            Lwjgl3Handles.JNI_CALL_PV.invokeExact(1, addr, this.glDeleteVertexArraysAPPLE);
        }
        catch (Throwable e) {
            throw new RuntimeException("Failed to call glDeleteVertexArraysAPPLE", e);
        }
    }

    @Override
    public void glDeleteVertexArrays(IntBuffer ids) {
        try {
            long addr = Lwjgl3Handles.memAddress(ids);
            Lwjgl3Handles.JNI_CALL_PV.invokeExact(ids.remaining(), addr, this.glDeleteVertexArraysAPPLE);
        }
        catch (Throwable e) {
            throw new RuntimeException("Failed to call glDeleteVertexArraysAPPLE", e);
        }
    }

    @Override
    public boolean glIsVertexArray(int id) {
        if (this.glIsVertexArrayAPPLE == 0L) {
            return false;
        }
        try {
            return Lwjgl3Handles.JNI_CALL_Z.invokeExact(id, this.glIsVertexArrayAPPLE);
        }
        catch (Throwable e) {
            throw new RuntimeException("Failed to call glIsVertexArrayAPPLE", e);
        }
    }

    @Override
    public void glBindVertexArray(int id) {
        try {
            Lwjgl3Handles.JNI_CALL_V.invokeExact(id, this.glBindVertexArrayAPPLE);
        }
        catch (Throwable e) {
            throw new RuntimeException("Failed to call glBindVertexArrayAPPLE", e);
        }
    }

    private static final class Lwjgl3Handles {
        static final MethodHandle STACK_PUSH;
        static final MethodHandle STACK_CALLOC_INT;
        static final MethodHandle STACK_INTS;
        static final MethodHandle STACK_CLOSE;
        static final MethodHandle MEM_ADDRESS;
        static final MethodHandle JNI_CALL_PV;
        static final MethodHandle JNI_CALL_V;
        static final MethodHandle JNI_CALL_Z;
        static final MethodHandle GET_FUNCTION_ADDRESS;
        static final boolean INITIALIZED;

        private Lwjgl3Handles() {
        }

        static long memAddress(IntBuffer buf) throws Throwable {
            return MEM_ADDRESS.invokeExact(buf);
        }

        static long getFunctionAddress(String name) throws Throwable {
            return GET_FUNCTION_ADDRESS.invoke(name);
        }

        static {
            boolean success = false;
            MethodHandle stackPush = null;
            MethodHandle stackCallocInt = null;
            MethodHandle stackInts = null;
            MethodHandle stackClose = null;
            MethodHandle memAddress = null;
            MethodHandle jniCallPV = null;
            MethodHandle jniCallV = null;
            MethodHandle jniCallZ = null;
            MethodHandle getFunctionAddress = null;
            try {
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                Class<?> memoryStackClass = Class.forName("org.lwjgl.system.MemoryStack");
                Class<?> memoryUtilClass = Class.forName("org.lwjgl.system.MemoryUtil");
                Class<?> jniClass = Class.forName("org.lwjgl.system.JNI");
                stackPush = lookup.findStatic(memoryStackClass, "stackPush", MethodType.methodType(memoryStackClass));
                stackCallocInt = lookup.findVirtual(memoryStackClass, "callocInt", MethodType.methodType(IntBuffer.class, Integer.TYPE));
                stackInts = lookup.findVirtual(memoryStackClass, "ints", MethodType.methodType(IntBuffer.class, Integer.TYPE));
                stackClose = lookup.findVirtual(memoryStackClass, "close", MethodType.methodType(Void.TYPE));
                memAddress = lookup.findStatic(memoryUtilClass, "memAddress", MethodType.methodType(Long.TYPE, Buffer.class));
                jniCallPV = lookup.findStatic(jniClass, "callPV", MethodType.methodType(Void.TYPE, Integer.TYPE, Long.TYPE, Long.TYPE));
                jniCallV = lookup.findStatic(jniClass, "callV", MethodType.methodType(Void.TYPE, Integer.TYPE, Long.TYPE));
                jniCallZ = lookup.findStatic(jniClass, "callZ", MethodType.methodType(Boolean.TYPE, Integer.TYPE, Long.TYPE));
                Class<?> glClass = Class.forName("org.lwjgl.opengl.GL");
                Method getFunctionProviderMethod = glClass.getMethod("getFunctionProvider", new Class[0]);
                Object provider = getFunctionProviderMethod.invoke(null, new Object[0]);
                if (provider != null) {
                    Method getFunctionAddressMethod = provider.getClass().getMethod("getFunctionAddress", CharSequence.class);
                    getFunctionAddress = lookup.unreflect(getFunctionAddressMethod).bindTo(provider);
                }
                success = provider != null;
            }
            catch (Exception e) {
                LOGGER.debug("LWJGL3 handles not available: {}", new Object[]{e.toString()});
            }
            STACK_PUSH = stackPush;
            STACK_CALLOC_INT = stackCallocInt;
            STACK_INTS = stackInts;
            STACK_CLOSE = stackClose;
            MEM_ADDRESS = memAddress;
            JNI_CALL_PV = jniCallPV;
            JNI_CALL_V = jniCallV;
            JNI_CALL_Z = jniCallZ;
            GET_FUNCTION_ADDRESS = getFunctionAddress;
            INITIALIZED = success;
        }
    }

    private static final class StackFrame
    implements AutoCloseable {
        private final Object stack = Lwjgl3Handles.STACK_PUSH.invoke();

        StackFrame() throws Throwable {
        }

        IntBuffer callocInt(int size) throws Throwable {
            return Lwjgl3Handles.STACK_CALLOC_INT.invoke(this.stack, size);
        }

        IntBuffer ints(int value) throws Throwable {
            return Lwjgl3Handles.STACK_INTS.invoke(this.stack, value);
        }

        @Override
        public void close() {
            try {
                Lwjgl3Handles.STACK_CLOSE.invoke(this.stack);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

