/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.opengl;

import com.gtnewhorizon.gtnhlib.client.opengl.VaoAppleLwjgl3Fallback;
import com.gtnewhorizon.gtnhlib.client.renderer.vao.VaoFunctions;
import java.nio.IntBuffer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.APPLEVertexArrayObject;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GLContext;

public final class UniversalVAO {
    private static final Logger LOGGER = LogManager.getLogger((String)"UniversalVAO");
    private static final ThreadLocal<VaoFunctions> FUNCTIONS = ThreadLocal.withInitial(() -> UniversalVAO.getImplementation(GLContext.getCapabilities()));

    public static VaoFunctions getImplementation(ContextCapabilities caps) {
        if (caps.OpenGL30) {
            return new VaoGL3();
        }
        if (caps.GL_APPLE_vertex_array_object) {
            return new VaoApple();
        }
        if (caps.GL_ARB_vertex_array_object) {
            return new VaoGL3();
        }
        VaoFunctions appleLwjgl3Fallback = VaoAppleLwjgl3Fallback.tryCreate();
        if (appleLwjgl3Fallback != null) {
            return appleLwjgl3Fallback;
        }
        LOGGER.warn("No VAO implementation available");
        return null;
    }

    public static void reinitializeGlContext() {
        FUNCTIONS.remove();
    }

    public static int getVertexArrayBinding() {
        return FUNCTIONS.get().getCurrentBinding();
    }

    public static int genVertexArrays() {
        return FUNCTIONS.get().glGenVertexArrays();
    }

    public static void genVertexArrays(IntBuffer output) {
        FUNCTIONS.get().glGenVertexArrays(output);
    }

    public static void deleteVertexArrays(int id) {
        FUNCTIONS.get().glDeleteVertexArrays(id);
    }

    public static void deleteVertexArrays(IntBuffer ids) {
        FUNCTIONS.get().glDeleteVertexArrays(ids);
    }

    public static boolean isVertexArray(int array) {
        return FUNCTIONS.get().glIsVertexArray(array);
    }

    public static void bindVertexArray(int id) {
        FUNCTIONS.get().glBindVertexArray(id);
    }

    private static final class VaoGL3
    implements VaoFunctions {
        private VaoGL3() {
        }

        @Override
        public int getCurrentBinding() {
            return GL11.glGetInteger((int)34229);
        }

        @Override
        public int glGenVertexArrays() {
            return GL30.glGenVertexArrays();
        }

        @Override
        public void glGenVertexArrays(IntBuffer output) {
            GL30.glGenVertexArrays((IntBuffer)output);
        }

        @Override
        public void glDeleteVertexArrays(int id) {
            GL30.glDeleteVertexArrays((int)id);
        }

        @Override
        public void glDeleteVertexArrays(IntBuffer ids) {
            GL30.glDeleteVertexArrays((IntBuffer)ids);
        }

        @Override
        public boolean glIsVertexArray(int id) {
            return GL30.glIsVertexArray((int)id);
        }

        @Override
        public void glBindVertexArray(int id) {
            GL30.glBindVertexArray((int)id);
        }
    }

    private static final class VaoApple
    implements VaoFunctions {
        private VaoApple() {
        }

        @Override
        public int getCurrentBinding() {
            return GL11.glGetInteger((int)34229);
        }

        @Override
        public int glGenVertexArrays() {
            return APPLEVertexArrayObject.glGenVertexArraysAPPLE();
        }

        @Override
        public void glGenVertexArrays(IntBuffer output) {
            APPLEVertexArrayObject.glGenVertexArraysAPPLE((IntBuffer)output);
        }

        @Override
        public void glDeleteVertexArrays(int id) {
            APPLEVertexArrayObject.glDeleteVertexArraysAPPLE((int)id);
        }

        @Override
        public void glDeleteVertexArrays(IntBuffer ids) {
            APPLEVertexArrayObject.glDeleteVertexArraysAPPLE((IntBuffer)ids);
        }

        @Override
        public boolean glIsVertexArray(int id) {
            return APPLEVertexArrayObject.glIsVertexArrayAPPLE((int)id);
        }

        @Override
        public void glBindVertexArray(int id) {
            APPLEVertexArrayObject.glBindVertexArrayAPPLE((int)id);
        }
    }
}

