/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.opengl;

import com.gtnewhorizon.gtnhlib.client.opengl.FBOFunctions;
import com.gtnewhorizon.gtnhlib.client.opengl.UniversalVAO;
import com.gtnewhorizon.gtnhlib.client.renderer.vao.VaoFunctions;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.EXTFramebufferObject;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GLContext;

public final class GLCaps {
    private static final boolean bufferStorage;
    private static final boolean texStorage;
    public static final FBOFunctions FBO;
    public static final VaoFunctions VAO;

    public static boolean bufferStorageSupported() {
        return bufferStorage;
    }

    public static boolean texStorageSupported() {
        return texStorage;
    }

    public static boolean fboSupported() {
        return FBO != null;
    }

    static {
        ContextCapabilities caps = GLContext.getCapabilities();
        bufferStorage = caps.OpenGL44 || caps.GL_ARB_buffer_storage;
        boolean bl = texStorage = caps.OpenGL42 || caps.GL_ARB_texture_storage;
        FBO = caps.OpenGL30 || caps.GL_ARB_framebuffer_object ? new FBOGL3() : (caps.GL_EXT_framebuffer_object ? new FBOEXT() : null);
        VAO = UniversalVAO.getImplementation(caps);
    }

    private static final class FBOGL3
    implements FBOFunctions {
        private FBOGL3() {
        }

        @Override
        public void glBindFramebuffer(int target, int framebuffer) {
            GL30.glBindFramebuffer((int)target, (int)framebuffer);
        }

        @Override
        public void glBindRenderbuffer(int target, int renderbuffer) {
            GL30.glBindRenderbuffer((int)target, (int)renderbuffer);
        }

        @Override
        public void glDeleteRenderbuffers(int renderbuffer) {
            GL30.glDeleteRenderbuffers((int)renderbuffer);
        }

        @Override
        public void glDeleteFramebuffers(int framebuffer) {
            GL30.glDeleteFramebuffers((int)framebuffer);
        }

        @Override
        public int glGenFramebuffers() {
            return GL30.glGenFramebuffers();
        }

        @Override
        public int glGenRenderbuffers() {
            return GL30.glGenRenderbuffers();
        }

        @Override
        public void glRenderbufferStorage(int target, int internalformat, int width, int height) {
            GL30.glRenderbufferStorage((int)target, (int)internalformat, (int)width, (int)height);
        }

        @Override
        public void glFramebufferRenderbuffer(int target, int attachment, int renderbuffertarget, int renderbuffer) {
            GL30.glFramebufferRenderbuffer((int)target, (int)attachment, (int)renderbuffertarget, (int)renderbuffer);
        }

        @Override
        public int glCheckFramebufferStatus(int target) {
            return GL30.glCheckFramebufferStatus((int)target);
        }

        @Override
        public void glFramebufferTexture2D(int target, int attachment, int textarget, int texture, int level) {
            GL30.glFramebufferTexture2D((int)target, (int)attachment, (int)textarget, (int)texture, (int)level);
        }
    }

    private static final class FBOEXT
    implements FBOFunctions {
        private FBOEXT() {
        }

        @Override
        public void glBindFramebuffer(int target, int framebuffer) {
            EXTFramebufferObject.glBindFramebufferEXT((int)target, (int)framebuffer);
        }

        @Override
        public void glBindRenderbuffer(int target, int renderbuffer) {
            EXTFramebufferObject.glBindRenderbufferEXT((int)target, (int)renderbuffer);
        }

        @Override
        public void glDeleteRenderbuffers(int renderbuffer) {
            EXTFramebufferObject.glDeleteRenderbuffersEXT((int)renderbuffer);
        }

        @Override
        public void glDeleteFramebuffers(int framebuffer) {
            EXTFramebufferObject.glDeleteFramebuffersEXT((int)framebuffer);
        }

        @Override
        public int glGenFramebuffers() {
            return EXTFramebufferObject.glGenFramebuffersEXT();
        }

        @Override
        public int glGenRenderbuffers() {
            return EXTFramebufferObject.glGenRenderbuffersEXT();
        }

        @Override
        public void glRenderbufferStorage(int target, int internalformat, int width, int height) {
            EXTFramebufferObject.glRenderbufferStorageEXT((int)target, (int)internalformat, (int)width, (int)height);
        }

        @Override
        public void glFramebufferRenderbuffer(int target, int attachment, int renderbuffertarget, int renderbuffer) {
            EXTFramebufferObject.glFramebufferRenderbufferEXT((int)target, (int)attachment, (int)renderbuffertarget, (int)renderbuffer);
        }

        @Override
        public int glCheckFramebufferStatus(int target) {
            return EXTFramebufferObject.glCheckFramebufferStatusEXT((int)target);
        }

        @Override
        public void glFramebufferTexture2D(int target, int attachment, int textarget, int texture, int level) {
            EXTFramebufferObject.glFramebufferTexture2DEXT((int)target, (int)attachment, (int)textarget, (int)texture, (int)level);
        }
    }
}

