/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.model.unbaked;

import com.google.common.base.Objects;
import com.gtnewhorizon.gtnhlib.client.model.BakeData;
import com.gtnewhorizon.gtnhlib.client.model.baked.BakedModel;
import com.gtnewhorizon.gtnhlib.client.model.baked.PileOfQuads;
import com.gtnewhorizon.gtnhlib.client.model.loading.ModelDeserializer;
import com.gtnewhorizon.gtnhlib.client.model.loading.ModelRegistry;
import com.gtnewhorizon.gtnhlib.client.model.loading.ResourceLoc;
import com.gtnewhorizon.gtnhlib.client.model.unbaked.UnbakedModel;
import com.gtnewhorizon.gtnhlib.client.renderer.cel.model.quad.ModelQuad;
import com.gtnewhorizon.gtnhlib.client.renderer.cel.model.quad.ModelQuadView;
import com.gtnewhorizon.gtnhlib.client.renderer.cel.model.quad.ModelQuadViewMutable;
import com.gtnewhorizon.gtnhlib.client.renderer.cel.model.quad.properties.ModelQuadFacing;
import com.gtnewhorizon.gtnhlib.client.renderer.cel.util.MathUtil;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import org.joml.Matrix2f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class JSONModel
implements UnbakedModel {
    @Nullable
    private final ResourceLoc.ModelLoc parentId;
    @Nullable
    private JSONModel parent;
    private final boolean useAO;
    private final Map<ModelDeserializer.Position, ModelDeserializer.Position.ModelDisplay> display;
    @NotNull
    private final Object2ObjectMap<String, String> textures;
    private List<ModelDeserializer.ModelElement> elements;
    protected static final Vector4f DEFAULT_UV = new Vector4f(0.0f, 0.0f, 16.0f, 16.0f);

    public JSONModel(@Nullable ResourceLoc.ModelLoc parentId, boolean useAO, Map<ModelDeserializer.Position, ModelDeserializer.Position.ModelDisplay> display, @NotNull Object2ObjectMap<String, String> textures, List<ModelDeserializer.ModelElement> elements) {
        this.parentId = parentId;
        this.useAO = useAO;
        this.display = display;
        this.textures = textures;
        this.elements = elements;
    }

    public JSONModel(JSONModel og) {
        this.parentId = og.parentId;
        this.parent = og.parent;
        this.useAO = og.useAO;
        this.display = og.display;
        this.textures = og.textures;
        this.elements = og.elements;
    }

    protected static void setUV(ModelQuadViewMutable q, int i, float u, float v) {
        q.setTexU(i, u);
        q.setTexV(i, v);
    }

    @NotNull
    protected static Vector3f mapSideToVertex(Vector3f from, Vector3f to, int index, ForgeDirection side) {
        Vector3f vector3f;
        block0 : switch (side) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case DOWN: {
                switch (index) {
                    case 0: {
                        vector3f = new Vector3f(from.x, from.y, to.z);
                        break block0;
                    }
                    case 1: {
                        vector3f = new Vector3f(from.x, from.y, from.z);
                        break block0;
                    }
                    case 2: {
                        vector3f = new Vector3f(to.x, from.y, from.z);
                        break block0;
                    }
                    case 3: {
                        vector3f = new Vector3f(to.x, from.y, to.z);
                        break block0;
                    }
                }
                throw new RuntimeException("Too many indices!");
            }
            case UP: {
                switch (index) {
                    case 0: {
                        vector3f = new Vector3f(from.x, to.y, from.z);
                        break block0;
                    }
                    case 1: {
                        vector3f = new Vector3f(from.x, to.y, to.z);
                        break block0;
                    }
                    case 2: {
                        vector3f = new Vector3f(to.x, to.y, to.z);
                        break block0;
                    }
                    case 3: {
                        vector3f = new Vector3f(to.x, to.y, from.z);
                        break block0;
                    }
                }
                throw new RuntimeException("Too many indices!");
            }
            case NORTH: {
                switch (index) {
                    case 0: {
                        vector3f = new Vector3f(to.x, to.y, from.z);
                        break block0;
                    }
                    case 1: {
                        vector3f = new Vector3f(to.x, from.y, from.z);
                        break block0;
                    }
                    case 2: {
                        vector3f = new Vector3f(from.x, from.y, from.z);
                        break block0;
                    }
                    case 3: {
                        vector3f = new Vector3f(from.x, to.y, from.z);
                        break block0;
                    }
                }
                throw new RuntimeException("Too many indices!");
            }
            case SOUTH: {
                switch (index) {
                    case 0: {
                        vector3f = new Vector3f(from.x, to.y, to.z);
                        break block0;
                    }
                    case 1: {
                        vector3f = new Vector3f(from.x, from.y, to.z);
                        break block0;
                    }
                    case 2: {
                        vector3f = new Vector3f(to.x, from.y, to.z);
                        break block0;
                    }
                    case 3: {
                        vector3f = new Vector3f(to.x, to.y, to.z);
                        break block0;
                    }
                }
                throw new RuntimeException("Too many indices!");
            }
            case WEST: {
                switch (index) {
                    case 0: {
                        vector3f = new Vector3f(from.x, to.y, from.z);
                        break block0;
                    }
                    case 1: {
                        vector3f = new Vector3f(from.x, from.y, from.z);
                        break block0;
                    }
                    case 2: {
                        vector3f = new Vector3f(from.x, from.y, to.z);
                        break block0;
                    }
                    case 3: {
                        vector3f = new Vector3f(from.x, to.y, to.z);
                        break block0;
                    }
                }
                throw new RuntimeException("Too many indices!");
            }
            case EAST: {
                switch (index) {
                    case 0: {
                        vector3f = new Vector3f(to.x, to.y, to.z);
                        break block0;
                    }
                    case 1: {
                        vector3f = new Vector3f(to.x, from.y, to.z);
                        break block0;
                    }
                    case 2: {
                        vector3f = new Vector3f(to.x, from.y, from.z);
                        break block0;
                    }
                    case 3: {
                        vector3f = new Vector3f(to.x, to.y, from.z);
                        break block0;
                    }
                }
                throw new RuntimeException("Too many indices!");
            }
            case UNKNOWN: {
                throw new IllegalArgumentException("No vector matching UNKNOWN!");
            }
        }
        return vector3f;
    }

    @Override
    public BakedModel bake(BakeData data) {
        Matrix4fc vRot = data.getAffineMatrix();
        HashMap<ModelQuadFacing, ArrayList<ModelQuadView>> sidedQuadStore = new HashMap<ModelQuadFacing, ArrayList<ModelQuadView>>(7);
        for (ModelDeserializer.ModelElement e : this.elements) {
            Matrix4f rot = e.rotation() == null ? ModelDeserializer.ModelElement.Rotation.NOOP.getAffineMatrix() : e.rotation().getAffineMatrix();
            Vector3f from = e.from();
            Vector3f to = e.to();
            for (ModelDeserializer.ModelElement.Face f : e.faces()) {
                float x = Float.MAX_VALUE;
                float y = Float.MAX_VALUE;
                float z = Float.MAX_VALUE;
                float X = Float.MIN_VALUE;
                float Y = Float.MIN_VALUE;
                float Z = Float.MIN_VALUE;
                ModelQuad quad = new ModelQuad();
                for (int i = 0; i < 4; ++i) {
                    Vector3f vert = JSONModel.mapSideToVertex(from, to, i, f.name()).mulPosition(rot).mulPosition(vRot);
                    quad.setX(i, vert.x);
                    quad.setY(i, vert.y);
                    quad.setZ(i, vert.z);
                    x = java.lang.Math.min(x, vert.x);
                    y = java.lang.Math.min(y, vert.y);
                    z = java.lang.Math.min(z, vert.z);
                    X = java.lang.Math.max(X, vert.x);
                    Y = java.lang.Math.max(Y, vert.y);
                    Z = java.lang.Math.max(Z, vert.z);
                }
                quad.setEmissiveness(e.lightEmission());
                quad.setDirectionalShading(e.shade());
                quad.setHasAmbientOcclusion(this.useAO);
                quad.setLightFace(ModelQuadFacing.fromForgeDir(f.name()));
                Vector4f uv = (Vector4f)Objects.firstNonNull((Object)f.uv(), (Object)DEFAULT_UV);
                Vector2f[] uvs = new Vector2f[]{new Vector2f(uv.x, uv.y), new Vector2f(uv.x, uv.w), new Vector2f(uv.z, uv.w), new Vector2f(uv.z, uv.y)};
                if (data.uvLock()) {
                    ModelQuadFacing normFace = quad.getNormalFace();
                    int angle = 0;
                    if (normFace == ModelQuadFacing.POS_Y) {
                        angle = 360 - data.y();
                    }
                    if (normFace == ModelQuadFacing.NEG_Y) {
                        angle = data.y();
                    }
                    Matrix2f matrixRot = new Matrix2f();
                    matrixRot.rotate((float)java.lang.Math.toRadians(angle));
                    for (int i = 0; i < 4; ++i) {
                        uvs[i].sub(8.0f, 8.0f);
                        uvs[i].mul(matrixRot);
                        uvs[i].add(8.0f, 8.0f);
                    }
                }
                for (int i = 0; i < 4; ++i) {
                    JSONModel.setUV(quad, i, uvs[i].x, uvs[i].y);
                }
                String texKey = f.texture();
                String texName = (String)this.textures.get(texKey);
                if (texName.startsWith("#")) {
                    ModelRegistry.MODEL_LOGGER.warn("Model {} has unflattened texture variable {} when baking!", new Object[]{this, texName});
                    this.textures.put(texKey, "minecraft:missing");
                    texName = "minecraft:missing";
                }
                this.bakeSprite(quad, texName);
                quad.setColorIndex(f.tintIndex());
                ModelQuadFacing cullFace = ModelQuadFacing.fromForgeDir(f.cullFace());
                if (cullFace.isDirection()) {
                    Vector3f facing = new Vector3f(cullFace.getStepX(), cullFace.getStepY(), cullFace.getStepZ()).mulDirection(vRot);
                    if (MathUtil.roughlyEqual(facing.x, 1.0f)) {
                        cullFace = ModelQuadFacing.POS_X;
                    }
                    if (MathUtil.roughlyEqual(facing.x, -1.0f)) {
                        cullFace = ModelQuadFacing.NEG_X;
                    }
                    if (MathUtil.roughlyEqual(facing.y, 1.0f)) {
                        cullFace = ModelQuadFacing.POS_Y;
                    }
                    if (MathUtil.roughlyEqual(facing.y, -1.0f)) {
                        cullFace = ModelQuadFacing.NEG_Y;
                    }
                    if (MathUtil.roughlyEqual(facing.z, 1.0f)) {
                        cullFace = ModelQuadFacing.POS_Z;
                    }
                    if (MathUtil.roughlyEqual(facing.z, -1.0f)) {
                        cullFace = ModelQuadFacing.NEG_Z;
                    }
                }
                sidedQuadStore.computeIfAbsent(cullFace, d -> new ArrayList()).add(quad);
            }
        }
        return new PileOfQuads(sidedQuadStore, this.display, this.getParticle());
    }

    protected void bakeSprite(ModelQuadViewMutable quad, String name) {
        name = name.replaceFirst("^minecraft:", "");
        TextureAtlasSprite icon = Minecraft.func_71410_x().func_147117_R().func_110572_b(name);
        float minU = icon.func_94209_e();
        float minV = icon.func_94206_g();
        float dU = icon.func_94212_f() - minU;
        float dV = icon.func_94210_h() - minV;
        quad.setSprite(icon);
        for (int i = 0; i < 4; ++i) {
            quad.setTexU(i, Math.fma(dU, quad.getTexU(i) / 16.0f, minU));
            quad.setTexV(i, Math.fma(dV, quad.getTexV(i) / 16.0f, minV));
        }
    }

    public void resolveParents(Function<ResourceLoc.ModelLoc, JSONModel> modelLoader) {
        if (this.parentId == null || this.parent != null) {
            return;
        }
        JSONModel p = modelLoader.apply(this.parentId);
        p.resolveParents(modelLoader);
        this.parent = p;
        if (this.elements.isEmpty()) {
            this.elements = this.parent.elements;
        }
        for (Map.Entry e : this.parent.textures.entrySet()) {
            this.textures.putIfAbsent((String)e.getKey(), (String)e.getValue());
        }
        boolean flat = false;
        Object2ObjectOpenHashMap<String, String> tmp = new Object2ObjectOpenHashMap<String, String>();
        while (!flat) {
            flat = true;
            for (Map.Entry e : this.textures.entrySet()) {
                if (this.textures.containsKey(e.getValue())) {
                    if (!((String)e.getKey()).equals(e.getValue())) {
                        tmp.put((String)e.getKey(), (String)this.textures.get(e.getValue()));
                    } else {
                        tmp.put((String)e.getKey(), "");
                    }
                    flat = false;
                    continue;
                }
                tmp.put((String)e.getKey(), (String)e.getValue());
            }
            this.textures.putAll(tmp);
        }
    }

    private IIcon getParticle() {
        String key = "particle";
        if (!this.textures.containsKey(key) && !this.textures.isEmpty()) {
            key = (String)this.textures.keySet().iterator().next();
        }
        String texName = this.textures.getOrDefault(key, "missingno");
        texName = texName.replaceFirst("^minecraft:", "");
        return Minecraft.func_71410_x().func_147117_R().func_110572_b(texName);
    }

    public Map<String, String> getTextures() {
        return Object2ObjectMaps.unmodifiable(this.textures);
    }
}

