/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.model.loading;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.gtnewhorizon.gtnhlib.client.model.loading.ResourceLoc;
import com.gtnewhorizon.gtnhlib.client.model.unbaked.JSONModel;
import com.gtnewhorizon.gtnhlib.client.renderer.cel.model.quad.properties.ModelQuadFacing;
import com.gtnewhorizon.gtnhlib.util.JsonUtil;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class ModelDeserializer
implements JsonDeserializer<JSONModel> {
    private static Pattern TEXEX = Pattern.compile("^([^:]+:)block/");

    private static ForgeDirection fromName(String name) {
        ForgeDirection forgeDirection;
        switch (name) {
            case "up": {
                forgeDirection = ForgeDirection.UP;
                break;
            }
            case "down": {
                forgeDirection = ForgeDirection.DOWN;
                break;
            }
            case "north": {
                forgeDirection = ForgeDirection.NORTH;
                break;
            }
            case "south": {
                forgeDirection = ForgeDirection.SOUTH;
                break;
            }
            case "west": {
                forgeDirection = ForgeDirection.WEST;
                break;
            }
            case "east": {
                forgeDirection = ForgeDirection.EAST;
                break;
            }
            case "unknown": {
                forgeDirection = ForgeDirection.UNKNOWN;
                break;
            }
            default: {
                forgeDirection = null;
            }
        }
        return forgeDirection;
    }

    private static Vector3f loadVec3(JsonObject in, String name) {
        JsonArray arr = in.getAsJsonArray(name);
        Vector3f ret = new Vector3f();
        for (int i = 0; i < 3; ++i) {
            ret.setComponent(i, arr.get(i).getAsFloat());
        }
        return ret;
    }

    private static Vector3f loadVec3(JsonObject in, String name, Vector3f defaultv) {
        if (!in.isJsonObject() || !in.has(name)) {
            return defaultv;
        }
        return ModelDeserializer.loadVec3(in, name);
    }

    private static Vector4f loadVec4(JsonObject in, String name) {
        JsonArray arr = in.getAsJsonArray(name);
        Vector4f ret = new Vector4f();
        for (int i = 0; i < 4; ++i) {
            ret.setComponent(i, arr.get(i).getAsFloat());
        }
        return ret;
    }

    private static Position.ModelDisplay loadADisplay(JsonObject in) {
        Vector3f rotation = ModelDeserializer.loadVec3(in, "rotation", new Vector3f(0.0f, 0.0f, 0.0f));
        Vector3f translation = ModelDeserializer.loadVec3(in, "translation", new Vector3f(0.0f, 0.0f, 0.0f));
        Vector3f scale = ModelDeserializer.loadVec3(in, "scale", new Vector3f(1.0f, 1.0f, 1.0f));
        return new Position.ModelDisplay(rotation, translation, scale);
    }

    private static Map<Position, Position.ModelDisplay> loadDisplay(JsonObject in) {
        Object2ObjectOpenHashMap<Position, Position.ModelDisplay> ret = new Object2ObjectOpenHashMap<Position, Position.ModelDisplay>(Position.values().length);
        if (in.has("display")) {
            JsonObject display = in.getAsJsonObject("display");
            for (Map.Entry j : display.entrySet()) {
                String name = (String)j.getKey();
                Position pos = Position.getByName(name);
                ret.put(pos, ModelDeserializer.loadADisplay(((JsonElement)j.getValue()).getAsJsonObject()));
            }
        }
        for (Position p : Position.values()) {
            ret.putIfAbsent(p, Position.ModelDisplay.DEFAULT);
        }
        return ret;
    }

    private static Object2ObjectOpenHashMap<String, String> loadTextures(JsonObject in) {
        Object2ObjectOpenHashMap<String, String> textures = new Object2ObjectOpenHashMap<String, String>();
        if (in.has("textures")) {
            for (Map.Entry e : in.getAsJsonObject("textures").entrySet()) {
                String key;
                String s = ((JsonElement)e.getValue()).getAsString();
                if (!s.startsWith("#")) {
                    if (!s.contains(":")) {
                        s = "minecraft:" + s;
                    }
                    s = TEXEX.matcher(s).replaceFirst("$1");
                }
                textures.put((key = (String)e.getKey()).startsWith("#") ? key : "#" + key, s);
            }
        }
        return textures;
    }

    private static ModelElement.Rotation loadRotation(JsonObject in) {
        if (in.has("rotation")) {
            ModelQuadFacing.Axis axis;
            String sAxis;
            JsonObject json = in.getAsJsonObject("rotation");
            Vector3f origin = ModelDeserializer.loadVec3(json, "origin").div(16.0f);
            switch (sAxis = JsonUtil.loadStr(json, "axis")) {
                case "x": {
                    axis = ModelQuadFacing.Axis.X;
                    break;
                }
                case "y": {
                    axis = ModelQuadFacing.Axis.Y;
                    break;
                }
                case "z": {
                    axis = ModelQuadFacing.Axis.Z;
                    break;
                }
                default: {
                    throw new JsonParseException("Invalid axis " + sAxis);
                }
            }
            ModelQuadFacing.Axis axis2 = axis;
            float angle = JsonUtil.loadFloat(json, "angle");
            boolean rescale = JsonUtil.loadBool(json, "rescale", false);
            return new ModelElement.Rotation(origin, axis2, angle, rescale);
        }
        return null;
    }

    private static List<ModelElement.Face> loadFaces(JsonObject in) {
        ObjectArrayList<ModelElement.Face> ret = new ObjectArrayList<ModelElement.Face>();
        JsonObject json = in.getAsJsonObject("faces");
        for (Map.Entry e : json.entrySet()) {
            ForgeDirection side = ModelDeserializer.fromName((String)e.getKey());
            JsonObject face = ((JsonElement)e.getValue()).getAsJsonObject();
            Vector4f uv = face.has("uv") ? ModelDeserializer.loadVec4(face, "uv") : null;
            String texture = JsonUtil.loadStr(face, "texture");
            ForgeDirection cullFace = ModelDeserializer.fromName(JsonUtil.loadStr(face, "cullface", "unknown"));
            int rotation = JsonUtil.loadInt(face, "rotation", 0);
            int tintIndex = JsonUtil.loadInt(face, "tintindex", -1);
            ret.add(new ModelElement.Face(side, uv, texture, cullFace, rotation, tintIndex));
        }
        return ret;
    }

    private static List<ModelElement> loadElements(JsonObject in) {
        ObjectArrayList<ModelElement> ret = new ObjectArrayList<ModelElement>();
        if (in.has("elements")) {
            JsonArray arr = in.getAsJsonArray("elements");
            for (JsonElement e : arr) {
                JsonObject json = e.getAsJsonObject();
                Vector3f from = ModelDeserializer.loadVec3(json, "from").div(16.0f);
                Vector3f to = ModelDeserializer.loadVec3(json, "to").div(16.0f);
                ModelElement.Rotation rotation = ModelDeserializer.loadRotation(json);
                boolean shade = JsonUtil.loadBool(json, "shade", true);
                int lightEmission = JsonUtil.loadInt(json, "light_emission", 0);
                List<ModelElement.Face> faces = ModelDeserializer.loadFaces(json);
                ret.add(new ModelElement(from, to, rotation, shade, lightEmission, faces));
            }
        }
        return ret;
    }

    public JSONModel deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject in = json.getAsJsonObject();
        String parent = JsonUtil.loadStr(in, "parent", null);
        ResourceLoc.ModelLoc parentId = null;
        if (parent != null && !parent.isEmpty()) {
            parentId = parent.contains(":") ? new ResourceLoc.ModelLoc(parent.split(":")[0], parent.split(":")[1]) : new ResourceLoc.ModelLoc("minecraft", parent);
        }
        boolean useAO = JsonUtil.loadBool(in, "ambientocclusion", true);
        Map<Position, Position.ModelDisplay> display = ModelDeserializer.loadDisplay(in);
        Object2ObjectOpenHashMap<String, String> textures = ModelDeserializer.loadTextures(in);
        List<ModelElement> elements = ModelDeserializer.loadElements(in);
        return new JSONModel(parentId, useAO, display, textures, elements);
    }

    public static enum Position {
        THIRDPERSON_RIGHTHAND,
        THIRDPERSON_LEFTHAND,
        FIRSTPERSON_RIGHTHAND,
        FIRSTPERSON_LEFTHAND,
        GUI,
        HEAD,
        GROUND,
        FIXED;


        public static Position getByName(String name) {
            Position position;
            switch (name) {
                case "thirdperson_righthand": {
                    position = THIRDPERSON_RIGHTHAND;
                    break;
                }
                case "thirdperson_lefthand": {
                    position = THIRDPERSON_LEFTHAND;
                    break;
                }
                case "firstperson_righthand": {
                    position = FIRSTPERSON_RIGHTHAND;
                    break;
                }
                case "firstperson_lefthand": {
                    position = FIRSTPERSON_LEFTHAND;
                    break;
                }
                case "gui": {
                    position = GUI;
                    break;
                }
                case "head": {
                    position = HEAD;
                    break;
                }
                case "ground": {
                    position = GROUND;
                    break;
                }
                case "fixed": {
                    position = FIXED;
                    break;
                }
                default: {
                    position = null;
                }
            }
            return position;
        }

        public static final class ModelDisplay {
            public static final ModelDisplay DEFAULT = new ModelDisplay(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(1.0f, 1.0f, 1.0f));
            private final Vector3f rotation;
            private final Vector3f translation;
            private final Vector3f scale;

            public ModelDisplay(Vector3f rotation, Vector3f translation, Vector3f scale) {
                this.rotation = rotation;
                this.translation = translation;
                this.scale = scale;
            }

            public Vector3f rotation() {
                return this.rotation;
            }

            public Vector3f translation() {
                return this.translation;
            }

            public Vector3f scale() {
                return this.scale;
            }
        }
    }

    public static final class ModelElement {
        private final Vector3f from;
        private final Vector3f to;
        @Nullable
        private final Rotation rotation;
        private final boolean shade;
        private final int lightEmission;
        private final List<Face> faces;

        public ModelElement(Vector3f from, Vector3f to, @Nullable Rotation rotation, boolean shade, int lightEmission, List<Face> faces) {
            this.from = from;
            this.to = to;
            this.rotation = rotation;
            this.shade = shade;
            this.lightEmission = lightEmission;
            this.faces = faces;
        }

        public Vector3f from() {
            return this.from;
        }

        public Vector3f to() {
            return this.to;
        }

        @Nullable
        public Rotation rotation() {
            return this.rotation;
        }

        public boolean shade() {
            return this.shade;
        }

        public int lightEmission() {
            return this.lightEmission;
        }

        public List<Face> faces() {
            return this.faces;
        }

        public static final class Rotation {
            public static final Rotation NOOP = new Rotation(new Vector3f(0.0f, 0.0f, 0.0f), ModelQuadFacing.Axis.X, 0.0f, false);
            private final Vector3f origin;
            private final ModelQuadFacing.Axis axis;
            private final float angle;
            private final boolean rescale;

            public Rotation(Vector3f origin, ModelQuadFacing.Axis axis, float angle, boolean rescale) {
                this.origin = origin;
                this.axis = axis;
                this.angle = (float)Math.toRadians(angle);
                this.rescale = rescale;
            }

            public Matrix4f getAffineMatrix() {
                Matrix4f ret = new Matrix4f().translation(-this.origin.x, -this.origin.y, -this.origin.z);
                switch (this.axis) {
                    case X: {
                        ret.rotateLocalX(this.angle);
                        break;
                    }
                    case Y: {
                        ret.rotateLocalY(this.angle);
                        break;
                    }
                    case Z: {
                        ret.rotateLocalZ(this.angle);
                    }
                }
                return ret.translateLocal(this.origin.x, this.origin.y, this.origin.z);
            }

            public Vector3f origin() {
                return this.origin;
            }

            public ModelQuadFacing.Axis axis() {
                return this.axis;
            }

            public float angle() {
                return this.angle;
            }

            public boolean rescale() {
                return this.rescale;
            }
        }

        public static final class Face {
            private final ForgeDirection name;
            private final Vector4f uv;
            private final String texture;
            private final ForgeDirection cullFace;
            private final int rotation;
            private final int tintIndex;

            public Face(ForgeDirection name, Vector4f uv, String texture, ForgeDirection cullFace, int rotation, int tintIndex) {
                this.name = name;
                this.uv = uv;
                this.texture = texture;
                this.cullFace = cullFace;
                this.rotation = rotation;
                this.tintIndex = tintIndex;
            }

            public ForgeDirection name() {
                return this.name;
            }

            public Vector4f uv() {
                return this.uv;
            }

            public String texture() {
                return this.texture;
            }

            public ForgeDirection cullFace() {
                return this.cullFace;
            }

            public int rotation() {
                return this.rotation;
            }

            public int tintIndex() {
                return this.tintIndex;
            }
        }
    }
}

