/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.model;

import com.gtnewhorizon.gtnhlib.client.model.BakeData;
import com.gtnewhorizon.gtnhlib.client.model.Weighted;
import com.gtnewhorizon.gtnhlib.client.model.loading.ResourceLoc;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

@ApiStatus.Internal
public final class JSONVariant
implements BakeData {
    private static final float DEG2RAD = (float)Math.PI / 180;
    private final ResourceLoc.ModelLoc model;
    private final int x;
    private final int y;
    private final boolean uvLock;

    public static Weighted<JSONVariant> weightedVariant(ResourceLoc.ModelLoc model, int x, int y, boolean uvLock, int weight) {
        JSONVariant v = new JSONVariant(model, x, y, uvLock);
        return new Weighted<JSONVariant>(v, weight);
    }

    public JSONVariant(ResourceLoc.ModelLoc model, int x, int y, boolean uvLock) {
        this.model = model;
        this.x = x;
        this.y = y;
        this.uvLock = uvLock;
    }

    @Override
    public Matrix4fc getAffineMatrix() {
        return new Matrix4f().translation(-0.5f, -0.5f, -0.5f).rotateLocalX((float)this.x * ((float)Math.PI / 180)).rotateLocalY((float)this.y * ((float)Math.PI / 180)).translateLocal(0.5f, 0.5f, 0.5f);
    }

    @Override
    public boolean uvLock() {
        return this.uvLock;
    }

    public ResourceLoc.ModelLoc model() {
        return this.model;
    }

    @Override
    public int x() {
        return this.x;
    }

    @Override
    public int y() {
        return this.y;
    }
}

