/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.ResourcePackUpdater;

import com.gtnewhorizon.gtnhlib.client.ResourcePackUpdater.ResourcePackUpdateChecker;
import com.gtnewhorizon.gtnhlib.client.ResourcePackUpdater.RpUpdaterLog;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.client.Minecraft;

public final class ResourcePackUpdateEventHandler {
    private static final Queue<Runnable> TASKS = new ConcurrentLinkedQueue<Runnable>();
    private static final int AUTO_RUN_DELAY_TICKS = 100;
    private boolean pendingAutoRun = false;
    private int autoRunCountdown = 0;

    static void enqueue(Runnable task) {
        if (task != null) {
            TASKS.add(task);
        }
    }

    @SubscribeEvent
    public void onClientConnected(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        this.pendingAutoRun = true;
        this.autoRunCountdown = 100;
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (!this.pendingAutoRun) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e == null || mc.field_71439_g == null) {
            return;
        }
        if (this.autoRunCountdown > 0) {
            --this.autoRunCountdown;
            return;
        }
        this.pendingAutoRun = false;
        ResourcePackUpdateChecker.runAutoCheckIfNeeded();
    }

    @SubscribeEvent
    public void onClientTickQueue(TickEvent.ClientTickEvent event) {
        Runnable task;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        while ((task = TASKS.poll()) != null) {
            try {
                task.run();
            }
            catch (Exception e) {
                RpUpdaterLog.warn("Task execution failed: {}", e.toString());
            }
        }
    }
}

