/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.ResourcePackUpdater;

import com.gtnewhorizon.gtnhlib.GTNHLibConfig;
import com.gtnewhorizon.gtnhlib.client.ResourcePackUpdater.ChatNotifier;
import com.gtnewhorizon.gtnhlib.client.ResourcePackUpdater.GitHubReleaseClient;
import com.gtnewhorizon.gtnhlib.client.ResourcePackUpdater.PackMcmetaReader;
import com.gtnewhorizon.gtnhlib.client.ResourcePackUpdater.PackVersion;
import com.gtnewhorizon.gtnhlib.client.ResourcePackUpdater.ReleaseMatch;
import com.gtnewhorizon.gtnhlib.client.ResourcePackUpdater.RpUpdaterLog;
import com.gtnewhorizon.gtnhlib.client.ResourcePackUpdater.UpdaterMeta;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.ResourcePackRepository;

public final class ResourcePackUpdateChecker {
    private static final long FAILURE_COOLDOWN_MILLIS = 1800000L;
    private static final long MANUAL_COOLDOWN_MILLIS = 30000L;
    private static boolean hasRunThisSession = false;
    private static long lastFailureMillis = 0L;
    private static long lastManualMillis = 0L;
    private static long lastCheckMillis = 0L;
    private static final Set<String> mismatchNotified = new HashSet<String>();
    private static final AtomicBoolean checkInProgress = new AtomicBoolean(false);

    private ResourcePackUpdateChecker() {
    }

    public static void runAutoCheckIfNeeded() {
        if (hasRunThisSession) {
            return;
        }
        hasRunThisSession = true;
        if (!GTNHLibConfig.enableResourcePackUpdateCheck) {
            RpUpdaterLog.debug("Auto-check skipped (disabled in config)", new Object[0]);
            return;
        }
        ResourcePackUpdateChecker.runCheckAsync(false, false);
    }

    public static CheckResult runManualCheck(boolean force) {
        if (!force && ResourcePackUpdateChecker.isManualOnCooldown()) {
            ChatNotifier.sendManualCooldown();
            return new CheckResult();
        }
        lastManualMillis = System.currentTimeMillis();
        ResourcePackUpdateChecker.runCheckAsync(force, true);
        return new CheckResult();
    }

    private static void runCheckAsync(boolean force, boolean isManual) {
        if (!checkInProgress.compareAndSet(false, true)) {
            RpUpdaterLog.debug("Update check already in progress", new Object[0]);
            if (isManual) {
                ChatNotifier.sendAlreadyRunning();
            }
            return;
        }
        if (ResourcePackUpdateChecker.isOnCooldown() && !force) {
            if (isManual) {
                ChatNotifier.sendCooldownMessage();
            }
            RpUpdaterLog.debug("Check skipped due to cooldown", new Object[0]);
            checkInProgress.set(false);
            return;
        }
        String playerLine = ResourcePackUpdateChecker.getPlayerLineNormalized();
        List<IResourcePack> packs = ResourcePackUpdateChecker.getEnabledPacks();
        if (isManual) {
            ChatNotifier.sendChecking();
        }
        Thread worker = new Thread(() -> ResourcePackUpdateChecker.runCheckWorker(packs, playerLine, isManual), "GTNHLib-RPUpdater");
        worker.setDaemon(true);
        worker.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runCheckWorker(List<IResourcePack> packs, String playerLine, boolean isManual) {
        try {
            RpUpdaterLog.debug("Starting update check (player line: {})", playerLine);
            CheckResult result = new CheckResult();
            List<UpdaterMeta> metas = ResourcePackUpdateChecker.scanEnabledPacks(packs, result);
            HashMap<RepoKey, Optional<ReleaseMatch>> releaseCache = new HashMap<RepoKey, Optional<ReleaseMatch>>();
            for (UpdaterMeta meta : metas) {
                ResourcePackUpdateChecker.checkOnePack(meta, playerLine, releaseCache, result);
            }
            if (isManual && result.updatesFound == 0) {
                ChatNotifier.sendNoUpdatesFound();
            }
        }
        finally {
            lastCheckMillis = System.currentTimeMillis();
            checkInProgress.set(false);
        }
    }

    private static List<IResourcePack> getEnabledPacks() {
        ResourcePackRepository repo = Minecraft.func_71410_x().func_110438_M();
        List entries = repo.func_110613_c();
        ArrayList<IResourcePack> packs = new ArrayList<IResourcePack>(entries.size());
        for (ResourcePackRepository.Entry entry : entries) {
            IResourcePack pack = entry.func_110514_c();
            if (pack == null) continue;
            packs.add(pack);
        }
        return packs;
    }

    private static List<UpdaterMeta> scanEnabledPacks(List<IResourcePack> packs, CheckResult result) {
        result.packsScanned = packs.size();
        ArrayList<UpdaterMeta> metas = new ArrayList<UpdaterMeta>();
        for (IResourcePack pack : packs) {
            Optional<UpdaterMeta> meta = PackMcmetaReader.readUpdaterMeta(pack);
            if (!meta.isPresent()) continue;
            ++result.packsWithUpdater;
            metas.add(meta.get());
            RpUpdaterLog.debug("Found updater metadata in pack {}", pack.func_130077_b());
        }
        RpUpdaterLog.debug("Scanned {} packs ({} with updater metadata)", result.packsScanned, result.packsWithUpdater);
        return metas;
    }

    private static void checkOnePack(UpdaterMeta meta, String playerLine, Map<RepoKey, Optional<ReleaseMatch>> cache, CheckResult result) {
        Optional<ReleaseMatch> match;
        String targetLine;
        String installedLine = meta.packGameVersion;
        List<String> installedLines = ResourcePackUpdateChecker.parseLineList(installedLine);
        String string = targetLine = "unknown".equals(playerLine) ? ResourcePackUpdateChecker.firstLineOrUnknown(installedLines) : playerLine;
        if (!"unknown".equals(playerLine) && !ResourcePackUpdateChecker.containsLine(installedLines, playerLine) && mismatchNotified.add(meta.packName)) {
            ChatNotifier.sendLineMismatch(meta.packName, installedLine, playerLine);
        }
        if (!(match = ResourcePackUpdateChecker.getNewestRelease(meta, targetLine, cache, result)).isPresent()) {
            RpUpdaterLog.debug("No compatible release for {} on {}", meta.packName, targetLine);
            return;
        }
        ReleaseMatch release = match.get();
        try {
            PackVersion installed = PackVersion.parse(meta.packVersion);
            PackVersion remote = PackVersion.parse(release.packVersion);
            if (remote.compareTo(installed) > 0) {
                ChatNotifier.sendUpdateMessage(meta.packName, meta.packVersion, release.packVersion, release.htmlUrl);
                ++result.updatesFound;
            } else {
                RpUpdaterLog.debug("No update for {} (installed {}, remote {})", meta.packName, meta.packVersion, release.packVersion);
            }
        }
        catch (IllegalArgumentException e) {
            RpUpdaterLog.warn("Invalid pack version for {}: {}", meta.packName, e.toString());
        }
    }

    private static Optional<ReleaseMatch> getNewestRelease(UpdaterMeta meta, String targetLine, Map<RepoKey, Optional<ReleaseMatch>> cache, CheckResult result) {
        RepoKey key = new RepoKey(meta.owner, meta.repo, targetLine);
        if (cache.containsKey(key)) {
            return cache.get(key);
        }
        try {
            Optional<ReleaseMatch> match = GitHubReleaseClient.findNewestCompatibleRelease(meta.owner, meta.repo, targetLine);
            cache.put(key, match);
            return match;
        }
        catch (Exception e) {
            result.hadFailure = true;
            lastFailureMillis = System.currentTimeMillis();
            RpUpdaterLog.warn("GitHub request failed for {}/{}: {}", meta.owner, meta.repo, e.toString());
            return Optional.empty();
        }
    }

    private static boolean isOnCooldown() {
        if (lastFailureMillis == 0L) {
            return false;
        }
        return System.currentTimeMillis() - lastFailureMillis < 1800000L;
    }

    private static boolean isManualOnCooldown() {
        if (lastManualMillis == 0L) {
            return false;
        }
        return System.currentTimeMillis() - lastManualMillis < 30000L;
    }

    private static List<String> parseLineList(String field) {
        ArrayList<String> lines = new ArrayList<String>();
        if (field == null) {
            return lines;
        }
        for (String part : field.split(";")) {
            String trimmed = part.trim();
            if (trimmed.isEmpty()) continue;
            lines.add(trimmed);
        }
        return lines;
    }

    private static boolean containsLine(List<String> lines, String target) {
        if (lines == null || target == null) {
            return false;
        }
        for (String line : lines) {
            if (!line.equals(target)) continue;
            return true;
        }
        return false;
    }

    private static String firstLineOrUnknown(List<String> lines) {
        if (lines == null || lines.isEmpty()) {
            return "unknown";
        }
        return lines.get(0);
    }

    private static String getPlayerLineNormalized() {
        String version = ResourcePackUpdateChecker.readModpackVersion();
        if (version == null) {
            return "unknown";
        }
        if (version.startsWith("2.8")) {
            return "2.8.X";
        }
        if (version.startsWith("2.9")) {
            return "2.9.X";
        }
        if (version.matches("\\d+\\.\\d+\\.X")) {
            return version;
        }
        return "unknown";
    }

    private static String readModpackVersion() {
        try {
            Class<?> refstrings = Class.forName("com.dreammaster.lib.Refstrings");
            return (String)refstrings.getField("MODPACKPACK_VERSION").get(null);
        }
        catch (Exception e) {
            RpUpdaterLog.debug("Refstrings not available: {}", e.toString());
            return null;
        }
    }

    public static List<PackSummary> getActivePackSummaries() {
        List<IResourcePack> packs = ResourcePackUpdateChecker.getEnabledPacks();
        ArrayList<PackSummary> summaries = new ArrayList<PackSummary>(packs.size());
        for (IResourcePack pack : packs) {
            Optional<UpdaterMeta> meta = PackMcmetaReader.readUpdaterMeta(pack);
            if (meta.isPresent()) {
                UpdaterMeta updater = meta.get();
                summaries.add(new PackSummary(pack.func_130077_b(), true, updater.packName, updater.packVersion, updater.packGameVersion, updater.owner, updater.repo));
                continue;
            }
            summaries.add(new PackSummary(pack.func_130077_b(), false, null, null, null, null, null));
        }
        return summaries;
    }

    public static StatusSnapshot getStatusSnapshot() {
        long now = System.currentTimeMillis();
        long failureRemaining = Math.max(0L, lastFailureMillis + 1800000L - now);
        long manualRemaining = Math.max(0L, lastManualMillis + 30000L - now);
        return new StatusSnapshot(checkInProgress.get(), lastCheckMillis, failureRemaining, manualRemaining);
    }

    public static final class CheckResult {
        public int packsScanned;
        public int packsWithUpdater;
        public int updatesFound;
        public boolean cooldownBlocked;
        public boolean hadFailure;
    }

    private static final class RepoKey {
        private final String owner;
        private final String repo;
        private final String targetLine;

        private RepoKey(String owner, String repo, String targetLine) {
            this.owner = owner;
            this.repo = repo;
            this.targetLine = targetLine;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof RepoKey)) {
                return false;
            }
            RepoKey other = (RepoKey)obj;
            return this.owner.equals(other.owner) && this.repo.equals(other.repo) && this.targetLine.equals(other.targetLine);
        }

        public int hashCode() {
            int result = this.owner.hashCode();
            result = 31 * result + this.repo.hashCode();
            result = 31 * result + this.targetLine.hashCode();
            return result;
        }
    }

    public static final class PackSummary {
        public final String packDisplayName;
        public final boolean hasUpdater;
        public final String updaterPackName;
        public final String packVersion;
        public final String packGameVersion;
        public final String owner;
        public final String repo;

        private PackSummary(String packDisplayName, boolean hasUpdater, String updaterPackName, String packVersion, String packGameVersion, String owner, String repo) {
            this.packDisplayName = packDisplayName;
            this.hasUpdater = hasUpdater;
            this.updaterPackName = updaterPackName;
            this.packVersion = packVersion;
            this.packGameVersion = packGameVersion;
            this.owner = owner;
            this.repo = repo;
        }
    }

    public static final class StatusSnapshot {
        public final boolean running;
        public final long lastCheckMillis;
        public final long failureCooldownRemainingMillis;
        public final long manualCooldownRemainingMillis;

        private StatusSnapshot(boolean running, long lastCheckMillis, long failureCooldownRemainingMillis, long manualCooldownRemainingMillis) {
            this.running = running;
            this.lastCheckMillis = lastCheckMillis;
            this.failureCooldownRemainingMillis = failureCooldownRemainingMillis;
            this.manualCooldownRemainingMillis = manualCooldownRemainingMillis;
        }
    }
}

