/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.ResourcePackUpdater;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.gtnewhorizon.gtnhlib.client.ResourcePackUpdater.RpUpdaterLog;
import com.gtnewhorizon.gtnhlib.client.ResourcePackUpdater.UpdaterMeta;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import net.minecraft.client.resources.IResourcePack;

final class PackMcmetaReader {
    private static final String UPDATER_KEY = "gtnh_resource_pack_updater";
    private static final String SOURCE_TYPE_GITHUB = "github_releases";
    private static final String[] INPUT_STREAM_METHODS = new String[]{"getInputStreamByName", "func_110591_a"};

    private PackMcmetaReader() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Optional<UpdaterMeta> readUpdaterMeta(IResourcePack pack) {
        try (InputStream stream = PackMcmetaReader.openPackMcmeta(pack);){
            if (stream == null) {
                Optional<UpdaterMeta> optional = Optional.empty();
                return optional;
            }
            JsonElement rootElement = new JsonParser().parse((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8));
            if (!rootElement.isJsonObject()) {
                RpUpdaterLog.warn("pack.mcmeta root is not an object for pack {}", pack.func_130077_b());
                Optional<UpdaterMeta> optional = Optional.empty();
                return optional;
            }
            JsonObject root = rootElement.getAsJsonObject();
            if (!root.has(UPDATER_KEY) || !root.get(UPDATER_KEY).isJsonObject()) {
                Optional<UpdaterMeta> optional = Optional.empty();
                return optional;
            }
            JsonObject updater = root.getAsJsonObject(UPDATER_KEY);
            int schema = PackMcmetaReader.readRequiredInt(updater, "schema", pack.func_130077_b());
            if (schema != 1) {
                RpUpdaterLog.warn("Unsupported updater schema {} in pack {}", schema, pack.func_130077_b());
                Optional<UpdaterMeta> optional = Optional.empty();
                return optional;
            }
            String packName = PackMcmetaReader.readRequiredString(updater, "pack_name", pack.func_130077_b());
            String packVersion = PackMcmetaReader.readRequiredString(updater, "pack_version", pack.func_130077_b());
            String packGameVersion = PackMcmetaReader.readRequiredString(updater, "pack_game_version", pack.func_130077_b());
            if (!updater.has("source") || !updater.get("source").isJsonObject()) {
                RpUpdaterLog.warn("Missing source object in pack {}", pack.func_130077_b());
                Optional<UpdaterMeta> optional = Optional.empty();
                return optional;
            }
            JsonObject source = updater.getAsJsonObject("source");
            String sourceType = PackMcmetaReader.readRequiredString(source, "type", pack.func_130077_b());
            if (!SOURCE_TYPE_GITHUB.equals(sourceType)) {
                RpUpdaterLog.warn("Unsupported source type {} in pack {}", sourceType, pack.func_130077_b());
                Optional<UpdaterMeta> optional = Optional.empty();
                return optional;
            }
            String owner = PackMcmetaReader.readRequiredString(source, "owner", pack.func_130077_b());
            String repo = PackMcmetaReader.readRequiredString(source, "repo", pack.func_130077_b());
            Optional<UpdaterMeta> optional = Optional.of(new UpdaterMeta(packName, packVersion, packGameVersion, sourceType, owner, repo));
            return optional;
        }
        catch (IOException e) {
            RpUpdaterLog.warn("Failed reading pack.mcmeta for pack {}: {}", pack.func_130077_b(), e.toString());
            return Optional.empty();
        }
        catch (RuntimeException e) {
            RpUpdaterLog.warn("Invalid pack.mcmeta for pack {}: {}", pack.func_130077_b(), e.toString());
            return Optional.empty();
        }
    }

    private static InputStream openPackMcmeta(IResourcePack pack) throws IOException {
        Method method = PackMcmetaReader.findGetInputStreamByName(pack.getClass());
        if (method == null) {
            RpUpdaterLog.warn("Unable to read pack.mcmeta for pack {} (no access method)", pack.func_130077_b());
            return null;
        }
        try {
            return (InputStream)method.invoke((Object)pack, "pack.mcmeta");
        }
        catch (Exception e) {
            RpUpdaterLog.warn("Failed opening pack.mcmeta for pack {}: {}", pack.func_130077_b(), e.toString());
            return null;
        }
    }

    private static Method findGetInputStreamByName(Class<?> type) {
        for (Class<?> current = type; current != null; current = current.getSuperclass()) {
            for (String name : INPUT_STREAM_METHODS) {
                try {
                    Method method = current.getDeclaredMethod(name, String.class);
                    method.setAccessible(true);
                    return method;
                }
                catch (NoSuchMethodException method) {
                }
            }
            for (Method method : current.getDeclaredMethods()) {
                Class<?>[] params = method.getParameterTypes();
                if (params.length != 1 || params[0] != String.class || !InputStream.class.isAssignableFrom(method.getReturnType())) continue;
                method.setAccessible(true);
                return method;
            }
        }
        return null;
    }

    private static String readRequiredString(JsonObject obj, String field, String packName) {
        if (!obj.has(field)) {
            throw new IllegalArgumentException("Missing " + field + " in pack " + packName);
        }
        return obj.get(field).getAsString();
    }

    private static int readRequiredInt(JsonObject obj, String field, String packName) {
        if (!obj.has(field)) {
            throw new IllegalArgumentException("Missing " + field + " in pack " + packName);
        }
        return obj.get(field).getAsInt();
    }
}

