/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.chat.customcomponents;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.gtnewhorizon.gtnhlib.chat.AbstractChatComponentCustom;
import com.gtnewhorizon.gtnhlib.util.numberformatting.NumberFormatUtil;
import java.math.BigDecimal;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractChatComponentNumber
extends AbstractChatComponentCustom {
    protected BigDecimal number = BigDecimal.ZERO;

    public AbstractChatComponentNumber() {
    }

    public AbstractChatComponentNumber(Number number) {
        this.number = NumberFormatUtil.bigDecimalConverter(number);
    }

    protected abstract String formatNumber(Number var1);

    public final String func_150261_e() {
        return this.formatNumber(this.number);
    }

    @Override
    @NotNull
    public JsonElement serialize() {
        JsonObject obj = new JsonObject();
        this.serializeNumber(obj, this.number);
        return obj;
    }

    @Override
    public void deserialize(@NotNull JsonElement jsonElement) {
        JsonObject obj = jsonElement.getAsJsonObject();
        this.number = this.deserializeNumber(obj);
    }

    private void serializeNumber(@NotNull JsonObject obj, @NotNull BigDecimal num) {
        obj.addProperty("number", num.stripTrailingZeros().toPlainString());
    }

    private BigDecimal deserializeNumber(@NotNull JsonObject obj) {
        return new BigDecimal(obj.get("number").getAsString());
    }
}

