/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.blockstate.properties;

import com.gtnewhorizon.gtnhlib.blockstate.core.BlockProperty;
import com.gtnewhorizon.gtnhlib.blockstate.core.BlockPropertyTrait;
import com.gtnewhorizon.gtnhlib.blockstate.core.MetaBlockProperty;
import java.lang.reflect.Type;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public interface IntegerBlockProperty
extends BlockProperty<Integer> {
    @Override
    default public Type getType() {
        return Integer.TYPE;
    }

    default public BlockProperty<String> map(List<String> values) {
        return new MappedBlockProperty(this, values);
    }

    public static IntegerBlockProperty meta(String name, int mask, int shift) {
        return new MetaIntegerBlockProperty(name, mask, shift);
    }

    public static class MappedBlockProperty
    implements BlockProperty<String>,
    MetaBlockProperty<String> {
        private final IntegerBlockProperty base;
        private final List<String> values;

        public MappedBlockProperty(IntegerBlockProperty base, List<String> values) {
            this.base = base;
            this.values = values;
        }

        @Override
        public String getName() {
            return this.base.getName();
        }

        @Override
        public Type getType() {
            return String.class;
        }

        @Override
        public boolean hasTrait(BlockPropertyTrait trait) {
            if (trait == BlockPropertyTrait.Transformable) {
                return false;
            }
            return this.base.hasTrait(trait);
        }

        @Override
        public String getValue(IBlockAccess world, int x, int y, int z) {
            return BlockProperty.getIndexSafe(this.values, (int)((Integer)this.base.getValue(world, x, y, z)));
        }

        @Override
        public void setValue(World world, int x, int y, int z, String value) {
            this.base.setValue(world, x, y, z, this.values.indexOf(value));
        }

        @Override
        public String getValue(ItemStack stack) {
            return BlockProperty.getIndexSafe(this.values, (int)((Integer)this.base.getValue(stack)));
        }

        @Override
        public void setValue(ItemStack stack, String value) {
            this.base.setValue(stack, this.values.indexOf(value));
        }

        @Override
        public boolean needsExisting() {
            return ((MetaBlockProperty)((Object)this.base)).needsExisting();
        }

        @Override
        public int getMeta(String value, int existing) {
            return ((MetaBlockProperty)((Object)this.base)).getMeta(this.values.indexOf(value), existing);
        }

        @Override
        public String getValue(int meta) {
            return this.values.get((Integer)((MetaBlockProperty)((Object)this.base)).getValue(meta));
        }
    }

    public static class MetaIntegerBlockProperty
    implements IntegerBlockProperty,
    MetaBlockProperty<Integer> {
        private final String name;
        private final int mask;
        private final int shift;

        public MetaIntegerBlockProperty(String name, int mask, int shift) {
            this.name = name;
            this.mask = mask;
            this.shift = shift;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean hasTrait(BlockPropertyTrait trait) {
            boolean bl;
            switch (trait) {
                case SupportsWorld: 
                case SupportsStacks: 
                case OnlyNeedsMeta: 
                case WorldMutable: 
                case StackMutable: {
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            return bl;
        }

        @Override
        public boolean needsExisting() {
            return this.mask != -1;
        }

        @Override
        public int getMeta(Integer value, int existing) {
            int meta = existing & ~this.mask;
            return meta |= value << this.shift & this.mask;
        }

        @Override
        public Integer getValue(int meta) {
            return (meta & this.mask) >> this.shift;
        }
    }
}

