/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.blockstate.core;

import com.gtnewhorizon.gtnhlib.blockstate.core.BlockProperty;
import com.gtnewhorizon.gtnhlib.blockstate.core.BlockPropertyTrait;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;

public interface MetaBlockProperty<T>
extends BlockProperty<T> {
    public int getMeta(T var1, int var2);

    public T getValue(int var1);

    @Override
    default public boolean appliesTo(IBlockAccess world, int x, int y, int z, Block block, int meta, @Nullable TileEntity tile) {
        return this.appliesTo(meta);
    }

    @Override
    default public boolean appliesTo(ItemStack stack, Item item, int meta) {
        return this.appliesTo(item.func_77647_b(meta));
    }

    default public boolean appliesTo(int meta) {
        return true;
    }

    default public boolean needsExisting() {
        return true;
    }

    @Override
    default public T getValue(IBlockAccess world, int x, int y, int z) {
        if (!this.hasTrait(BlockPropertyTrait.SupportsWorld)) {
            throw new UnsupportedOperationException();
        }
        return this.getValue(world.func_72805_g(x, y, z));
    }

    @Override
    default public void setValue(World world, int x, int y, int z, T value) {
        if (!this.hasTrait(BlockPropertyTrait.SupportsWorld)) {
            throw new UnsupportedOperationException();
        }
        boolean needsExisting = this.needsExisting();
        int existing = needsExisting ? world.func_72805_g(x, y, z) : 0;
        int meta = this.getMeta(value, existing);
        if (!needsExisting || existing != meta) {
            world.func_72921_c(x, y, z, meta, 2);
        }
    }

    @Override
    default public T getValue(ItemStack stack) {
        if (!this.hasTrait(BlockPropertyTrait.SupportsStacks)) {
            throw new UnsupportedOperationException();
        }
        int meta = stack.func_77973_b().func_77647_b(stack.func_77960_j());
        return this.getValue(meta);
    }

    @Override
    default public void setValue(ItemStack stack, T t) {
        if (!this.hasTrait(BlockPropertyTrait.SupportsStacks)) {
            throw new UnsupportedOperationException();
        }
        int meta = this.needsExisting() ? stack.func_77973_b().func_77647_b(stack.func_77960_j()) : 0;
        meta = this.getMeta(t, meta);
        stack.func_77964_b(((ItemBlock)stack.func_77973_b()).field_150939_a.func_149692_a(meta));
    }
}

