/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.blockstate.command;

import com.gtnewhorizon.gtnhlib.GTNHLib;
import com.gtnewhorizon.gtnhlib.blockstate.core.BlockProperty;
import com.gtnewhorizon.gtnhlib.blockstate.registry.BlockPropertyRegistry;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;

public class BlockStateCommand
extends CommandBase {
    public String func_71517_b() {
        return "blockstate";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/blockstate <get|set> [property name] [property value]";
    }

    public List<String> func_71514_a() {
        return new ArrayList<String>();
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        if (!(sender instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)sender;
        String action = BlockProperty.getIndexSafe(args, 0);
        String name = BlockProperty.getIndexSafe(args, 1);
        String value = BlockProperty.getIndexSafe(args, 2);
        if (action == null || "set".equals(action) && name != null && value == null) {
            BlockStateCommand.sendErrorToPlayer(sender, this.func_71518_a(sender));
            return;
        }
        MovingObjectPosition hit = BlockStateCommand.getHitResult(player);
        if (hit == null || hit.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
            BlockStateCommand.sendErrorToPlayer(sender, "You must be looking at a block to use this command.");
            return;
        }
        Object2ObjectOpenHashMap properties = new Object2ObjectOpenHashMap();
        BlockPropertyRegistry.getProperties((IBlockAccess)player.field_70170_p, hit.field_72311_b, hit.field_72312_c, hit.field_72309_d, properties);
        if ("get".equals(action)) {
            if (name != null) {
                BlockProperty prop = (BlockProperty)properties.get(name);
                if (prop != null) {
                    Object v = prop.getValue((IBlockAccess)player.field_70170_p, hit.field_72311_b, hit.field_72312_c, hit.field_72309_d);
                    BlockStateCommand.sendChatToPlayer(sender, prop.getName() + ": " + prop.stringify(v));
                    return;
                }
                BlockStateCommand.sendErrorToPlayer(sender, "Property not found.");
            } else {
                BlockStateCommand.sendChatToPlayer((ICommandSender)player, "Properties:");
                if (properties.isEmpty()) {
                    BlockStateCommand.sendChatToPlayer((ICommandSender)player, "None");
                    return;
                }
                for (Map.Entry e : properties.entrySet()) {
                    BlockProperty prop = (BlockProperty)e.getValue();
                    Object v = prop.getValue((IBlockAccess)player.field_70170_p, hit.field_72311_b, hit.field_72312_c, hit.field_72309_d);
                    BlockStateCommand.sendChatToPlayer((ICommandSender)player, prop.getName() + ": " + prop.stringify(v));
                }
            }
        } else {
            BlockProperty prop = (BlockProperty)properties.get(name);
            if (prop != null) {
                try {
                    Object v = prop.parse(value);
                    prop.setValue(player.field_70170_p, hit.field_72311_b, hit.field_72312_c, hit.field_72309_d, v);
                }
                catch (Throwable t) {
                    GTNHLib.LOG.error("Error setting property {}", new Object[]{name, t});
                    BlockStateCommand.sendErrorToPlayer((ICommandSender)player, "Error setting property: " + t.getMessage());
                }
                return;
            }
            BlockStateCommand.sendErrorToPlayer(sender, "Property not found.");
        }
    }

    private static MovingObjectPosition getHitResult(EntityPlayer player) {
        double d;
        if (player instanceof EntityPlayerMP) {
            EntityPlayerMP mp = (EntityPlayerMP)player;
            d = mp.field_71134_c.getBlockReachDistance();
        } else {
            d = Minecraft.func_71410_x().field_71442_b.func_78757_d();
        }
        double reachDistance = d;
        Vec3 posVec = Vec3.func_72443_a((double)player.field_70165_t, (double)(player.field_70163_u + (double)player.func_70047_e()), (double)player.field_70161_v);
        Vec3 lookVec = player.func_70676_i(1.0f);
        Vec3 modifiedPosVec = posVec.func_72441_c(lookVec.field_72450_a * reachDistance, lookVec.field_72448_b * reachDistance, lookVec.field_72449_c * reachDistance);
        MovingObjectPosition hit = player.field_70170_p.func_72901_a(posVec, modifiedPosVec, true);
        return hit != null && hit.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK ? null : hit;
    }

    private static void sendErrorToPlayer(ICommandSender sender, String aChatMessage) {
        sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + aChatMessage));
    }

    private static void sendChatToPlayer(ICommandSender sender, String aChatMessage) {
        sender.func_145747_a((IChatComponent)new ChatComponentText(aChatMessage));
    }
}

