/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.blockpos;

import com.google.common.collect.AbstractIterator;
import com.gtnewhorizon.gtnhlib.blockpos.IMutableBlockPos;
import com.gtnewhorizon.gtnhlib.util.CoordinatePacker;
import java.util.Iterator;
import net.minecraft.world.ChunkPosition;
import net.minecraftforge.common.util.ForgeDirection;
import org.joml.Vector3i;

public class BlockPos
extends Vector3i
implements IMutableBlockPos {
    public BlockPos() {
    }

    public BlockPos(int x, int y, int z) {
        super(x, y, z);
    }

    public BlockPos(ChunkPosition chunkPosition) {
        super(chunkPosition.field_151329_a, chunkPosition.field_151327_b, chunkPosition.field_151328_c);
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getZ() {
        return this.z;
    }

    @Override
    public BlockPos offset(ForgeDirection d) {
        return new BlockPos(this.x + d.offsetX, this.y + d.offsetY, this.z + d.offsetZ);
    }

    @Override
    public BlockPos offset(int x, int y, int z) {
        return new BlockPos(this.x + x, this.y + y, this.z + z);
    }

    @Override
    public BlockPos down() {
        return this.offset(ForgeDirection.DOWN);
    }

    @Override
    public BlockPos up() {
        return this.offset(ForgeDirection.UP);
    }

    @Override
    public BlockPos copy() {
        return new BlockPos(this.x, this.y, this.z);
    }

    @Override
    public long asLong() {
        return CoordinatePacker.pack(this.x, this.y, this.z);
    }

    @Override
    public BlockPos set(int x, int y, int z) {
        super.set(x, y, z);
        return this;
    }

    @Override
    public BlockPos set(long packedPos) {
        CoordinatePacker.unpack(packedPos, this);
        return this;
    }

    @Override
    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ")";
    }

    public static Iterable<BlockPos> getAllInBox(BlockPos from, BlockPos to) {
        return BlockPos.getAllInBox(Math.min(from.getX(), to.getX()), Math.min(from.getY(), to.getY()), Math.min(from.getZ(), to.getZ()), Math.max(from.getX(), to.getX()), Math.max(from.getY(), to.getY()), Math.max(from.getZ(), to.getZ()));
    }

    public static Iterable<BlockPos> getAllInBox(final int xMin, final int yMin, final int zMin, final int xMax, final int yMax, final int zMax) {
        return new Iterable<BlockPos>(){

            @Override
            public Iterator<BlockPos> iterator() {
                return new AbstractIterator<BlockPos>(){
                    private BlockPos pos;

                    protected BlockPos computeNext() {
                        if (this.pos == null) {
                            this.pos = new BlockPos(xMin, yMin, zMin);
                            return this.pos;
                        }
                        if (this.pos.x == xMax && this.pos.y == yMax && this.pos.z == zMax) {
                            return (BlockPos)this.endOfData();
                        }
                        if (this.pos.x < xMax) {
                            ++this.pos.x;
                        } else if (this.pos.y < yMax) {
                            this.pos.x = xMin;
                            ++this.pos.y;
                        } else if (this.pos.z < zMax) {
                            this.pos.x = xMin;
                            this.pos.y = yMin;
                            ++this.pos.z;
                        }
                        return this.pos;
                    }
                };
            }
        };
    }
}

